/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes;

import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import net.minecraft.util.ResourceLocation;

public class ActionRemoveRecipeByName
extends ActionRecipeBase {
    private final ResourceLocation name;

    public ActionRemoveRecipeByName(IRecipeManager manager, ResourceLocation name) {
        super(manager);
        this.name = name;
    }

    @Override
    public void apply() {
        this.getRecipes().remove(this.name);
    }

    @Override
    public String describe() {
        return "Removing \"" + this.getRecipeTypeName() + "\" recipe with name: \"" + this.name + "\"";
    }

    @Override
    public boolean validate(ILogger logger) {
        boolean containsKey = this.getRecipes().containsKey(this.name);
        if (!containsKey) {
            logger.warning("No recipe with type: \"" + this.getRecipeTypeName() + "\" and name: \"" + this.name + "\"");
        }
        return containsKey;
    }
}

