/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.crafttweaker.conflict;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.commands.CTRecipeTypeArgument;
import com.blamejared.crafttweaker.impl.commands.CommandUtilities;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.conflict.DescriptiveFilter;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.conflict.RecipeLongIterator;
import com.blamejared.crafttweaker.impl.helper.ThreadingHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.apache.logging.log4j.util.TriConsumer;

public final class ConflictCommand {
    private static final ExecutorService OFF_THREAD_SERVICE = Executors.newFixedThreadPool(1, r -> {
        Thread t = new Thread(r, "crafttweaker:conflict_resolution_thread");
        t.setDaemon(true);
        t.setContextClassLoader(ConflictCommand.class.getClassLoader());
        return t;
    });

    private ConflictCommand() {
    }

    public static void registerConflictCommands(TriConsumer<LiteralArgumentBuilder<CommandSource>, String, String> registerCustomCommand) {
        registerCustomCommand.accept((Object)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"conflicts").then(Commands.func_197056_a((String)"type", (ArgumentType)CTRecipeTypeArgument.INSTANCE).executes(context -> ConflictCommand.conflicts((PlayerEntity)((CommandSource)context.getSource()).func_197035_h(), DescriptiveFilter.of((IRecipeManager)context.getArgument("type", IRecipeManager.class)))))).then(Commands.func_197057_a((String)"hand").executes(context -> ConflictCommand.ifNotEmpty((CommandContext<CommandSource>)context, (player, item) -> ConflictCommand.conflicts(player, DescriptiveFilter.of(item)))))).executes(context -> ConflictCommand.conflicts((PlayerEntity)((CommandSource)context.getSource()).func_197035_h(), DescriptiveFilter.of())), (Object)"conflicts", (Object)"Identifies and reports conflicts between various recipes");
    }

    private static int ifNotEmpty(CommandContext<CommandSource> source, ToIntBiFunction<PlayerEntity, ItemStack> command) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)source.getSource()).func_197035_h();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            CommandUtilities.send(CommandUtilities.color("No item in hand: unable to check conflicts for an empty item", TextFormatting.RED), (PlayerEntity)player);
            return -1;
        }
        return command.applyAsInt((PlayerEntity)player, stack);
    }

    private static int conflicts(PlayerEntity player, DescriptiveFilter filter) {
        CommandUtilities.send((ITextComponent)new StringTextComponent(String.format("Conflict testing%s has begun: ", filter.description())).func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent("do not /reload the server or quit the world in the meantime").func_240699_a_(TextFormatting.RED)), player);
        ConflictCommand.runConflicts(player, player.field_70170_p.func_199532_z(), filter);
        return 0;
    }

    private static void runConflicts(PlayerEntity player, RecipeManager manager, DescriptiveFilter filter) {
        Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipes = ConflictCommand.deepCopy(manager.field_199522_d, filter);
        LogicalSide side = EffectiveSide.get();
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> ConflictCommand.computeConflicts(recipes), OFF_THREAD_SERVICE).thenAcceptAsync(message -> ConflictCommand.dispatchCompletionTo(message, player, side), (Executor)OFF_THREAD_SERVICE)).exceptionally(exception -> ConflictCommand.dispatchExceptionTo(exception, player, side));
    }

    private static Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> deepCopy(Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> original, DescriptiveFilter filter) {
        HashMap clone = new HashMap();
        original.forEach((type, map) -> {
            Map cloneMap = clone.computeIfAbsent((IRecipeType<?>)type, it -> new HashMap());
            map.entrySet().stream().filter(filter).forEach(it -> {
                IRecipe cfr_ignored_0 = (IRecipe)cloneMap.put(it.getKey(), it.getValue());
            });
        });
        return clone;
    }

    private static String computeConflicts(Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipes) {
        return recipes.entrySet().stream().flatMap(ConflictCommand::computeConflictsFor).map(it -> "- " + it).collect(Collectors.joining("\n"));
    }

    private static Stream<String> computeConflictsFor(Map.Entry<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> entry) {
        IRecipeManager manager = RecipeTypeBracketHandler.getOrDefault(entry.getKey());
        if (manager == null || entry.getValue().size() == 1) {
            return Stream.empty();
        }
        ArrayList recipes = new ArrayList(entry.getValue().entrySet());
        RecipeLongIterator iterator = new RecipeLongIterator(recipes.size());
        int characteristics = 1300;
        return StreamSupport.longStream(Spliterators.spliterator(iterator, iterator.estimateLength(), 1300), false).filter(it -> ConflictCommand.conflictsWith(manager, (IRecipe)((Map.Entry)recipes.get(RecipeLongIterator.first(it))).getValue(), (IRecipe)((Map.Entry)recipes.get(RecipeLongIterator.second(it))).getValue())).mapToObj(it -> ConflictCommand.formatConflict(manager, (ResourceLocation)((Map.Entry)recipes.get(RecipeLongIterator.first(it))).getKey(), (ResourceLocation)((Map.Entry)recipes.get(RecipeLongIterator.second(it))).getKey()));
    }

    private static <T extends IRecipe<?>> boolean conflictsWith(IRecipeManager manager, T first, IRecipe<?> second) {
        return first != second && CraftTweakerRegistry.getHandlerFor(first).doesConflict(manager, first, second);
    }

    private static String formatConflict(IRecipeManager manager, ResourceLocation firstName, ResourceLocation secondName) {
        return String.format("Recipes '%s' and '%s' in type '%s' have conflicting inputs", firstName, secondName, manager.getCommandString());
    }

    private static void dispatchCompletionTo(String message, PlayerEntity player, LogicalSide side) {
        ThreadingHelper.runOnMainThread(side, () -> {
            try {
                CraftTweakerAPI.logDump(message.isEmpty() ? "No conflicts identified" : message, new Object[0]);
                CommandUtilities.send(CommandUtilities.color("Conflict testing completed: results are in crafttweaker.log", TextFormatting.GREEN), player);
            }
            catch (Exception e) {
                try {
                    CraftTweakerAPI.logThrowing("An error occurred while reporting conflicts, hopefully it does not happen again", e, new Object[0]);
                }
                catch (Exception another) {
                    e.addSuppressed(another);
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    private static Void dispatchExceptionTo(Throwable exception, PlayerEntity player, LogicalSide side) {
        ThreadingHelper.runOnMainThread(side, () -> {
            try {
                CraftTweakerAPI.logThrowing("Unable to verify for conflicts due to an exception", exception, new Object[0]);
                CommandUtilities.send(CommandUtilities.color("An error has occurred during conflict testing: please check the logs", TextFormatting.RED), player);
            }
            catch (Exception e) {
                try {
                    CraftTweakerAPI.logThrowing("An error occurred while reporting conflicts, hopefully it does not happen again", e, new Object[0]);
                }
                catch (Exception another) {
                    e.addSuppressed(another);
                    e.printStackTrace(System.err);
                }
            }
        });
        return null;
    }
}

