/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.data;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.ICollectionData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.INumberData;
import com.blamejared.crafttweaker.impl.data.ByteData;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.ByteArrayData")
@ZenRegister
@Document(value="vanilla/api/data/ByteArrayData")
public class ByteArrayData
implements ICollectionData {
    private final ByteArrayNBT internal;

    public ByteArrayData(ByteArrayNBT internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public ByteArrayData(byte[] internal) {
        this.internal = new ByteArrayNBT(internal);
    }

    @Override
    public IData copy() {
        return new ByteArrayData(this.getInternal());
    }

    @Override
    public IData copyInternal() {
        return new ByteArrayData((ByteArrayNBT)this.getInternal().func_74737_b());
    }

    public ByteArrayNBT getInternal() {
        return this.internal;
    }

    @Override
    public IData setAt(int index, IData value) {
        if (value instanceof NumberNBT) {
            return new ByteData(this.getInternal().set(index, ByteNBT.func_229671_a_((byte)((INumberData)value).getByte())));
        }
        return null;
    }

    @Override
    public void add(int index, IData value) {
        if (value instanceof INumberData) {
            this.getInternal().add(index, ByteNBT.func_229671_a_((byte)((INumberData)value).getByte()));
        }
    }

    @Override
    public void add(IData value) {
        if (value instanceof INumberData) {
            this.getInternal().add((Object)ByteNBT.func_229671_a_((byte)((INumberData)value).getByte()));
        }
    }

    @Override
    public IData remove(int index) {
        return new ByteData(this.getInternal().remove(index));
    }

    @Override
    public IData getAt(int index) {
        return new ByteData(this.getInternal().get(index));
    }

    @Override
    public int size() {
        return this.getInternal().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public void clear() {
        this.getInternal().clear();
    }

    @Override
    public String asString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        boolean first = true;
        for (ByteNBT nbt : this.getInternal()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(nbt.func_150290_f());
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public ITextComponent asFormattedComponent(String indentation, int indentDepth) {
        IFormattableTextComponent as = new StringTextComponent(" as ").func_240699_a_(IData.SYNTAX_HIGHLIGHTING_AS);
        IFormattableTextComponent baseType = new StringTextComponent("byte").func_240699_a_(IData.SYNTAX_HIGHLIGHTING_TYPE);
        IFormattableTextComponent type = new StringTextComponent("byte[]").func_240699_a_(IData.SYNTAX_HIGHLIGHTING_TYPE);
        StringTextComponent component = new StringTextComponent("[");
        for (int i = 0; i < this.size(); ++i) {
            IFormattableTextComponent child = new StringTextComponent(this.getAt(i).toJsonString()).func_240699_a_(IData.SYNTAX_HIGHLIGHTING_NUMBER);
            component.func_240702_b_(i == 0 ? "" : " ").func_230529_a_((ITextComponent)child);
            if (i == this.size() - 1) continue;
            component.func_240702_b_(",");
        }
        component.func_240702_b_("]").func_230529_a_((ITextComponent)as).func_230529_a_((ITextComponent)type);
        return component;
    }

    @Override
    public List<IData> asList() {
        byte[] byteArray = this.getInternal().func_150292_c();
        ArrayList<IData> out = new ArrayList<IData>(byteArray.length);
        for (byte b : byteArray) {
            out.add(new ByteData(b));
        }
        return out;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayData that = (ByteArrayData)o;
        return this.internal.equals((Object)that.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }
}

