/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item.transformed;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformer;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.impl.item.transformed.IngredientTransformed;
import com.blamejared.crafttweaker.impl.item.transformed.MCIngredientTransformed;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public enum IngredientTransformedSerializer implements IIngredientSerializer<IngredientTransformed<?, ?>>
{
    INSTANCE;


    public JsonObject toJson(IngredientTransformed<?, ?> ingredientVanillaPlus) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("base", ((MCIngredientTransformed)ingredientVanillaPlus.getCrTIngredient()).getBaseIngredient().asVanillaIngredient().func_200304_c());
        IIngredientTransformer<?> transformer = ingredientVanillaPlus.getTransformer();
        JsonObject value = transformer.toJson();
        if (!value.has("type")) {
            value.addProperty("type", transformer.getType().toString());
        }
        jsonObject.add("transformer", (JsonElement)value);
        return jsonObject;
    }

    public IngredientTransformed<?, ?> parse(PacketBuffer buffer) {
        IIngredient base = IIngredient.fromIngredient(Ingredient.func_199566_b((PacketBuffer)buffer));
        ResourceLocation type = buffer.func_192575_l();
        IIngredientTransformerSerializer value = (IIngredientTransformerSerializer)CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER.func_82594_a(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientTransformed(new MCIngredientTransformed<IIngredient>(base, (IIngredientTransformer<IIngredient>)value.parse(buffer)));
    }

    public IngredientTransformed<?, ?> parse(JsonObject json) {
        JsonObject base = json.getAsJsonObject("base");
        IIngredient baseIngredient = IIngredient.fromIngredient(CraftingHelper.getIngredient((JsonElement)base));
        JsonObject transformer = json.getAsJsonObject("transformer");
        ResourceLocation type = new ResourceLocation(transformer.get("type").getAsString());
        IIngredientTransformerSerializer value = (IIngredientTransformerSerializer)CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER.func_82594_a(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientTransformed(new MCIngredientTransformed<IIngredient>(baseIngredient, (IIngredientTransformer<IIngredient>)value.parse(transformer)));
    }

    public void write(PacketBuffer buffer, IngredientTransformed<?, ?> ingredient) {
        Ingredient baseIngredient = ((MCIngredientTransformed)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient();
        baseIngredient.func_199564_a(buffer);
        IIngredientTransformer<?> transformer = ingredient.getTransformer();
        IIngredientTransformerSerializer serializer = transformer.getSerializer();
        buffer.func_192572_a(serializer.getType());
        transformer.write(buffer);
    }
}

