/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.vanilla;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.CTLootConditionBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.vanilla.Alternative")
@Document(value="vanilla/api/loot/conditions/vanilla/Alternative")
public final class AlternativeLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private final CTLootConditionBuilder parent;
    private final List<ILootCondition> subConditions;

    AlternativeLootConditionTypeBuilder(CTLootConditionBuilder parent) {
        this.parent = parent;
        this.subConditions = new ArrayList<ILootCondition>();
    }

    @ZenCodeType.Method
    public <T extends ILootConditionTypeBuilder> AlternativeLootConditionTypeBuilder add(Class<T> reifiedType, Consumer<T> lender) {
        ILootCondition subCondition = this.parent.make(reifiedType, "Alternative", lender);
        if (subCondition != null) {
            this.subConditions.add(subCondition);
        }
        return this;
    }

    @Override
    public ILootCondition finish() {
        if (this.subConditions.isEmpty()) {
            CraftTweakerAPI.logWarning("An 'Alternative' loot condition has no conditions: this will never match!", new Object[0]);
        } else if (this.subConditions.size() == 1) {
            CraftTweakerAPI.logWarning("An 'Alternative' loot condition has only one condition: this is equivalent to the condition itself", new Object[0]);
        }
        return context -> this.subConditions.stream().anyMatch(it -> it.test(context));
    }
}

