/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.vanilla;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.predicate.StatePropertiesPredicate;
import com.blamejared.crafttweaker.impl_native.loot.ExpandLootContext;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.vanilla.BlockStateProperty")
@Document(value="vanilla/api/loot/conditions/vanilla/BlockStateProperty")
public final class BlockStatePropertyLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private Block block;
    private StatePropertiesPredicate predicate = new StatePropertiesPredicate();

    BlockStatePropertyLootConditionTypeBuilder() {
    }

    @ZenCodeType.Method
    public BlockStatePropertyLootConditionTypeBuilder withBlock(Block block) {
        this.block = block;
        return this;
    }

    @ZenCodeType.Method
    public BlockStatePropertyLootConditionTypeBuilder withStatePropertiesPredicate(Consumer<StatePropertiesPredicate> builder) {
        StatePropertiesPredicate predicate = new StatePropertiesPredicate();
        builder.accept(predicate);
        this.predicate = predicate;
        return this;
    }

    @Override
    public ILootCondition finish() {
        if (this.block == null) {
            throw new IllegalStateException("'BlockStateProperty' condition requires a block to be specified");
        }
        return context -> {
            BlockState state = ExpandLootContext.getBlockState(context);
            return state != null && state.func_177230_c() == this.block && this.predicate.matchProperties(state.func_177230_c().func_176194_O(), state);
        };
    }
}

