/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.native_types;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.native_types.CrTNativeExecutableRef;
import com.blamejared.crafttweaker.impl.native_types.CrTNativeExecutableRefs;
import com.blamejared.crafttweaker.impl.native_types.CrTNativeTypeInfo;
import com.blamejared.crafttweaker_annotations.annotations.NativeConstructor;
import com.blamejared.crafttweaker_annotations.annotations.NativeMethod;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class NativeTypeRegistry {
    private final Map<Class<?>, CrTNativeTypeInfo> nativeTypeInfos = new HashMap();

    private static Class<?>[] convertConstructorToClassArray(NativeConstructor nativeConstructor) {
        return (Class[])Arrays.stream(nativeConstructor.value()).map(NativeConstructor.ConstructorParameter::type).toArray(Class[]::new);
    }

    public void addNativeType(NativeTypeRegistration registration, NativeMethod[] nativeMethods) {
        Class<?> vanillaClass = registration.value();
        String crtName = registration.zenCodeName();
        Map<String, CrTNativeExecutableRefs> executables = this.getNativeExecutables(registration, nativeMethods);
        if (this.nativeTypeInfos.containsKey(vanillaClass) && !this.nativeTypeInfos.get(vanillaClass).getCraftTweakerName().equals(crtName)) {
            String format = "Trying to register vanilla class '%s' twice with different names: '%s' and '%s'";
            CrTNativeTypeInfo existingNativeTypeInfo = this.nativeTypeInfos.get(vanillaClass);
            CraftTweakerAPI.logError("Trying to register vanilla class '%s' twice with different names: '%s' and '%s'", vanillaClass.getCanonicalName(), existingNativeTypeInfo.getCraftTweakerName(), crtName);
        } else {
            this.nativeTypeInfos.put(vanillaClass, new CrTNativeTypeInfo(vanillaClass, crtName, executables));
        }
    }

    private Map<String, CrTNativeExecutableRefs> getNativeExecutables(NativeTypeRegistration registration, NativeMethod[] nativeMethods) {
        HashMap<String, CrTNativeExecutableRefs> result = new HashMap<String, CrTNativeExecutableRefs>();
        for (NativeConstructor nativeConstructor : registration.constructors()) {
            Class<?>[] classes = NativeTypeRegistry.convertConstructorToClassArray(nativeConstructor);
            result.computeIfAbsent("<init>", i -> new CrTNativeExecutableRefs()).createForSignature(classes).withConstructorAnnotation();
        }
        for (Annotation annotation : nativeMethods) {
            result.computeIfAbsent(annotation.name(), i -> new CrTNativeExecutableRefs()).createForSignature(annotation.parameters()).withGetter(annotation.getterName()).withSetter(annotation.setterName()).withMethodAnnotation();
        }
        return result;
    }

    public boolean hasInfoFor(Class<?> clazz) {
        return this.nativeTypeInfos.containsKey(clazz);
    }

    public String getCrTNameFor(Class<?> clazz) {
        return this.getTypeInfoFor(clazz).getCraftTweakerName();
    }

    public Collection<CrTNativeTypeInfo> getNativeTypeInfos() {
        return this.nativeTypeInfos.values();
    }

    public CrTNativeTypeInfo getTypeInfoFor(Class<?> clazz) {
        return this.nativeTypeInfos.get(clazz);
    }

    public Optional<CrTNativeExecutableRef> getMethodInfoFor(Constructor<?> constructor) {
        if (this.hasInfoFor(constructor.getDeclaringClass())) {
            return this.getTypeInfoFor(constructor.getDeclaringClass()).getMethod(constructor);
        }
        return Optional.empty();
    }

    public Optional<CrTNativeExecutableRef> getMethodInfoFor(Method method) {
        if (this.hasInfoFor(method.getDeclaringClass())) {
            return this.getTypeInfoFor(method.getDeclaringClass()).getMethod(method);
        }
        return Optional.empty();
    }
}

