/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.helper.CraftTweakerHelper;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker.impl.predicate.NBTPredicate;
import com.blamejared.crafttweaker.impl.predicate.StatePropertiesPredicate;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.BlockPredicate")
@Document(value="vanilla/api/predicate/BlockPredicate")
public final class BlockPredicate
extends IVanillaWrappingPredicate.AnyDefaulting<net.minecraft.advancements.criterion.BlockPredicate> {
    private Block block;
    private MCTag<Block> blockTag;
    private NBTPredicate data = new NBTPredicate();
    private StatePropertiesPredicate states = new StatePropertiesPredicate();

    public BlockPredicate() {
        super(net.minecraft.advancements.criterion.BlockPredicate.field_226231_a_);
    }

    @ZenCodeType.Method
    public BlockPredicate withBlock(Block block) {
        this.block = block;
        return this;
    }

    @ZenCodeType.Method
    public BlockPredicate withBlockTag(MCTag<Block> blockTag) {
        this.blockTag = blockTag;
        return this;
    }

    @ZenCodeType.Method
    public BlockPredicate withDataPredicate(Consumer<NBTPredicate> builder) {
        NBTPredicate predicate = new NBTPredicate();
        builder.accept(predicate);
        this.data = predicate;
        return this;
    }

    @ZenCodeType.Method
    public BlockPredicate withStatePropertiesPredicate(Consumer<StatePropertiesPredicate> builder) {
        StatePropertiesPredicate predicate = new StatePropertiesPredicate();
        builder.accept(predicate);
        this.states = predicate;
        return this;
    }

    @Override
    public boolean isAny() {
        return this.block == null && this.blockTag == null && this.data.isAny() && this.states.isAny();
    }

    @Override
    public net.minecraft.advancements.criterion.BlockPredicate toVanilla() {
        if (this.blockTag != null && this.block != null) {
            CraftTweakerAPI.logWarning("'BlockPredicate' specifies both a block and a tag: the second will take precedence", new Object[0]);
        }
        return new net.minecraft.advancements.criterion.BlockPredicate(this.blockTag != null ? CraftTweakerHelper.getITag(this.blockTag) : null, this.block, (net.minecraft.advancements.criterion.StatePropertiesPredicate)this.states.toVanillaPredicate(), (net.minecraft.advancements.criterion.NBTPredicate)this.data.toVanillaPredicate());
    }
}

