/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.inventory;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/inventory/IInventory")
@NativeTypeRegistration(value=IInventory.class, zenCodeName="crafttweaker.api.inventory.IInventory")
public class ExpandIInventory {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="inventorySize")
    public static int getInventorySize(IInventory internal) {
        return internal.func_70302_i_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isEmpty")
    public static boolean isEmpty(IInventory internal) {
        return internal.func_191420_l();
    }

    @ZenCodeType.Method
    public static IItemStack getStackInSlot(IInventory internal, int index) {
        return new MCItemStack(internal.func_70301_a(index));
    }

    @ZenCodeType.Method
    public static IItemStack decrStackSize(IInventory internal, int index, @ZenCodeType.OptionalInt(value=1) int count) {
        return new MCItemStack(internal.func_70298_a(index, count));
    }

    @ZenCodeType.Method
    public static IItemStack removeStackFromSlot(IInventory internal, int index) {
        return new MCItemStack(internal.func_70304_b(index));
    }

    @ZenCodeType.Method
    public static void setInventorySlotContents(IInventory internal, int index, IItemStack stack) {
        internal.func_70299_a(index, stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="inventoryStackLimit")
    public static int getInventoryStackLimit(IInventory internal) {
        return internal.func_70297_j_();
    }

    @ZenCodeType.Method
    public static void markDirty(IInventory internal) {
        internal.func_70296_d();
    }

    @ZenCodeType.Method
    public static boolean isUsableByPlayer(IInventory internal, PlayerEntity player) {
        return internal.func_70300_a(player);
    }

    @ZenCodeType.Method
    public static void openInventory(IInventory internal, PlayerEntity player) {
        internal.func_174889_b(player);
    }

    @ZenCodeType.Method
    public static void closeInventory(IInventory internal, PlayerEntity player) {
        internal.func_174886_c(player);
    }

    @ZenCodeType.Method
    public static boolean isItemValidForSlot(IInventory internal, int index, IItemStack stack) {
        return internal.func_94041_b(index, stack.getInternal());
    }

    @ZenCodeType.Method
    public static int count(IInventory internal, Item item) {
        return internal.func_213901_a(item);
    }

    @ZenCodeType.Method
    public static int count(IInventory internal, Predicate<IItemStack> predicate) {
        int count = 0;
        for (int i = 0; i < internal.func_70302_i_(); ++i) {
            ItemStack itemstack = internal.func_70301_a(i);
            if (!predicate.test(new MCItemStack(itemstack))) continue;
            count += itemstack.func_190916_E();
        }
        return count;
    }

    @ZenCodeType.Method
    public static List<IItemStack> getStacks(IInventory internal, Predicate<IItemStack> predicate) {
        ArrayList<IItemStack> stacks = new ArrayList<IItemStack>();
        for (int i = 0; i < internal.func_70302_i_(); ++i) {
            MCItemStack stack = new MCItemStack(internal.func_70301_a(i));
            if (!predicate.test(stack)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    @ZenCodeType.Method
    public static boolean hasAny(IInventory internal, List<Item> list) {
        return internal.func_213902_a(new HashSet<Item>(list));
    }

    @ZenCodeType.Method
    public static void clear(IInventory internal) {
        internal.func_174888_l();
    }
}

