/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui;

import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.PopupMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class UpdaterRegistry {
    private List<Updater<?>> updaters = new ArrayList();

    public <T> Updater<T> create() {
        Updater u = new Updater();
        this.updaters.add(u);
        return u;
    }

    public <T> Updater<T> create(T def) {
        Updater u = new Updater();
        u.defValue = def;
        u.hasDefault = true;
        this.updaters.add(u);
        return u;
    }

    public BooleanUpdater createBool(boolean def) {
        BooleanUpdater u = new BooleanUpdater(def);
        this.updaters.add(u);
        return u;
    }

    public <T> UpdaterWithValue<T> createValue(T def) {
        UpdaterWithValue<T> u = new UpdaterWithValue<T>(def);
        this.updaters.add(u);
        return u;
    }

    public void setDefault() {
        this.updaters.forEach(Updater::setDefault);
    }

    public void reset() {
        this.updaters.forEach(u -> u.setters.clear());
    }

    public static <T> Updater<T> makeStatic(final Supplier<T> value) {
        return new Updater<T>(){

            @Override
            public void add(Consumer<T> c) {
                c.accept(value.get());
            }
        };
    }

    public static class BooleanUpdater
    extends Updater<Boolean> {
        private boolean value;

        public BooleanUpdater(boolean def) {
            this.value = def;
        }

        public void toggle() {
            this.value = !this.value;
            this.accept(this.value);
        }

        public boolean get() {
            return this.value;
        }

        @Override
        public void add(Consumer<Boolean> c) {
            super.add(c);
            c.accept(this.value);
        }

        public Checkbox makeCheckbox(PopupMenu pp, String name) {
            Checkbox c = pp.addCheckbox(name, this::toggle);
            this.add(c::setSelected);
            return c;
        }
    }

    public static class UpdaterWithValue<T>
    extends Updater<T>
    implements Supplier<T> {
        private T value;

        public UpdaterWithValue(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void accept(T t) {
            super.accept(t);
            this.value = t;
        }

        @Override
        public void add(Consumer<T> c) {
            super.add(c);
            c.accept(this.value);
        }
    }

    public static class Updater<T>
    implements Consumer<T> {
        protected List<Consumer<T>> setters = new ArrayList<Consumer<T>>();
        protected T defValue;
        protected boolean hasDefault;

        private Updater() {
        }

        @Override
        public void accept(T t) {
            this.setters.forEach(s -> s.accept(t));
        }

        public void add(Consumer<T> c) {
            this.setters.add(c);
        }

        public void add(Runnable c) {
            this.add((T v) -> c.run());
        }

        public void setDefault() {
            if (this.hasDefault) {
                this.accept(this.defValue);
            }
        }
    }
}

