/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.function.FloatUnaryOperator;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.elements.Spinner;
import java.util.function.Function;

public class ComboSlider
extends Slider {
    private Spinner spinner;
    private Function<Float, String> valueToString;
    private FloatUnaryOperator value;
    private FloatUnaryOperator normalize;

    public ComboSlider(IGui gui, Function<Float, String> valueToString, FloatUnaryOperator value, FloatUnaryOperator normalize) {
        super(gui, valueToString.apply(Float.valueOf(0.0f)));
        this.valueToString = valueToString;
        this.value = value;
        this.normalize = normalize;
        this.spinner = new Spinner(gui);
        this.spinner.addChangeListener(this::updateSpinner);
        this.spinner.visible = false;
    }

    private void updateSpinner() {
        float max = this.value.apply(1.0f);
        if (this.spinner.getValue() > max) {
            this.spinner.setValue(max);
        }
        float min = this.value.apply(0.0f);
        if (this.spinner.getValue() < min) {
            this.spinner.setValue(min);
        }
        this.setValue0(this.normalize.apply(this.spinner.getValue()));
        this.onAction();
    }

    public void setActualValue(float v) {
        this.setValue0(this.normalize.apply(v));
        this.spinner.setValue(v);
    }

    @Override
    public void setValue(float v) {
        this.setValue0(v);
        this.spinner.setValue(this.value.apply(v));
    }

    private void setValue0(float v) {
        super.setValue(v);
        this.setText(this.valueToString.apply(Float.valueOf(this.getActualValue())));
    }

    public float getActualValue() {
        return this.value.apply(this.getValue());
    }

    @Override
    protected void onAction() {
        this.setText(this.valueToString.apply(Float.valueOf(this.getActualValue())));
        super.onAction();
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (this.spinner.visible) {
            this.spinner.mouseClick(event);
        }
        if (event.isHovered(this.bounds)) {
            if (event.btn == 1) {
                this.spinner.setValue(this.getActualValue());
                this.spinner.setBounds(this.bounds);
                this.spinner.visible = true;
                event.consume();
            }
        } else if (!event.isConsumed() && this.spinner.visible) {
            this.spinner.visible = false;
            this.setActualValue(this.spinner.getValue());
            this.onAction();
            event.consume();
        }
        super.mouseClick(event);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (this.spinner.visible) {
            this.spinner.keyPressed(event);
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        if (this.spinner.visible) {
            this.spinner.draw(event, partialTicks);
        } else {
            super.draw(event, partialTicks);
        }
    }

    public Spinner getSpinner() {
        return this.spinner;
    }
}

