/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;

public class ScrollPanel
extends Panel {
    private Panel display;
    private int xScroll;
    private int yScroll;
    private int enableDrag;
    private int dragX;
    private int dragY;
    private int xScOld;
    private int yScOld;
    private boolean scrollBarSide;

    public ScrollPanel(IGui gui) {
        super(gui);
    }

    @Override
    public void mouseWheel(MouseEvent event) {
        this.display.mouseWheel(event.offset(this.bounds).offset(-this.xScroll, -this.yScroll));
        if (!event.isConsumed() && event.isInBounds(this.bounds)) {
            if (this.gui.isShiftDown()) {
                int newScroll = this.xScroll - event.btn * 5;
                this.setScrollX(newScroll);
                if ((float)this.bounds.w / (float)this.display.getBounds().w < 1.0f) {
                    event.consume();
                }
            } else {
                int newScroll = this.yScroll - event.btn * 5;
                this.setScrollY(newScroll);
                if ((float)this.bounds.h / (float)this.display.getBounds().h < 1.0f) {
                    event.consume();
                }
            }
        }
    }

    public void setDisplay(Panel display) {
        this.display = display;
    }

    @Override
    public void draw(MouseEvent evt, float partialTicks) {
        Box bar;
        float scroll;
        this.gui.pushMatrix();
        Box bounds = this.getBounds();
        this.gui.setPosOffset(bounds);
        if (this.display.backgroundColor != 0) {
            this.gui.drawBox(0, 0, bounds.w, bounds.h, this.display.backgroundColor);
        }
        this.gui.setupCut();
        Box b = this.display.getBounds();
        this.gui.setPosOffset(new Box(-this.xScroll, -this.yScroll, b.w, b.h));
        MouseEvent de = evt;
        if (!evt.isHovered(bounds)) {
            de = evt.cancelled();
        }
        this.display.draw(de.offset(bounds.x - this.xScroll, bounds.y - this.yScroll), partialTicks);
        this.gui.popMatrix();
        this.gui.pushMatrix();
        this.gui.setPosOffset(bounds);
        this.gui.setupCut();
        float overflowX = (float)bounds.w / (float)this.display.getBounds().w;
        float overflowY = (float)bounds.h / (float)this.display.getBounds().h;
        int scx = this.scrollBarSide ? 0 : bounds.w - 3;
        int scy = bounds.h - 4;
        if (overflowY < 1.0f) {
            float h = Math.max(overflowY * (float)bounds.h, 8.0f);
            scroll = (float)this.yScroll / (float)(this.display.getBounds().h - bounds.h);
            int y = (int)(scroll * ((float)bounds.h - h));
            bar = new Box(bounds.x + scx, bounds.y + y, 3, (int)h);
            this.gui.drawBox(scx, 0, 3, bounds.h, this.gui.getColors().panel_background);
            this.gui.drawBox((float)scx, (float)y, 3.0f, h, evt.isHovered(bar) || this.enableDrag == 1 ? this.gui.getColors().button_hover : this.gui.getColors().button_disabled);
        }
        if (overflowX < 1.0f) {
            float w = Math.max(overflowX * (float)bounds.w, 8.0f);
            scroll = (float)this.xScroll / (float)(this.display.getBounds().w - bounds.w);
            int x = (int)(scroll * ((float)bounds.w - w));
            bar = new Box(bounds.x + x, bounds.y + scy, (int)w, 3);
            this.gui.drawBox((float)x, (float)scy, w, 4.0f, this.gui.getColors().panel_background);
            this.gui.drawBox((float)x, (float)scy, w, 4.0f, evt.isHovered(bar) || this.enableDrag == 2 ? this.gui.getColors().button_hover : this.gui.getColors().button_disabled);
        }
        this.gui.popMatrix();
        this.gui.setupCut();
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (event.offset(this.bounds).isHovered(new Box(this.scrollBarSide ? 0 : this.bounds.w - 3, 0, 3, this.bounds.h))) {
            this.dragX = event.x;
            this.dragY = event.y;
            this.xScOld = this.xScroll;
            this.yScOld = this.yScroll;
            this.enableDrag = 1;
            event.consume();
        }
        if (event.offset(this.bounds).isHovered(new Box(0, this.bounds.h - 4, this.bounds.w, 3))) {
            this.dragX = event.x;
            this.dragY = event.y;
            this.xScOld = this.xScroll;
            this.yScOld = this.yScroll;
            this.enableDrag = 2;
            event.consume();
        }
        MouseEvent e = event.offset(this.bounds).offset(-this.xScroll, -this.yScroll);
        if (!event.isInBounds(this.bounds)) {
            e = e.cancelled();
        }
        this.display.mouseClick(e);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        this.display.keyPressed(event);
    }

    @Override
    public void mouseDrag(MouseEvent event) {
        if (this.enableDrag != 0) {
            switch (this.enableDrag) {
                case 1: {
                    int drag = (int)((float)(event.y - this.dragY) / (float)this.bounds.h * (float)this.display.getBounds().h);
                    int newScroll = this.yScOld + drag;
                    this.setScrollY(newScroll);
                    break;
                }
                case 2: {
                    int drag = (int)((float)(event.x - this.dragX) / (float)this.bounds.w * (float)this.display.getBounds().w);
                    int newScroll = this.xScOld + drag;
                    this.setScrollX(newScroll);
                    break;
                }
            }
            event.consume();
        } else {
            this.display.mouseDrag(event.offset(this.bounds).offset(-this.xScroll, -this.yScroll));
        }
    }

    @Override
    public void mouseRelease(MouseEvent event) {
        if (this.enableDrag != 0) {
            this.enableDrag = 0;
            event.consume();
        } else {
            this.display.mouseRelease(event.offset(this.bounds).offset(-this.xScroll, -this.yScroll));
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.display != null) {
            this.display.setVisible(visible);
        }
    }

    public void setScrollBarSide(boolean scrollBarSide) {
        this.scrollBarSide = scrollBarSide;
    }

    public void setScrollX(int newScroll) {
        float overflowY = (float)this.bounds.h / (float)this.display.getBounds().h;
        int xe = -1;
        if (overflowY < 1.0f) {
            xe = 3;
        }
        this.xScroll = MathHelper.clamp(newScroll, 0, Math.max(this.display.getBounds().w - this.bounds.w + xe, 0));
    }

    public void setScrollY(int newScroll) {
        float overflowX = (float)this.bounds.w / (float)this.display.getBounds().w;
        int ye = -1;
        if (overflowX < 1.0f) {
            ye = 3;
        }
        this.yScroll = MathHelper.clamp(newScroll, 0, Math.max(this.display.getBounds().h - this.bounds.h + ye, 0));
    }

    public int getScrollX() {
        return this.xScroll;
    }

    public int getScrollY() {
        return this.yScroll;
    }

    public Panel getDisplay() {
        return this.display;
    }
}

