/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.math;

import com.tom.cpl.util.Direction;

public class BoundingBox {
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    public BoundingBox(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public static BoundingBox create(float x, float y, float z, float w, float h, float d) {
        return new BoundingBox(x, y, z, x + w, y + h, z + d);
    }

    public BoundingBox mul(float v) {
        return new BoundingBox(this.minX * v, this.minY * v, this.minZ * v, this.maxX * v, this.maxY * v, this.maxZ * v);
    }

    public BoundingBox offset(float x, float y, float z) {
        return new BoundingBox(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public BoundingBox getFaceOnly(Direction d) {
        float x = this.minX;
        float y = this.minY;
        float z = this.minZ;
        switch (d) {
            case DOWN: {
                y = this.maxY;
            }
            case UP: {
                return new BoundingBox(this.minX, y, this.minZ, this.maxX, y, this.maxZ);
            }
            case SOUTH: {
                z = this.maxZ;
            }
            case NORTH: {
                return new BoundingBox(this.minX, this.minY, z, this.maxX, this.maxY, z);
            }
            case EAST: {
                x = this.maxX;
            }
            case WEST: {
                return new BoundingBox(x, this.minY, this.minZ, x, this.maxY, this.maxZ);
            }
        }
        throw new IllegalArgumentException("Unknown direction");
    }
}

