/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.api;

import com.tom.cpl.math.MathHelper;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.api.CPMApiManager;
import com.tom.cpm.api.ICPMPlugin;
import com.tom.cpm.api.ICommonAPI;
import com.tom.cpm.api.SharedApi;
import com.tom.cpm.shared.MinecraftServerAccess;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.packet.PluginMessageS2C;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class CommonApi
extends SharedApi
implements ICommonAPI {
    private Map<String, BiConsumer<Object, NBTTagCompound>> pluginMessageHandlers = new HashMap<String, BiConsumer<Object, NBTTagCompound>>();

    @Override
    protected void callInit0(ICPMPlugin plugin) {
        plugin.initCommon(this);
    }

    protected CommonApi() {
    }

    @Override
    public <P> void setPlayerModel(Class<P> playerClass, P player, String b64, boolean forced, boolean persistent) {
        if (this.checkClass(playerClass, SharedApi.Clazz.PLAYER)) {
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.setSkin(player, b64, forced, persistent);
    }

    @Override
    public <P> void setPlayerModel(Class<P> playerClass, P player, ModelFile model, boolean forced) {
        if (this.checkClass(playerClass, SharedApi.Clazz.PLAYER)) {
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.setSkin(player, model.getDataBlock(), forced);
    }

    @Override
    public <P> void resetPlayerModel(Class<P> playerClass, P player) {
        if (this.checkClass(playerClass, SharedApi.Clazz.PLAYER)) {
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.setSkin(player, null, false, true);
    }

    @Override
    public <P> void playerJumped(Class<P> playerClass, P player) {
        if (this.checkClass(playerClass, SharedApi.Clazz.PLAYER)) {
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.onJump(player);
    }

    @Override
    public <P> void playAnimation(Class<P> playerClass, P player, String name, int value) {
        if (this.checkClass(playerClass, SharedApi.Clazz.PLAYER)) {
            return;
        }
        NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
        h.playAnimation(player, name, MathHelper.clamp(value, -1, 255));
    }

    @Override
    public <P> void playAnimation(Class<P> playerClass, P player, String name) {
        this.playAnimation(playerClass, player, name, -1);
    }

    @Override
    public <P> ICommonAPI.MessageSender<P> registerPluginMessage(Class<P> clazz, String messageId, BiConsumer<P, NBTTagCompound> handler) {
        if (this.checkClass(clazz, SharedApi.Clazz.PLAYER)) {
            return null;
        }
        if (this.initingPlugin == null) {
            return null;
        }
        String fullID = this.initingPlugin.getOwnerModId() + ":" + messageId;
        this.pluginMessageHandlers.put(fullID, (a, b) -> handler.accept((Object)a, (NBTTagCompound)b));
        return new SenderImpl(fullID);
    }

    public void handlePacket(String id, NBTTagCompound tag, Object player) {
        BiConsumer<Object, NBTTagCompound> h = this.pluginMessageHandlers.get(id);
        h.accept(player, tag);
    }

    private class SenderImpl<P>
    implements ICommonAPI.MessageSender<P> {
        private final String id;

        public SenderImpl(String id) {
            this.id = id;
        }

        @Override
        public boolean sendMessageTo(P player, NBTTagCompound tag) {
            NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
            NetH.ServerNetH net = h.getSNetH(player);
            if (net.cpm$hasMod()) {
                h.sendPacketTo(net, new PluginMessageS2C(this.id, h.getPlayerId(player), tag));
                return true;
            }
            return false;
        }

        @Override
        public void sendMessageToTracking(P player, NBTTagCompound tag, boolean sendToSelf) {
            NetHandler<?, ?, ?> h = MinecraftServerAccess.get().getNetHandler();
            PluginMessageS2C m = new PluginMessageS2C(this.id, h.getPlayerId(player), tag);
            h.sendPacketToTracking(player, m);
            if (sendToSelf) {
                h.sendPacketTo(h.getSNetH(player), m);
            }
        }
    }

    public static class ApiBuilder {
        private final CPMApiManager api;

        protected ApiBuilder(CPMApiManager api) {
            this.api = api;
            api.common = new CommonApi();
        }

        public <P> ApiBuilder player(Class<P> player) {
            this.api.common.classes.put(SharedApi.Clazz.PLAYER, player);
            return this;
        }

        public void init() {
            this.api.initCommon();
        }
    }
}

