/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.render.RenderTypeBuilder;
import com.tom.cpl.util.DynamicTexture;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.CustomRenderTypes;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.NativeImageIO;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderManager;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.MojangAPI;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.ResourceLocation;

public class MinecraftObject
implements MinecraftClientAccess {
    private final Minecraft mc;
    private final ModelDefinitionLoader<GameProfile> loader;
    private final PlayerRenderManager prm;
    public RenderTypeBuilder<ResourceLocation, RenderType> renderBuilder;

    public MinecraftObject(Minecraft mc) {
        this.mc = mc;
        MinecraftObjectHolder.setClientObject(this);
        this.loader = new ModelDefinitionLoader<GameProfile>(PlayerProfile::new, GameProfile::getId, GameProfile::getName);
        this.prm = new PlayerRenderManager();
        this.renderBuilder = new RenderTypeBuilder();
        this.renderBuilder.register(RenderMode.DEFAULT, RenderType::func_228644_e_, 0);
        this.renderBuilder.register(RenderMode.GLOW, RenderType::func_228652_i_, 1);
        this.renderBuilder.register(RenderMode.COLOR, CustomRenderTypes::entityColorTranslucent, 0);
        this.renderBuilder.register(RenderMode.COLOR_GLOW, CustomRenderTypes::entityColorEyes, 1);
        this.renderBuilder.register(RenderMode.OUTLINE, CustomRenderTypes::linesNoDepth, 2);
    }

    @Override
    public PlayerRenderManager getPlayerRenderManager() {
        return this.prm;
    }

    @Override
    public DynamicTexture.ITexture createTexture() {
        return new DynTexture(this.mc);
    }

    @Override
    public void executeLater(Runnable r) {
        this.mc.execute(r);
    }

    @Override
    public ModelDefinitionLoader<GameProfile> getDefinitionLoader() {
        return this.loader;
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(DefaultPlayerSkin.func_177332_b((UUID)this.mc.func_110432_I().func_148256_e().getId()));
    }

    @Override
    public void setEncodedGesture(int value) {
        Set s = this.mc.field_71474_y.field_178882_aU;
        MinecraftObject.setEncPart(s, value, 0, PlayerModelPart.HAT);
        MinecraftObject.setEncPart(s, value, 1, PlayerModelPart.JACKET);
        MinecraftObject.setEncPart(s, value, 2, PlayerModelPart.LEFT_PANTS_LEG);
        MinecraftObject.setEncPart(s, value, 3, PlayerModelPart.RIGHT_PANTS_LEG);
        MinecraftObject.setEncPart(s, value, 4, PlayerModelPart.LEFT_SLEEVE);
        MinecraftObject.setEncPart(s, value, 5, PlayerModelPart.RIGHT_SLEEVE);
        this.mc.field_71474_y.func_82879_c();
    }

    private static void setEncPart(Set<PlayerModelPart> s, int value, int off, PlayerModelPart part) {
        if ((value & 1 << off) != 0) {
            s.add(part);
        } else {
            s.remove(part);
        }
    }

    @Override
    public boolean isInGame() {
        return this.mc.field_71439_g != null;
    }

    @Override
    public Object getPlayerIDObject() {
        return this.mc.func_110432_I().func_148256_e();
    }

    @Override
    public Object getCurrentPlayerIDObject() {
        return this.mc.field_71439_g != null ? this.mc.field_71439_g.func_146103_bH() : null;
    }

    @Override
    public List<IKeybind> getKeybinds() {
        return KeyBindings.kbs;
    }

    @Override
    public MinecraftClientAccess.ServerStatus getServerSideStatus() {
        return this.mc.field_71439_g != null ? (((NetH)this.mc.func_147114_u()).cpm$hasMod() ? MinecraftClientAccess.ServerStatus.INSTALLED : MinecraftClientAccess.ServerStatus.SKIN_LAYERS_ONLY) : MinecraftClientAccess.ServerStatus.OFFLINE;
    }

    @Override
    public File getGameDir() {
        return this.mc.field_71412_D;
    }

    @Override
    public void openGui(Function<IGui, Frame> creator) {
        this.mc.func_147108_a((Screen)new GuiImpl(creator, this.mc.field_71462_r));
    }

    @Override
    public Runnable openSingleplayer() {
        return () -> this.mc.func_147108_a((Screen)new WorldSelectionScreen(this.mc.field_71462_r));
    }

    @Override
    public NetHandler<?, ?, ?> getNetHandler() {
        return CustomPlayerModelsClient.INSTANCE.netHandler;
    }

    @Override
    public ImageIO.IImageIO getImageIO() {
        return new NativeImageIO();
    }

    @Override
    public MojangAPI getMojangAPI() {
        return new MojangAPI(this.mc.func_110432_I().func_148256_e().getName(), this.mc.func_110432_I().func_148256_e().getId(), this.mc.func_110432_I().func_148254_d());
    }

    @Override
    public void clearSkinCache() {
        MojangAPI.clearYggdrasilCache(this.mc.func_152347_ac());
        this.mc.func_181037_M().clear();
        this.mc.func_181037_M();
    }

    @Override
    public String getConnectedServer() {
        if (this.mc.func_147114_u() == null) {
            return null;
        }
        SocketAddress sa = Platform.getChannel(this.mc.func_147114_u().func_147298_b()).remoteAddress();
        if (sa instanceof InetSocketAddress) {
            return ((InetSocketAddress)sa).getHostString();
        }
        return null;
    }

    @Override
    public List<Object> getPlayers() {
        if (this.mc.func_147114_u() == null) {
            return Collections.emptyList();
        }
        return this.mc.func_147114_u().func_175106_d().stream().map(NetworkPlayerInfo::func_178845_a).collect(Collectors.toList());
    }

    @Override
    public Proxy getProxy() {
        return this.mc.func_110437_J();
    }

    @Override
    public RenderTypeBuilder<?, ?> getRenderBuilder() {
        return this.renderBuilder;
    }

    public static class DynTexture
    implements DynamicTexture.ITexture {
        private final DynamicTexture dynTex = new DynamicTexture(1, 1, true);
        private final ResourceLocation loc;
        private final Minecraft mc;
        private static ResourceLocation bound_loc;

        public DynTexture(Minecraft mc) {
            this.mc = mc;
            this.loc = mc.func_110434_K().func_110578_a("cpm", this.dynTex);
        }

        @Override
        public void bind() {
            bound_loc = this.loc;
            if (this.mc.func_110434_K().func_229267_b_(this.loc) == null) {
                this.mc.func_110434_K().func_229263_a_(this.loc, (Texture)this.dynTex);
            }
        }

        @Override
        public void load(Image texture) {
            NativeImage ni = NativeImageIO.createFromBufferedImage(texture);
            this.dynTex.func_195415_a(ni);
            TextureUtil.func_225680_a_((int)this.dynTex.func_110552_b(), (int)ni.func_195702_a(), (int)ni.func_195714_b());
            this.dynTex.func_110564_a();
        }

        public static ResourceLocation getBoundLoc() {
            return bound_loc;
        }

        @Override
        public void free() {
            this.mc.func_110434_K().func_147645_c(this.loc);
        }

        public DynamicTexture getDynTex() {
            return this.dynTex;
        }
    }
}

