/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.ScaleData;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.network.packet.GestureC2S;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnimationEngine {
    private long tickCounter;
    private float partial;
    private ScaleData modelScale;
    private ScaleData modelScaleToReset;
    private long resetCounter;
    private boolean[] quickAccessPressed = new boolean[6];
    private int gestureAutoResetTimer = -1;
    private byte[] gestureData = new byte[2];

    public void tick() {
        ++this.tickCounter;
        if (MinecraftClientAccess.get().isInGame()) {
            Player<?> player = MinecraftClientAccess.get().getCurrentClientPlayer();
            ModelDefinition def = player.getModelDefinition();
            if (def != null) {
                int lc = def.getAnimations().getLayerCount();
                if (this.gestureData.length != lc) {
                    byte v0 = this.gestureData[0];
                    byte v1 = this.gestureData[1];
                    this.gestureData = new byte[lc];
                    this.gestureData[0] = v0;
                    this.gestureData[1] = v1;
                    ConfigEntry vals = def.getAnimations().getProfileId() != null ? ModConfig.getCommonConfig().getEntry("modelProperties").getEntry(def.getAnimations().getProfileId()).getEntry("values") : null;
                    def.getAnimations().forEachLayer((g, id) -> {
                        if (g.isProperty && vals != null) {
                            float v = vals.getFloat(g.name, (float)g.defVal / 255.0f);
                            this.gestureData[id.intValue()] = (byte)(g.type == AnimationType.VALUE_LAYER ? v * 255.0f : (float)(v > 0.0f ? 1 : 0));
                        } else {
                            this.gestureData[id.intValue()] = g.defVal;
                        }
                    });
                    this.sendGestureData();
                }
                if (player.animState.gestureData == null) {
                    player.animState.gestureData = Arrays.copyOf(this.gestureData, this.gestureData.length);
                    this.sendGestureData();
                }
            }
            if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
                if (def != null && def.doRender()) {
                    player.sendEventSubs();
                    if (this.resetCounter > this.tickCounter) {
                        this.resetCounter = 0L;
                        this.modelScale = this.modelScaleToReset;
                        this.modelScaleToReset = null;
                    }
                    if (!Objects.equals(def.getScale(), this.modelScale)) {
                        this.modelScale = def.getScale();
                        if (this.modelScale == null) {
                            MinecraftClientAccess.get().setModelScale(null);
                        } else {
                            MinecraftClientAccess.get().setModelScale(this.modelScale);
                        }
                    }
                } else if (this.modelScale != null) {
                    MinecraftClientAccess.get().setModelScale(null);
                    this.modelScale = null;
                }
            }
            if (this.gestureAutoResetTimer >= 0) {
                --this.gestureAutoResetTimer;
            }
            if (this.gestureAutoResetTimer == 0 && def != null) {
                this.playGesture(def.getAnimations(), null);
            }
        } else {
            this.modelScale = null;
            Arrays.fill(this.quickAccessPressed, false);
            this.gestureAutoResetTimer = -1;
        }
    }

    public void update(float partial) {
        this.partial = partial;
    }

    public long getTime() {
        return (long)(((float)this.tickCounter + this.partial) * 50.0f);
    }

    public void prepareAnimations(Player<?> player, AnimationMode mode, ModelDefinition def) {
        long time = this.getTime();
        AnimationRegistry reg = def.getAnimations();
        if (mode == AnimationMode.PLAYER) {
            player.animState.preAnimate();
            VanillaPose pose = player.animState.getMainPose(time, reg);
            if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES) && player.animState.gestureData != null && player.animState.gestureData.length > 1) {
                if (player.animState.gestureData[0] == 0) {
                    player.currentPose = pose;
                } else {
                    player.currentPose = reg.getPose(player.animState.gestureData[0], player.currentPose);
                    player.prevPose = pose;
                }
            } else {
                int gesture = player.animState.encodedState;
                if (pose != player.prevPose || gesture == reg.getPoseResetId()) {
                    player.currentPose = pose;
                }
                player.currentPose = reg.getPose(gesture, player.currentPose);
                player.prevPose = pose;
            }
        }
        reg.tickAnimated(time);
    }

    public void handleAnimation(Player<?> player, AnimationMode mode, ModelDefinition def) {
        AnimationHandler h = player.getAnimationHandler(mode);
        try {
            long time = this.getTime();
            AnimationRegistry reg = def.getAnimations();
            switch (mode) {
                case HAND: {
                    def.resetAnimationPos();
                    if (player.animState.vrState == AnimationState.VRState.FIRST_PERSON) {
                        List<IAnimation> a = reg.getPoseAnimations(VanillaPose.VR_FIRST_PERSON);
                        h.addAnimations(a, VanillaPose.VR_FIRST_PERSON);
                    } else {
                        List<IAnimation> a = reg.getPoseAnimations(VanillaPose.FIRST_PERSON_HAND);
                        h.addAnimations(a, VanillaPose.FIRST_PERSON_HAND);
                    }
                    h.animate(player.animState, time);
                    return;
                }
                case PLAYER: {
                    player.animState.preAnimate();
                    if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES) && player.animState.gestureData != null && player.animState.gestureData.length > 1) {
                        List<IAnimation> anim = reg.getPoseAnimations(player.currentPose);
                        h.addAnimations(anim, player.currentPose);
                        player.animState.collectAnimations(p -> h.addAnimations((List<? extends IAnimation>)reg.getPoseAnimations((IPose)p), (IPose)p), reg);
                        h.setGesture(reg.getGesture(player.animState.gestureData[1]));
                        reg.forEachLayer((g, id) -> {
                            if (player.animState.gestureData.length > id) {
                                if (g.type == AnimationType.VALUE_LAYER) {
                                    h.addAnimations(g.animation, new ValueLayerPose((int)id));
                                } else if (player.animState.gestureData[id] != 0) {
                                    h.addAnimations(g.animation, null);
                                }
                            } else if (g.type == AnimationType.VALUE_LAYER) {
                                h.addAnimations(g.animation, new DefaultValuePose(g.defVal));
                            } else if (g.defVal != 0) {
                                h.addAnimations(g.animation, null);
                            }
                        });
                        break;
                    }
                    int gesture = player.animState.encodedState;
                    List<IAnimation> anim = reg.getPoseAnimations(player.currentPose);
                    h.addAnimations(anim, player.currentPose);
                    player.animState.collectAnimations(p -> h.addAnimations((List<? extends IAnimation>)reg.getPoseAnimations((IPose)p), (IPose)p), reg);
                    h.setGesture(reg.getGesture(gesture));
                    break;
                }
                case SKULL: {
                    List<IAnimation> anim = reg.getPoseAnimations(VanillaPose.SKULL_RENDER);
                    List<IAnimation> global = reg.getPoseAnimations(VanillaPose.GLOBAL);
                    h.addAnimations(anim, VanillaPose.SKULL_RENDER);
                    h.addAnimations(global, VanillaPose.GLOBAL);
                    break;
                }
            }
            h.animate(player.animState, time);
        }
        catch (Exception e) {
            Log.warn("Error animating model", e);
            try {
                def.resetAnimationPos();
                h.clear();
            }
            catch (Exception ex) {
                ex.addSuppressed(e);
                Log.error("Error animating model", e);
                def.setError(ex);
            }
        }
    }

    public void handleGuiAnimation(AnimationHandler h, ModelDefinition def) {
        try {
            List<IAnimation> anim = def.getAnimations().getPoseAnimations(VanillaPose.STANDING);
            List<IAnimation> global = def.getAnimations().getPoseAnimations(VanillaPose.GLOBAL);
            h.addAnimations(anim, VanillaPose.STANDING);
            h.addAnimations(global, VanillaPose.GLOBAL);
            h.animate(null, this.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            def.resetAnimationPos();
            h.clear();
        }
    }

    private void onKeybind(int id) {
        ConfigEntry ce;
        String c;
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition();
        if (def != null && (c = (ce = ModConfig.getCommonConfig().getEntry("keybinds")).getString("qa_" + id, null)) != null) {
            Gesture g;
            if (c.startsWith("p")) {
                CustomPose pose = def.getAnimations().getCustomPoses().get(c.substring(1));
                if (pose != null) {
                    this.setCustomPose(def.getAnimations(), pose);
                }
            } else if (c.startsWith("g") && (g = def.getAnimations().getGestures().get(c.substring(1))) != null) {
                this.playGesture(def.getAnimations(), g);
            }
        }
    }

    public void setCustomPose(AnimationRegistry reg, CustomPose pose) {
        this.setCustomPose(reg, pose, true);
    }

    public void setCustomPose(AnimationRegistry reg, CustomPose pose, boolean toggle) {
        int enc;
        MinecraftClientAccess.ServerStatus status = MinecraftClientAccess.get().getServerSideStatus();
        if (status == MinecraftClientAccess.ServerStatus.OFFLINE || status == MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            return;
        }
        int n = enc = pose == null ? reg.getPoseResetId() : reg.getEncoded(pose);
        if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            this.gestureData[0] = pose == null || this.gestureData[0] == enc && toggle ? (byte)0 : (byte)enc;
            this.sendGestureData();
        } else if (enc != -1) {
            if (enc == MinecraftClientAccess.get().getCurrentClientPlayer().animState.encodedState && toggle) {
                enc = reg.getPoseResetId();
            }
            MinecraftClientAccess.get().setEncodedGesture(enc);
        }
    }

    public void playGesture(AnimationRegistry reg, Gesture g) {
        this.playGesture(reg, g, true);
    }

    public void playGesture(AnimationRegistry reg, Gesture g, boolean toggle) {
        int enc;
        MinecraftClientAccess.ServerStatus status = MinecraftClientAccess.get().getServerSideStatus();
        boolean serverGc = MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES);
        if (status == MinecraftClientAccess.ServerStatus.OFFLINE || status == MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            return;
        }
        if (g != null) {
            if (g.getType() == AnimationType.LAYER) {
                if (serverGc) {
                    int id = reg.getLayerId(g);
                    if (id == -1 || id >= this.gestureData.length) {
                        return;
                    }
                    this.gestureData[id] = (byte)(this.gestureData[id] == 0 || !toggle ? 1 : 0);
                    this.sendGestureData();
                }
                return;
            }
        } else if (serverGc) {
            this.gestureData[1] = 0;
            this.sendGestureData();
            return;
        }
        if (g != null && !g.isLoop && ModConfig.getCommonConfig().getBoolean("gestureAutoReset", true)) {
            int len = g.animation.stream().mapToInt(IAnimation::getDuration).max().orElse(-1);
            this.gestureAutoResetTimer = len == -1 ? -1 : (int)Math.ceil((float)len / 50.0f) + 5;
        }
        int n = enc = g == null ? reg.getBlankGesture() : reg.getEncoded(g);
        if (serverGc) {
            this.gestureData[1] = g == null || this.gestureData[1] == enc && toggle ? (byte)0 : (byte)enc;
            this.sendGestureData();
        } else if (enc != -1) {
            if (enc == MinecraftClientAccess.get().getCurrentClientPlayer().animState.encodedState && toggle) {
                enc = reg.getBlankGesture();
            }
            MinecraftClientAccess.get().setEncodedGesture(enc);
        }
    }

    public void setLayerValue(AnimationRegistry reg, Gesture g, float value) {
        if (g == null || !MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            return;
        }
        if (g.type == AnimationType.VALUE_LAYER) {
            int id = reg.getLayerId(g);
            if (id == -1 || id >= this.gestureData.length) {
                return;
            }
            byte old = this.gestureData[id];
            this.gestureData[id] = (byte)(value * 255.0f);
            if (this.gestureData[id] != old) {
                this.sendGestureData();
            }
        } else if (g.type == AnimationType.LAYER) {
            int id = reg.getLayerId(g);
            if (id == -1 || id >= this.gestureData.length) {
                return;
            }
            byte old = this.gestureData[id];
            this.gestureData[id] = (byte)(value > 0.0f ? 1 : 0);
            if (this.gestureData[id] != old) {
                this.sendGestureData();
            }
        }
    }

    private void sendGestureData() {
        MinecraftClientAccess.get().getNetHandler().sendPacketToServer(new GestureC2S(this.gestureData));
    }

    public int getTicks() {
        return (int)this.tickCounter;
    }

    public void setServerScaling(Map<ScalingOptions, Float> scaling) {
        this.modelScaleToReset = new ScaleData(scaling);
        this.resetCounter = this.tickCounter + 100L;
    }

    public void updateKeys(IKeybind[] kbs) {
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition();
        if (def != null) {
            for (int i = 1; i <= kbs.length; ++i) {
                IKeybind kb = kbs[i - 1];
                boolean pr = kb.isPressed();
                boolean prevPr = this.quickAccessPressed[i - 1];
                if (!prevPr && pr) {
                    this.onKeybind(i);
                } else if (prevPr && !pr) {
                    ConfigEntry ce = ModConfig.getCommonConfig().getEntry("keybinds");
                    String mode = ce.getString("qa_" + i + "_mode", "press");
                    String c = ce.getString("qa_" + i, null);
                    if (c != null && mode.equals("hold")) {
                        Gesture g;
                        if (c.startsWith("p")) {
                            this.setCustomPose(def.getAnimations(), null);
                        } else if (c.startsWith("g") && (g = def.getAnimations().getGestures().get(c.substring(1))) != null && g.isLoop) {
                            this.playGesture(def.getAnimations(), null);
                        }
                    }
                }
                this.quickAccessPressed[i - 1] = pr;
            }
        } else {
            Arrays.fill(this.quickAccessPressed, false);
        }
    }

    public byte getGestureValue(AnimationRegistry reg, Gesture g) {
        int id = reg.getLayerId(g);
        if (id == -1 || id >= this.gestureData.length) {
            return 0;
        }
        return this.gestureData[id];
    }

    public void resetGestureData() {
        this.gestureData = new byte[2];
    }

    public boolean applyCommand(String id, int value) {
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition();
        if (def != null) {
            CustomPose pose = def.getAnimations().getCustomPoses().get(id);
            if (pose != null) {
                if (pose.isCommand()) {
                    if (value == 0) {
                        this.setCustomPose(def.getAnimations(), null);
                    } else {
                        this.setCustomPose(def.getAnimations(), pose, false);
                    }
                    return true;
                }
            } else {
                Gesture g = def.getAnimations().getGestures().get(id);
                if (g != null && g.isCommand()) {
                    if (g.type.isLayer() && value != -1) {
                        this.setLayerValue(def.getAnimations(), g, (float)value / 255.0f);
                        return true;
                    }
                    if (value == 0) {
                        this.playGesture(def.getAnimations(), null);
                    } else {
                        this.playGesture(def.getAnimations(), g, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static enum AnimationMode {
        PLAYER,
        SKULL,
        HAND;

    }

    private static class DefaultValuePose
    implements IPose {
        private final byte v;

        public DefaultValuePose(byte v) {
            this.v = v;
        }

        @Override
        public String getName(IGui gui, String display) {
            return "value";
        }

        @Override
        public long getTime(AnimationState state, long time) {
            return (long)((float)Byte.toUnsignedInt(this.v) / 256.0f * 1000.0f);
        }
    }

    private static class ValueLayerPose
    implements IPose {
        private final int id;

        public ValueLayerPose(int id) {
            this.id = id;
        }

        @Override
        public String getName(IGui gui, String display) {
            return "value";
        }

        @Override
        public long getTime(AnimationState state, long time) {
            if (state.gestureData.length > this.id) {
                return (long)((float)Byte.toUnsignedInt(state.gestureData[this.id]) / 256.0f * 1000.0f);
            }
            return 0L;
        }
    }
}

