/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.definition.ModelDefinition;
import java.util.ArrayList;
import java.util.List;

public class StagedAnimation {
    private Stage currentStage;
    private List<Anim> pre = new ArrayList<Anim>();
    private List<Anim> play = new ArrayList<Anim>();
    private List<Anim> post = new ArrayList<Anim>();
    private List<IAnimation> all = new ArrayList<IAnimation>();

    public IAnimation addPre(IAnimation anim) {
        Anim a = new Anim(anim, Stage.SETUP);
        this.pre.add(a);
        this.all.add(a);
        return a;
    }

    public IAnimation addPlay(IAnimation anim) {
        if (anim instanceof Anim) {
            return anim;
        }
        Anim a = new Anim(anim, Stage.PLAY);
        this.play.add(a);
        this.all.add(a);
        return a;
    }

    public IAnimation addPost(IAnimation anim) {
        Anim a = new Anim(anim, Stage.FINISH);
        this.post.add(a);
        this.all.add(a);
        return a;
    }

    public List<IAnimation> getAll() {
        return this.all;
    }

    public static enum Stage {
        SETUP,
        PLAY,
        FINISH;

    }

    private class Anim
    implements IAnimation {
        private final IAnimation parent;
        private final Stage stage;
        private long offset;
        private long lastFrame;
        private boolean finished;

        public Anim(IAnimation parent, Stage stage) {
            this.parent = parent;
            this.stage = stage;
        }

        @Override
        public int getDuration() {
            if (this.stage == Stage.FINISH) {
                return Integer.MAX_VALUE;
            }
            return this.parent.getDuration();
        }

        @Override
        public int getPriority() {
            return this.parent.getPriority();
        }

        @Override
        public void animate(long millis, ModelDefinition def) {
            this.lastFrame = millis;
            if (StagedAnimation.this.currentStage == this.stage) {
                if (this.stage == Stage.FINISH && this.lastFrame >= this.offset + (long)this.parent.getDuration()) {
                    return;
                }
                if (this.stage == Stage.SETUP && millis - this.offset >= (long)this.parent.getDuration()) {
                    this.finished = true;
                    if (StagedAnimation.this.pre.stream().allMatch(a -> a.finished)) {
                        StagedAnimation.this.currentStage = Stage.PLAY;
                    }
                } else {
                    this.parent.animate(millis - this.offset, def);
                }
            } else {
                this.offset = millis;
            }
        }

        @Override
        public boolean checkAndUpdateRemove() {
            if (this.stage == Stage.FINISH) {
                StagedAnimation.this.currentStage = Stage.FINISH;
                if (this.lastFrame >= this.offset + (long)this.parent.getDuration()) {
                    this.offset = 0L;
                    return true;
                }
                return false;
            }
            this.finished = false;
            this.offset = 0L;
            return true;
        }

        @Override
        public void prepare() {
            StagedAnimation.this.currentStage = StagedAnimation.this.pre.isEmpty() ? Stage.PLAY : Stage.SETUP;
            StagedAnimation.this.all.forEach(a -> ((Anim)a).reset());
        }

        private void reset() {
            this.offset = 0L;
            this.finished = false;
        }
    }
}

