/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpl.gui.IGui;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.ServerAnimationState;
import java.util.Locale;

public enum VanillaPose implements IPose
{
    CUSTOM,
    STANDING,
    WALKING,
    RUNNING,
    SNEAKING,
    SWIMMING,
    FALLING,
    SLEEPING,
    RIDING,
    FLYING,
    DYING,
    SKULL_RENDER,
    GLOBAL,
    CREATIVE_FLYING,
    EATING_LEFT,
    EATING_RIGHT,
    RETRO_SWIMMING,
    JUMPING,
    SNEAK_WALK,
    PUNCH_LEFT(s -> s.attackTime),
    PUNCH_RIGHT(s -> s.attackTime),
    ARMOR_HEAD,
    ARMOR_BODY,
    ARMOR_LEGS,
    ARMOR_BOOTS,
    WEARING_ELYTRA,
    BOW_LEFT(s -> s.bowPullback),
    BOW_RIGHT(s -> s.bowPullback),
    CROSSBOW_LEFT,
    CROSSBOW_RIGHT,
    CROSSBOW_CH_LEFT(s -> s.crossbowPullback),
    CROSSBOW_CH_RIGHT(s -> s.crossbowPullback),
    TRIDENT_LEFT,
    TRIDENT_RIGHT,
    TRIDENT_SPIN,
    SPYGLASS_LEFT,
    SPYGLASS_RIGHT,
    HOLDING_LEFT,
    HOLDING_RIGHT,
    WEARING_SKULL,
    BLOCKING_LEFT,
    BLOCKING_RIGHT,
    PARROT_LEFT,
    PARROT_RIGHT,
    HURT,
    ON_FIRE,
    FREEZING,
    ON_LADDER,
    CLIMBING_ON_LADDER,
    SPEAKING(s -> s.speakLevel),
    TOOT_HORN_LEFT,
    TOOT_HORN_RIGHT,
    IN_GUI,
    FIRST_PERSON_MOD,
    VOICE_MUTED,
    VR_FIRST_PERSON,
    VR_THIRD_PERSON_SITTING,
    VR_THIRD_PERSON_STANDING,
    FIRST_PERSON_HAND,
    HEALTH(VanillaPose.syncedState(s -> s.health)),
    HUNGER(VanillaPose.syncedState(s -> s.hunger)),
    AIR(VanillaPose.syncedState(s -> s.air)),
    IN_MENU;

    private final String i18nKey = "label.cpm.pose." + this.name().toLowerCase(Locale.ROOT);
    private ToFloatFunction<AnimationState> stateGetter;
    public static final VanillaPose[] VALUES;
    public static final int DYNAMIC_DURATION_MUL = 1000;
    public static final int DYNAMIC_DURATION_DIV = 1001;

    private VanillaPose() {
    }

    private static ToFloatFunction<AnimationState> syncedState(ToFloatFunction<ServerAnimationState> state) {
        return s -> {
            if (s.serverState.updated) {
                return state.apply(s.serverState);
            }
            return state.apply(s.localState);
        };
    }

    private VanillaPose(ToFloatFunction<AnimationState> stateGetter) {
        this();
        this.stateGetter = stateGetter;
    }

    @Override
    public String getName(IGui gui, String display) {
        if (display == null) {
            return gui.i18nFormat(this.i18nKey, new Object[0]);
        }
        return gui.i18nFormat("label.cpm.vanilla_anim", gui.i18nFormat(this.i18nKey, new Object[0]), display);
    }

    @Override
    public long getTime(AnimationState state, long time) {
        if (this.stateGetter != null && state != null) {
            return (long)(this.stateGetter.apply(state) * 1000.0f);
        }
        return time;
    }

    public boolean hasStateGetter() {
        return this.stateGetter != null;
    }

    static {
        VALUES = VanillaPose.values();
    }
}

