/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.definition;

import com.tom.cpm.shared.editor.actions.Action;
import java.util.List;

public abstract class ListAction<T>
extends Action {
    private T value;
    private List<T> list;
    private int index = -1;

    public ListAction(T value, List<T> list) {
        this.value = value;
        this.list = list;
    }

    public static <T> ListAction<T> add(T value, List<T> list) {
        return new Add<T>(value, list);
    }

    public static <T> ListAction<T> remove(T value, List<T> list) {
        return new Remove<T>(value, list);
    }

    protected void add() {
        if (this.index != -1 && this.index < this.list.size()) {
            this.list.add(this.index, this.value);
        } else {
            this.list.add(this.value);
        }
    }

    protected void remove() {
        this.index = this.list.indexOf(this.value);
        this.list.remove(this.value);
    }

    private static class Remove<T>
    extends ListAction<T> {
        public Remove(T value, List<T> list) {
            super(value, list);
        }

        @Override
        public void undo() {
            this.add();
        }

        @Override
        public void run() {
            this.remove();
        }
    }

    private static class Add<T>
    extends ListAction<T> {
        public Add(T value, List<T> list) {
            super(value, list);
        }

        @Override
        public void undo() {
            this.remove();
        }

        @Override
        public void run() {
            this.add();
        }
    }
}

