/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.anim.AnimatedTex;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.RootGroups;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;

public class ETextures
implements TreeElement {
    public static final int MAX_TEX_SIZE = 8192;
    private final Editor e;
    private TextureSheetType type;
    public EditorTexture provider;
    private EditorTexture renderTexture;
    public TextureStitcher stitcher;
    public Consumer<TextureStitcher> textureLoader;
    public File file;
    private Image defaultImg;
    public List<AnimatedTex> animatedTexs = new ArrayList<AnimatedTex>();
    private final AnimTreeList animsList = new AnimTreeList();
    public boolean customGridSize;

    public ETextures(Editor e, TextureSheetType type) {
        this(e, type, null);
    }

    public ETextures(Editor e, TextureSheetType type, Consumer<TextureStitcher> textureLoader) {
        this(e, new EditorTexture());
        this.type = type;
        this.textureLoader = textureLoader;
        if (textureLoader != null) {
            this.renderTexture = new EditorTexture();
            this.stitcher = new TextureStitcher(8192);
        } else if (type.editable) {
            this.renderTexture = new EditorTexture();
        }
    }

    public ETextures(Editor e, EditorTexture provider) {
        this.e = e;
        this.provider = provider;
    }

    public void free() {
        this.provider.free();
        if (this.renderTexture != null) {
            this.renderTexture.free();
        }
    }

    public void clean() {
        this.provider.texture = null;
        this.provider.setEdited(false);
        this.file = null;
        this.animatedTexs.clear();
    }

    public void markDirty() {
        this.provider.markDirty();
        this.refreshTexture();
    }

    public boolean isEdited() {
        return this.provider.isEdited();
    }

    public void setEdited(boolean edited) {
        this.provider.setEdited(edited);
    }

    public void refreshTexture(EditorTexture tex) {
        if (this.textureLoader == null) {
            if (this.renderTexture != null) {
                this.renderTexture.setImage(new Image(this.provider.getImage()));
                this.renderTexture.size = this.provider.size;
            }
            return;
        }
        if (this.stitcher.refresh(tex.getImage())) {
            this.renderTexture.markDirty();
        }
        this.updateAnim();
    }

    public void restitchTexture() {
        if (this.textureLoader == null) {
            if (this.renderTexture != null) {
                this.renderTexture.setImage(new Image(this.provider.getImage()));
                this.renderTexture.size = this.provider.size;
            }
            return;
        }
        this.stitcher = new TextureStitcher(8192);
        this.stitcher.setBase(this.provider);
        this.textureLoader.accept(this.stitcher);
        this.stitcher.finish(this.renderTexture);
        this.renderTexture.markDirty();
        this.updateAnim();
    }

    public void setRGB(int x, int y, int rgb) {
        this.provider.setRGB(x, y, rgb);
    }

    public void write(IOHelper dout) throws IOException {
        this.provider.write(dout);
    }

    public void setImage(Image image) {
        this.provider.setImage(image);
    }

    public void refreshTexture() {
        this.refreshTexture(this.provider);
    }

    public Image getImage() {
        return this.provider.getImage();
    }

    public boolean hasStitches() {
        if (this.textureLoader == null) {
            return false;
        }
        return this.stitcher.hasStitches();
    }

    public EditorTexture getRenderTexture() {
        return this.renderTexture != null ? this.renderTexture : this.provider;
    }

    @Override
    public String getName() {
        return this.e.gui().i18nFormat("label.cpm.texture." + this.type.name().toLowerCase(Locale.ROOT), new Object[0]);
    }

    @Override
    public ETextures getTexture() {
        return this;
    }

    public void setDefaultImg(Image defaultImg) {
        this.defaultImg = defaultImg;
    }

    public Image copyDefaultImg() {
        return new Image(this.defaultImg);
    }

    public boolean isEditable() {
        return this.type != null ? this.type.editable : false;
    }

    @Override
    public int textColor() {
        return this.isEdited() ? 0 : this.e.gui().getColors().button_text_disabled;
    }

    public void updateAnim() {
        if (!this.animatedTexs.isEmpty() && this.renderTexture != null) {
            this.animatedTexs.forEach(t -> {
                if (t.apply(this.renderTexture.getImage(), this.provider.getImage())) {
                    this.renderTexture.markDirty();
                }
            });
        }
    }

    @Override
    public void updateGui() {
        this.e.setEnAddAnimTex.accept(this.type.editable);
        this.e.setDelEn.accept(true);
    }

    @Override
    public void getTreeElements(Consumer<TreeElement> c) {
        if (this.type.editable) {
            c.accept(this.animsList);
        }
    }

    public TextureSheetType getType() {
        return this.type;
    }

    public int getMaxSize() {
        return Math.max(this.provider.getImage().getWidth(), this.provider.getImage().getHeight());
    }

    @Override
    public void delete() {
        if (this.e.elements.stream().anyMatch(e -> e.type == ElementType.ROOT_PART && ETextures.getTextureSheet((VanillaModelPart)e.typeData) == this.type)) {
            ConfirmPopup.confirm(this.e.frame, this.e.gui().i18nFormat("label.cpm.confirm", new Object[0]), this.e.gui().i18nFormat("label.cpm.resetTextureSheet", new Object[0]), () -> this.e.action("delTexture").updateValueOp(this, this.getImage(), this.copyDefaultImg(), ETextures::setImage).updateValueOp(this, this.isEdited(), false, ETextures::setEdited).execute(), this.e.gui().i18nFormat("button.cpm.resetTexture", new Object[0]));
        } else {
            ConfirmPopup.confirm(this.e.frame, this.e.gui().i18nFormat("label.cpm.confirm", new Object[0]), this.e.gui().i18nFormat("label.cpm.removeTextureSheet", new Object[0]), () -> this.e.action("remove", "label.cpm.textureSheet").removeFromMap(this.e.textures, this.type, this).execute());
        }
    }

    private static TextureSheetType getTextureSheet(VanillaModelPart part) {
        if (part instanceof PlayerModelParts) {
            return TextureSheetType.SKIN;
        }
        if (part instanceof RootModelType) {
            RootGroups gr = RootGroups.getGroup((RootModelType)part);
            return gr.getTexSheet((RootModelType)part);
        }
        return TextureSheetType.SKIN;
    }

    private class AnimTreeList
    implements TreeElement {
        private AnimTreeList() {
        }

        @Override
        public String getName() {
            return ETextures.this.e.gui().i18nFormat("label.cpm.tree.animatedTex", new Object[0]);
        }

        @Override
        public void getTreeElements(Consumer<TreeElement> c) {
            ETextures.this.animatedTexs.forEach(c);
        }

        @Override
        public ETextures getTexture() {
            return ETextures.this;
        }
    }
}

