/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.gui.TextureDisplay;
import com.tom.cpm.shared.editor.tree.TreeElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public interface MultiSelector
extends TreeElement {
    public boolean add(TreeElement var1);

    public void forEachSelected(Consumer<TreeElement> var1);

    @Override
    default public String getName() {
        return "";
    }

    public static class ElementImpl
    implements MultiSelector {
        private List<ModelElement> elements = new ArrayList<ModelElement>();
        private final Editor editor;

        public ElementImpl(Editor editor) {
            this.editor = editor;
        }

        private void addImpl(ModelElement modelElement) {
            if (this.elements.contains(modelElement)) {
                this.elements.remove(modelElement);
            } else {
                this.elements.add(modelElement);
            }
        }

        @Override
        public boolean isSelected(Editor e, TreeElement other) {
            return this.elements.contains(other);
        }

        @Override
        public void updateGui() {
            if (this.elements.stream().noneMatch(e -> e.type == ElementType.ROOT_PART)) {
                this.editor.setOffset.accept(this.getVec(TreeElement.VecType.OFFSET));
                if (this.elements.stream().allMatch(e -> e.itemRenderer == null && e.texture && e.faceUV == null)) {
                    this.editor.setModeBtn.accept(this.editor.gui().i18nFormat("button.cpm.mode.tex", new Object[0]));
                    this.editor.setModePanel.accept(ModeDisplayType.TEX);
                    this.editor.setTexturePanel.accept(this.getVecUV());
                } else if (this.elements.stream().allMatch(e -> e.itemRenderer == null && !e.texture)) {
                    this.editor.setModeBtn.accept(this.editor.gui().i18nFormat("button.cpm.mode.color", new Object[0]));
                    this.editor.setModePanel.accept(ModeDisplayType.COLOR);
                    this.editor.setPartColor.accept(0);
                }
                this.editor.setDelEn.accept(true);
            }
            this.editor.setPosition.accept(this.getVec(TreeElement.VecType.POSITION));
            this.editor.setRot.accept(this.getVec(TreeElement.VecType.ROTATION));
        }

        @Override
        public void setElemColor(int color) {
            this.elements.forEach(e -> e.setElemColor(color));
        }

        @Override
        public void setVec(Vec3f v, TreeElement.VecType object) {
            if (object == TreeElement.VecType.TEXTURE) {
                Vec3i uv = this.getVecUV();
                float uOff = v.x - (float)uv.x;
                float vOff = v.y - (float)uv.y;
                this.elements.forEach(e -> e.setVec(new Vec3f((float)e.u + uOff, (float)e.v + vOff, e.textureSize), object));
            } else {
                Vec3f s = this.getVec(object);
                Vec3f off = v.sub(s);
                this.elements.forEach(e -> e.setVec(this.getVec((ModelElement)e, object).add(off), object));
            }
        }

        @Override
        public void delete() {
            this.elements.forEach(ModelElement::delete);
        }

        @Override
        public void switchVis() {
            this.elements.forEach(ModelElement::switchVis);
        }

        @Override
        public void switchEffect(Effect effect) {
            this.elements.forEach(e -> e.switchEffect(effect));
        }

        @Override
        public void modeSwitch() {
        }

        @Override
        public void setMCScale(float scale) {
        }

        @Override
        public Vec3f getVec(TreeElement.VecType type) {
            if (type == TreeElement.VecType.TEXTURE) {
                Vec3i uv = this.getVecUV();
                return new Vec3f(uv.x, uv.y, uv.z);
            }
            return this.elements.stream().map(e -> this.getVec((ModelElement)e, type)).reduce(new Vec3f(), Vec3f::add).mul(1.0f / (float)this.elements.size());
        }

        public Vec3i getVecUV() {
            return this.elements.stream().map(e -> new Vec3i(e.u, e.v, e.textureSize)).reduce(new Vec3i(Integer.MAX_VALUE, Integer.MAX_VALUE, 256), (a, b) -> new Vec3i(Math.min(a.x, b.x), Math.min(a.y, b.y), Math.min(a.z, b.z)));
        }

        public Vec3f getVec(ModelElement e, TreeElement.VecType type) {
            switch (type) {
                case OFFSET: {
                    return e.offset;
                }
                case POSITION: {
                    return e.getPosition();
                }
                case ROTATION: {
                    return e.getRotation();
                }
                case SCALE: {
                    return e.scale;
                }
                case SIZE: {
                    return e.size;
                }
            }
            return null;
        }

        @Override
        public ETextures getTexture() {
            List texs = this.elements.stream().map(ModelElement::getTexture).distinct().collect(Collectors.toList());
            return texs.size() == 1 ? (ETextures)texs.get(0) : null;
        }

        @Override
        public Box getTextureBox() {
            return this.elements.stream().map(ModelElement::getTextureBox).filter(e -> e != null).reduce(null, (a, b) -> a == null ? b : (b == null ? a : a.union((Box)b)));
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            this.elements.forEach(e -> TextureDisplay.drawBoxTextureOverlay(gui, e, x, y, xs, ys, TextureDisplay.getAlphaForBox(true)));
        }

        @Override
        public void setVecTemp(TreeElement.VecType object, Vec3f v) {
            if (object == TreeElement.VecType.TEXTURE) {
                Vec3i uv = this.getVecUV();
                float uOff = v.x - (float)uv.x;
                float vOff = v.y - (float)uv.y;
                this.elements.forEach(e -> e.setVecTemp(object, new Vec3f((float)e.u + uOff, (float)e.v + vOff, e.textureSize)));
            } else {
                Vec3f s = this.getVec(object);
                Vec3f off = v.sub(s);
                this.elements.forEach(e -> e.setVecTemp(object, this.getVec((ModelElement)e, object).add(off)));
            }
        }

        @Override
        public boolean add(TreeElement elem) {
            if (elem instanceof ModelElement) {
                this.addImpl((ModelElement)elem);
            }
            return this.elements.isEmpty();
        }

        @Override
        public void forEachSelected(Consumer<TreeElement> c) {
            this.elements.forEach(c);
        }
    }
}

