/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeybindHandler;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tree;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.gui.Keybinds;

public class TreePanel
extends Panel {
    private Tree<TreeElement> tree;
    private Editor editor;

    public TreePanel(IGui gui, EditorGui e, int width, int height, boolean enableMod) {
        super(gui);
        this.setBounds(new Box(width - 150, 0, 150, height));
        this.setBackgroundColor(gui.getColors().panel_background);
        this.editor = e.getEditor();
        ScrollPanel treePanel = new ScrollPanel(gui);
        treePanel.setBounds(new Box(0, 0, 150, height - 30));
        this.addElement(treePanel);
        this.tree = new Tree<TreeElement>((Frame)e, this.editor.treeHandler);
        this.editor.updateGui.add(this.tree::updateTree);
        Panel tp = new Panel(gui);
        treePanel.setDisplay(tp);
        tp.addElement(this.tree);
        this.tree.setSizeUpdate(s -> {
            int w = Math.max(s.x, 146);
            int h = Math.max(s.y, height - 34);
            tp.setBounds(new Box(0, 0, w, h));
            this.tree.setBounds(new Box(0, 0, w, h));
        });
        if (enableMod) {
            ButtonIcon newBtn = new ButtonIcon(gui, "editor", 0, 16, this.editor::addNew);
            newBtn.setBounds(new Box(5, height - 24, 18, 18));
            this.addElement(newBtn);
            this.editor.setAddEn.add(newBtn::setEnabled);
            ButtonIcon delBtn = new ButtonIcon(gui, "editor", 14, 16, this.editor::deleteSel);
            delBtn.setBounds(new Box(25, height - 24, 18, 18));
            this.addElement(delBtn);
            this.editor.setDelEn.add(delBtn::setEnabled);
        }
        ButtonIcon visBtn = new ButtonIcon(gui, "editor", 42, 16, this.editor::switchVis);
        visBtn.setBounds(new Box(enableMod ? 45 : 5, height - 24, 18, 18));
        this.addElement(visBtn);
        this.editor.setVis.add(b -> {
            if (b == null) {
                visBtn.setEnabled(false);
                visBtn.setU(42);
            } else {
                visBtn.setEnabled(true);
                visBtn.setU(b != false ? 42 : 28);
            }
        });
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        KeybindHandler h = this.editor.frame.getKeybindHandler();
        h.registerKeybind(Keybinds.TREE_UP, () -> {
            this.editor.selectedElement = this.tree.findUp(this.editor.selectedElement);
            this.editor.updateGui();
        });
        h.registerKeybind(Keybinds.TREE_PREV, () -> {
            this.editor.selectedElement = this.tree.findPrev(this.editor.selectedElement);
            this.editor.updateGui();
        });
        h.registerKeybind(Keybinds.TREE_DOWN, () -> {
            this.editor.selectedElement = this.editor.selectedElement == null ? (TreeElement)this.editor.elements.get(0) : this.tree.findDown(this.editor.selectedElement);
            this.editor.updateGui();
        });
        h.registerKeybind(Keybinds.TREE_NEXT, () -> {
            this.editor.selectedElement = this.editor.selectedElement == null ? (TreeElement)this.editor.elements.get(0) : this.tree.findNext(this.editor.selectedElement);
            this.editor.updateGui();
        });
        super.keyPressed(event);
    }
}

