/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.AnimationDisplayData;
import com.tom.cpm.shared.editor.gui.ViewportPanel;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.util.FilterBuffers;
import com.tom.cpm.shared.gui.Keybinds;
import com.tom.cpm.shared.model.builtin.VanillaPlayerModel;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.util.PlayerModelLayer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ViewportPanelAnim
extends ViewportPanel {
    private List<AnimationDisplayData> anims;
    private Vec3f animPos;
    private Vec3f animRot;
    private FilterBuffers filter = new FilterBuffers(r -> this.types.get(RenderMode.OUTLINE) == r);

    public ViewportPanelAnim(Frame frm, Editor editor) {
        super(frm, editor);
        editor.setAnimPos.add(v -> {
            this.animPos = v;
        });
        editor.setAnimRot.add(v -> {
            this.animRot = v;
        });
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.anims = null;
        if (this.editor.playFullAnim) {
            this.anims = this.editor.testPoses.stream().map(p -> AnimationDisplayData.getFor(p)).filter(d -> d.type == AnimationDisplayData.Type.LAYERS || d.type == AnimationDisplayData.Type.HAND).collect(Collectors.toList());
        }
        this.editor.applyAnim = true;
        super.draw(event, partialTicks);
        this.editor.applyAnim = false;
        this.anims = null;
    }

    @Override
    public DisplayItem getHeldItem(ItemSlot hand) {
        if (this.editor.selectedAnim != null) {
            if (this.editor.selectedAnim.pose != null && this.editor.selectedAnim.pose instanceof VanillaPose) {
                AnimationDisplayData dt = AnimationDisplayData.getFor((VanillaPose)this.editor.selectedAnim.pose);
                if (dt.slot == hand) {
                    return dt.item;
                }
            }
            if (!this.editor.forceHeldItemInAnim.get()) {
                return DisplayItem.NONE;
            }
        } else if (this.anims != null) {
            return this.anims.stream().filter(p -> p.slot == hand).map(p -> p.item).filter(p -> p != null).findFirst().orElse(DisplayItem.NONE);
        }
        return super.getHeldItem(hand);
    }

    @Override
    protected int getItemState(ItemSlot slot, int maxStates) {
        float progress = 0.0f;
        AnimationDisplayData data = null;
        if (this.editor.selectedAnim != null) {
            data = this.editor.selectedAnim.pose instanceof VanillaPose ? AnimationDisplayData.getFor((VanillaPose)this.editor.selectedAnim.pose) : null;
            progress = this.getAnimProgress();
        } else if (this.anims != null) {
            data = this.anims.stream().filter(p -> p.slot == slot && p.layerSlot != null).findFirst().orElse(null);
            progress = data != null ? this.editor.animTestSliders.getOrDefault("__pose", Float.valueOf(0.0f)).floatValue() : 0.0f;
        }
        DisplayItem i = this.getHeldItem(slot);
        if (i == DisplayItem.CROSSBOW) {
            if (data == AnimationDisplayData.CROSSBOW_CH_LEFT || data == AnimationDisplayData.CROSSBOW_CH_RIGHT) {
                return (int)Math.min(progress * 3.0f + 1.0f, (float)(maxStates - 1));
            }
        } else if (i == DisplayItem.BOW) {
            return (int)Math.min(progress * 3.0f, (float)(maxStates - 1));
        }
        return 0;
    }

    @Override
    protected Hand poseModel0(VanillaPlayerModel p, MatrixStack matrixstack, float partialTicks) {
        float progress = 0.0f;
        AnimationDisplayData data = null;
        if (this.editor.selectedAnim != null) {
            data = this.editor.selectedAnim.pose instanceof VanillaPose ? AnimationDisplayData.getFor((VanillaPose)this.editor.selectedAnim.pose) : null;
            progress = this.getAnimProgress();
        } else if (this.anims != null) {
            data = this.anims.stream().filter(e -> e.type == AnimationDisplayData.Type.HAND).findFirst().orElse(null);
            float f = progress = data != null ? this.editor.animTestSliders.getOrDefault("__pose", Float.valueOf(0.0f)).floatValue() : 0.0f;
        }
        if (data == AnimationDisplayData.CROSSBOW_CH_LEFT || data == AnimationDisplayData.CROSSBOW_CH_RIGHT) {
            p.useAmount = progress;
            if (p.leftArmPose == PlayerModelSetup.ArmPose.CROSSBOW_HOLD) {
                p.leftArmPose = PlayerModelSetup.ArmPose.CROSSBOW_CHARGE;
            }
            if (p.rightArmPose == PlayerModelSetup.ArmPose.CROSSBOW_HOLD) {
                p.rightArmPose = PlayerModelSetup.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (data == AnimationDisplayData.BOW_LEFT || data == AnimationDisplayData.BOW_RIGHT) {
            p.useAmount = progress;
        } else {
            if (data == AnimationDisplayData.PUNCH_LEFT) {
                p.attackTime = progress;
                return Hand.LEFT;
            }
            if (data == AnimationDisplayData.PUNCH_RIGHT) {
                p.attackTime = progress;
            }
        }
        return Hand.RIGHT;
    }

    private float getAnimProgress() {
        if (this.editor.playFullAnim) {
            long playTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
            long currentStep = playTime - this.editor.playStartTime;
            return (float)(currentStep % (long)this.editor.selectedAnim.duration) / (float)this.editor.selectedAnim.duration;
        }
        return this.editor.selectedAnim.getAnimProgess();
    }

    @Override
    public Set<PlayerModelLayer> getArmorLayers() {
        if (this.anims != null) {
            return this.anims.stream().map(e -> e.layer).filter(e -> e != null).collect(Collectors.toSet());
        }
        return super.getArmorLayers();
    }

    @Override
    protected int drawParrots() {
        int r;
        int n = r = this.editor.forceHeldItemInAnim.get() ? super.drawParrots() : 0;
        if (this.anims != null) {
            if (this.anims.contains((Object)AnimationDisplayData.PARROT_LEFT)) {
                r |= 1;
            }
            if (this.anims.contains((Object)AnimationDisplayData.PARROT_RIGHT)) {
                r |= 2;
            }
        }
        return r;
    }

    @Override
    protected TreeElement.VecType[] getVecTypes() {
        return TreeElement.VecType.MOUSE_EDITOR_ANIM_TYPES;
    }

    @Override
    protected Vec3f getVec(TreeElement.VecType type) {
        if (this.editor.selectedAnim != null) {
            this.editor.selectedAnim.beginDrag();
        }
        switch (type) {
            case POSITION: {
                return this.animPos != null ? this.animPos : new Vec3f();
            }
            case ROTATION: {
                return this.animRot != null ? this.animRot : new Vec3f();
            }
        }
        return new Vec3f();
    }

    @Override
    protected void setVec(TreeElement.VecType type, Vec3f vec, boolean temp) {
        block11: {
            block10: {
                if (!temp) break block10;
                switch (type) {
                    case POSITION: {
                        this.editor.setAnimPos.accept(vec);
                        if (this.editor.selectedAnim != null) {
                            this.editor.selectedAnim.dragVal(type, vec);
                            break;
                        }
                        break block11;
                    }
                    case ROTATION: {
                        this.editor.setAnimRot.accept(vec);
                        if (this.editor.selectedAnim != null) {
                            this.editor.selectedAnim.dragVal(type, vec);
                            break;
                        }
                        break block11;
                    }
                }
                break block11;
            }
            switch (type) {
                case POSITION: {
                    this.editor.setAnimPos(vec);
                    this.editor.setAnimPos.accept(vec);
                    break;
                }
                case ROTATION: {
                    this.editor.setAnimRot(vec);
                    this.editor.setAnimRot.accept(vec);
                    break;
                }
            }
        }
    }

    @Override
    protected void endGizmoDrag(boolean apply) {
        super.endGizmoDrag(apply);
        if (this.editor.selectedAnim != null) {
            this.editor.selectedAnim.endDrag();
        }
    }

    @Override
    public boolean canEdit() {
        return this.editor.selectedAnim != null && super.canEdit();
    }

    @Override
    public void render(MatrixStack stack, VBuffers buf, float partialTicks) {
        if (this.editor.showPreviousFrame.get() && this.editor.selectedAnim != null && this.editor.selectedElement != null && this.editor.selectedAnim.getFrames().size() > 1) {
            this.editor.selectedAnim.prevFrame();
            this.editor.definition.renderingPanel = this;
            this.editor.definition.outlineOnly = true;
            this.renderModel(stack, this.filter.filter(buf), partialTicks);
            this.editor.definition.renderingPanel = null;
            this.editor.definition.outlineOnly = false;
            this.editor.selectedAnim.nextFrame();
        }
        super.render(stack, buf, partialTicks);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        super.keyPressed(event);
        this.frame.getKeybindHandler().registerKeybind(Keybinds.TOGGLE_HIDDEN_ACTION, this.editor::switchAnimShow);
    }
}

