/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.panel.SettingsPanel;

public class SettingsPopup
extends PopupPanel {
    private Frame frm;
    private SettingsPanel panel;

    public SettingsPopup(Frame frm) {
        super(frm.getGui());
        this.frm = frm;
        int w = Math.min(frm.getBounds().w / 4 * 3, 400);
        int h = Math.min(frm.getBounds().h / 4 * 3, 300);
        this.panel = new SettingsPanel(frm, this, w, h, this::close);
        this.addElement(this.panel);
        this.setBounds(new Box(0, 0, w, h));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.edit.settings", new Object[0]);
    }

    @Override
    public void onClosed() {
        if (EditorGui.rescaleGui) {
            this.gui.setScale(ModConfig.getCommonConfig().getInt("editorScale", -1));
        }
    }

    @Override
    public void close() {
        if (EditorGui.rescaleGui && this.panel != null && this.panel.isChanged()) {
            this.frm.openPopup(new ConfirmPopup(this.frm, this.gui.i18nFormat("button.cpm.edit.settings", new Object[0]), this.gui.i18nFormat("label.cpm.unsaved", new Object[0]), () -> super.close(), null));
        } else {
            super.close();
        }
    }
}

