/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.NewSkinPopup;

public class SkinSettingsPopup
extends PopupPanel {
    private static boolean shownWarning = false;
    private ETextures tex;

    public static void showPopup(EditorGui e) {
        if (SkinSettingsPopup.canEdit(e)) {
            e.openPopup(new SkinSettingsPopup(e.getGui(), e));
        }
    }

    public static boolean canEdit(EditorGui e) {
        Editor editor = e.getEditor();
        ETextures tex = editor.getTextureProvider();
        return tex != null && tex.isEditable();
    }

    private SkinSettingsPopup(IGui gui, EditorGui e) {
        super(gui);
        Editor editor = e.getEditor();
        this.tex = editor.getTextureProvider();
        Button openSkinBtn = new Button(gui, gui.i18nFormat("button.cpm.openSkin", new Object[0]), () -> {
            FileChooserPopup fc = new FileChooserPopup(editor.frame);
            fc.setTitle(gui.i18nFormat("label.cpm.loadSkin", new Object[0]));
            fc.setFileDescText(gui.i18nFormat("label.cpm.file_png", new Object[0]));
            fc.setFilter(new FileChooserPopup.FileFilter("png"));
            fc.setAccept(e::loadSkin);
            fc.setButtonText(gui.i18nFormat("button.cpm.ok", new Object[0]));
            e.openPopup(fc);
            this.close();
        });
        openSkinBtn.setBounds(new Box(5, 5, 60, 20));
        this.addElement(openSkinBtn);
        Button saveSkin = new Button(gui, gui.i18nFormat("button.cpm.saveSkin", new Object[0]), () -> {
            if (gui.isShiftDown() || this.tex.file == null) {
                FileChooserPopup fc = new FileChooserPopup(editor.frame);
                fc.setTitle(gui.i18nFormat("label.cpm.saveSkin", new Object[0]));
                fc.setFileDescText(gui.i18nFormat("label.cpm.file_png", new Object[0]));
                fc.setFilter(new FileChooserPopup.FileFilter("png"));
                fc.setSaveDialog(true);
                fc.setExtAdder(f -> f + ".png");
                fc.setButtonText(gui.i18nFormat("button.cpm.ok", new Object[0]));
                fc.setAccept(editor::saveSkin);
                e.openPopup(fc);
            } else {
                editor.saveSkin(this.tex.file);
            }
            this.close();
        });
        saveSkin.setBounds(new Box(75, 5, 60, 20));
        this.addElement(saveSkin);
        Button newSkin = new Button(gui, gui.i18nFormat("button.cpm.newSkin", new Object[0]), () -> {
            this.close();
            e.openPopup(new NewSkinPopup(gui, editor));
        });
        newSkin.setBounds(new Box(145, 5, 60, 20));
        this.addElement(newSkin);
        Button delSkin = new Button(gui, gui.i18nFormat("button.cpm.delSkin", new Object[0]), () -> {
            boolean edited = this.tex.isEdited();
            if (edited) {
                e.openPopup(new ConfirmPopup(e, gui.i18nFormat("label.cpm.delSkin", new Object[0]), () -> editor.action("delTexture").updateValueOp(this.tex, this.tex.getImage(), this.tex.copyDefaultImg(), ETextures::setImage).updateValueOp(this.tex, this.tex.isEdited(), false, ETextures::setEdited).updateValueOp(this.tex, this.tex.file, null, (a, b) -> {
                    a.file = b;
                }).onAction(() -> {
                    editor.restitchTextures();
                    editor.updateGui();
                }).execute(), null));
            }
        });
        delSkin.setBounds(new Box(5, 30, 60, 20));
        this.addElement(delSkin);
        Checkbox customGridSize = new Checkbox(gui, gui.i18nFormat("label.cpm.customGridSize", new Object[0]));
        customGridSize.setBounds(new Box(5, 80, 100, 20));
        customGridSize.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.customGridSize", new Object[0])));
        customGridSize.setSelected(this.tex.customGridSize);
        this.addElement(customGridSize);
        Label lblTW = new Label(gui, gui.i18nFormat("label.cpm.width", new Object[0]));
        lblTW.setBounds(new Box(5, 105, 40, 18));
        Label lblTH = new Label(gui, gui.i18nFormat("label.cpm.height", new Object[0]));
        lblTH.setBounds(new Box(75, 105, 40, 18));
        Spinner spinnerTW = new Spinner(gui);
        Spinner spinnerTH = new Spinner(gui);
        spinnerTW.setBounds(new Box(5, 115, 65, 18));
        spinnerTH.setBounds(new Box(75, 115, 65, 18));
        spinnerTW.setDp(0);
        spinnerTH.setDp(0);
        spinnerTW.setEnabled(this.tex.customGridSize);
        spinnerTH.setEnabled(this.tex.customGridSize);
        this.addElement(spinnerTW);
        this.addElement(spinnerTH);
        this.addElement(lblTW);
        this.addElement(lblTH);
        customGridSize.setAction(() -> {
            boolean v = !this.tex.customGridSize;
            ActionBuilder ab = editor.action("switch", "label.cpm.customGridSize").updateValueOp(this.tex, this.tex.customGridSize, v, (a, b) -> {
                a.customGridSize = b;
            });
            if (!v) {
                ab.updateValueOp(this.tex, this.tex.provider.size.x, this.tex.provider.getImage().getWidth(), (a, b) -> {
                    a.provider.size.x = b;
                }).updateValueOp(this.tex, this.tex.provider.size.y, this.tex.provider.getImage().getHeight(), (a, b) -> {
                    a.provider.size.y = b;
                }).onAction(this.tex::restitchTexture).onAction(editor::markElementsDirty);
                spinnerTW.setValue(this.tex.provider.getImage().getWidth());
                spinnerTH.setValue(this.tex.provider.getImage().getHeight());
            }
            ab.execute();
            customGridSize.setSelected(v);
            spinnerTW.setEnabled(v);
            spinnerTH.setEnabled(v);
        });
        Runnable r = () -> {
            if (editor.hasVanillaParts() && !shownWarning) {
                shownWarning = true;
                e.openPopup(new MessagePopup(e, gui.i18nFormat("label.cpm.warning", new Object[0]), gui.i18nFormat("label.cpm.skin_has_vanilla_parts", new Object[0])));
            } else {
                editor.setTexSize((int)spinnerTW.getValue(), (int)spinnerTH.getValue());
            }
        };
        spinnerTW.addChangeListener(r);
        spinnerTH.addChangeListener(r);
        spinnerTW.setValue(this.tex.provider.size.x);
        spinnerTH.setValue(this.tex.provider.size.y);
        this.setBounds(new Box(0, 0, 210, 140));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.skinSettings.title", this.tex.getName());
    }
}

