/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.tree;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.elements.Tree;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public interface TreeElement {
    default public void onClick(Editor e, MouseEvent evt) {
        e.selectedElement = this;
    }

    default public boolean isSelected(Editor e, TreeElement other) {
        return e.selectedElement == other;
    }

    public String getName();

    default public int textColor() {
        return 0;
    }

    default public int bgColor() {
        return 0;
    }

    default public void accept(TreeElement elem) {
        throw new UnsupportedOperationException();
    }

    default public boolean canAccept(TreeElement elem) {
        return false;
    }

    default public boolean canMove() {
        return false;
    }

    default public void getTreeElements(Consumer<TreeElement> c) {
    }

    default public void populatePopup(PopupMenu popup) {
    }

    default public Tooltip getTooltip() {
        return null;
    }

    default public void setVec(Vec3f v, VecType object) {
    }

    default public void setElemName(String name) {
    }

    default public String getElemName() {
        return "";
    }

    default public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
    }

    default public ETextures getTexture() {
        return null;
    }

    default public Box getTextureBox() {
        return null;
    }

    default public List<TreeSettingElement> getSettingsElements() {
        return Collections.emptyList();
    }

    default public void modeSwitch() {
    }

    default public void updateGui() {
    }

    default public void onRefreshTree() {
    }

    default public void addNew() {
    }

    default public void delete() {
    }

    default public void setElemColor(int color) {
    }

    default public void setMCScale(float scale) {
    }

    default public void switchVis() {
    }

    default public void switchEffect(Effect effect) {
    }

    default public float getValue() {
        return 0.0f;
    }

    default public void setValue(float value) {
    }

    default public void setVecTemp(VecType type, Vec3f vec) {
    }

    default public Vec3f getVec(VecType type) {
        return Vec3f.ZERO;
    }

    default public boolean canEditVec(VecType type) {
        return false;
    }

    public static interface TreeSettingElement
    extends TreeElement {
        public TreeElement getParent();

        @Override
        default public String getName() {
            return "";
        }

        @Override
        default public ETextures getTexture() {
            return this.getParent().getTexture();
        }

        @Override
        default public boolean isSelected(Editor e, TreeElement other) {
            return other == this.getParent();
        }

        @Override
        default public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            this.getParent().drawTexture(gui, x, y, xs, ys);
        }
    }

    public static enum VecType {
        SIZE,
        OFFSET,
        ROTATION,
        POSITION,
        SCALE,
        TEXTURE;

        public static final VecType[] MOUSE_EDITOR_TYPES;
        public static final VecType[] MOUSE_EDITOR_ANIM_TYPES;

        static {
            MOUSE_EDITOR_TYPES = new VecType[]{SIZE, OFFSET, ROTATION, POSITION};
            MOUSE_EDITOR_ANIM_TYPES = new VecType[]{ROTATION, POSITION};
        }
    }

    public static class ModelTree
    extends Tree.TreeModel<TreeElement> {
        private Editor e;
        private TreeElement moveElem;

        public ModelTree(Editor e) {
            this.e = e;
        }

        @Override
        protected int textColor(TreeElement val) {
            return val.textColor();
        }

        @Override
        protected void getElements(TreeElement parent, Consumer<TreeElement> c) {
            if (parent == null) {
                this.e.elements.forEach(c);
                this.e.templates.forEach(c);
                if (this.e.templateSettings != null) {
                    c.accept(this.e.templateSettings);
                }
                if (this.e.scalingElem.enabled) {
                    c.accept(this.e.scalingElem);
                }
                c.accept(this.e.texElem);
            } else {
                parent.getTreeElements(c);
            }
        }

        @Override
        protected int bgColor(TreeElement val) {
            int bg = val.bgColor();
            if (bg != 0) {
                return bg;
            }
            if (this.moveElem != null && this.moveElem == val) {
                return this.e.gui().getColors().move_background;
            }
            if (this.isSelected(val)) {
                return this.e.colors().select_background;
            }
            return 0;
        }

        @Override
        protected void treeUpdated() {
            this.e.updateGui();
        }

        @Override
        protected void onClick(MouseEvent evt, TreeElement elem) {
            if (evt.btn == 1 && elem != null) {
                this.displayPopup(evt, elem);
            } else if (elem != null) {
                elem.onClick(this.e, evt);
            } else {
                this.e.selectedElement = null;
            }
        }

        public void displayPopup(MouseEvent evt, TreeElement elem) {
            PopupMenu popup = new PopupMenu(this.e.gui(), this.e.frame);
            if (elem.canMove() || this.moveElem != null && elem.canAccept(this.moveElem)) {
                String btnTxt = this.moveElem != null ? (this.moveElem == elem ? this.e.gui().i18nFormat("button.cpm.tree.cancelMove", new Object[0]) : this.e.gui().i18nFormat("button.cpm.tree.put", new Object[0])) : this.e.gui().i18nFormat("button.cpm.tree.move", new Object[0]);
                popup.addButton(btnTxt, () -> {
                    if (this.moveElem != null) {
                        if (this.moveElem != elem) {
                            elem.accept(this.moveElem);
                        }
                        this.moveElem = null;
                    } else {
                        this.moveElem = elem;
                    }
                });
            }
            elem.populatePopup(popup);
            if (popup.getY() > 0) {
                Vec2i p = evt.getPos();
                popup.display(p.x, p.y);
            }
        }

        @Override
        protected String getName(TreeElement elem) {
            return elem.getName();
        }

        @Override
        protected Tooltip getTooltip(TreeElement elem) {
            if (elem != null) {
                return elem.getTooltip();
            }
            return null;
        }

        @Override
        protected void refresh(TreeElement elem) {
            elem.onRefreshTree();
        }

        @Override
        protected boolean isSelected(TreeElement elem) {
            return this.e.selectedElement != null && this.e.selectedElement.isSelected(this.e, elem);
        }
    }
}

