/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.effects;

import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.effects.IRenderEffect;
import com.tom.cpm.shared.effects.RenderEffects;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.RenderedCube;
import java.io.EOFException;
import java.io.IOException;

public class EffectColor
implements IRenderEffect {
    private int id;
    private int color;

    public EffectColor() {
    }

    public EffectColor(int id, int color) {
        this.id = id;
        this.color = color;
    }

    @Override
    public void load(IOHelper in) throws IOException {
        int ch4;
        int ch3;
        this.id = in.readVarInt();
        int ch2 = in.read();
        if ((ch2 | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        this.color = (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public void write(IOHelper out) throws IOException {
        out.writeVarInt(this.id);
        out.write(this.color >>> 16 & 0xFF);
        out.write(this.color >>> 8 & 0xFF);
        out.write(this.color >>> 0 & 0xFF);
    }

    @Override
    public void apply(ModelDefinition def) {
        RenderedCube cube = def.getElementById(this.id);
        if (cube != null) {
            cube.getCube().rgb = this.color;
            cube.recolor = true;
        }
    }

    @Override
    public RenderEffects getEffect() {
        return RenderEffects.COLOR;
    }

    public String toString() {
        return "Color [" + this.id + "] " + Integer.toHexString(this.color);
    }
}

