/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.effects;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.effects.IRenderEffect;
import com.tom.cpm.shared.effects.RenderEffects;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.ScaleData;
import java.io.IOException;

public class EffectModelScale
implements IRenderEffect {
    private Vec3f pos;
    private Vec3f rotation;
    private Vec3f scale;

    public EffectModelScale() {
    }

    public EffectModelScale(Vec3f pos, Vec3f rotation, Vec3f scale) {
        this.pos = pos;
        this.rotation = rotation;
        this.scale = scale;
    }

    @Override
    public void load(IOHelper in) throws IOException {
        this.pos = in.readVec6b();
        this.rotation = in.readAngle();
        this.scale = in.readVec6b();
    }

    @Override
    public void write(IOHelper out) throws IOException {
        out.writeVec6b(this.pos);
        out.writeAngle(this.rotation);
        out.writeVec6b(this.scale);
    }

    @Override
    public void apply(ModelDefinition def) {
        if (def.getScale() != null) {
            ScaleData d = def.getScale();
            d.setRenderScale(this.pos, this.rotation, this.scale);
        }
    }

    @Override
    public RenderEffects getEffect() {
        return RenderEffects.MODEL_SCALE;
    }
}

