/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.model.render.RenderMode;

public abstract class Panel3d
extends Panel {
    private Panel3dNative nat;
    protected MouseEvent mouse;
    protected Frame frame;

    public Panel3d(Frame frm) {
        super(frm.getGui());
        this.frame = frm;
        this.nat = (Panel3dNative)this.gui.getNative().getNative(Panel3d.class, this);
    }

    public abstract void render(MatrixStack var1, VBuffers var2, float var3);

    public abstract ViewportCamera getCamera();

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.mouse = event.offset(this.bounds);
        this.gui.pushMatrix();
        this.gui.setPosOffset(this.bounds);
        this.gui.setupCut();
        if (this.backgroundColor != 0) {
            this.gui.drawBox(0, 0, this.bounds.w, this.bounds.h, this.backgroundColor);
        }
        if (this.enabled) {
            this.nat.renderPos = this.gui.getOffset();
            this.nat.render(partialTicks);
        }
        for (GuiElement guiElement : this.elements) {
            if (!guiElement.isVisible()) continue;
            guiElement.draw(event.offset(this.bounds), partialTicks);
        }
        this.gui.popMatrix();
        this.gui.setupCut();
        this.mouse = null;
    }

    protected RenderTypes<RenderMode> getRenderTypes() {
        return this.nat.getRenderTypes();
    }

    protected RenderTypes<RenderMode> getRenderTypes(String tex) {
        return this.nat.getRenderTypes(tex);
    }

    @Override
    public IGui getGui() {
        return this.gui;
    }

    public Image takeScreenshot(Vec2i size) {
        return this.nat.takeScreenshot(size);
    }

    public void renderItem(MatrixStack stack, ItemSlot hand, DisplayItem item) {
        this.nat.renderItem(stack, hand, item);
    }

    public Mat4f getView() {
        return this.nat.getView();
    }

    public Mat4f getProjection() {
        return this.nat.getProjection();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public Vec2i get3dSize() {
        return this.nat.get3dSize();
    }

    public Vec2i get3dMousePos() {
        return this.nat.getMouse();
    }

    public void draw3dOverlay() {
        this.nat.draw3dOverlay();
    }

    public MouseEvent getMouse() {
        return this.mouse;
    }

    public static abstract class Panel3dNative {
        protected Panel3d panel;
        protected Vec2i renderPos = new Vec2i();

        public Panel3dNative(Panel3d panel) {
            this.panel = panel;
        }

        public abstract void render(float var1);

        public abstract RenderTypes<RenderMode> getRenderTypes();

        public abstract RenderTypes<RenderMode> getRenderTypes(String var1);

        public abstract Image takeScreenshot(Vec2i var1);

        public abstract void renderItem(MatrixStack var1, ItemSlot var2, DisplayItem var3);

        protected <RL> RenderTypes<RenderMode> getRenderTypes0(RL rl) {
            RenderTypes<RenderMode> renderTypes = new RenderTypes<RenderMode>(RenderMode.class);
            MinecraftClientAccess.get().getRenderBuilder().build(renderTypes, rl);
            return renderTypes;
        }

        public Box getBounds() {
            return this.panel.bounds;
        }

        public abstract Mat4f getView();

        public abstract Mat4f getProjection();

        public Vec2i get3dSize() {
            return new Vec2i(this.panel.frame.getBounds().w, this.panel.frame.getBounds().h);
        }

        public Vec2i getMouse() {
            return this.panel.mouse.getPos();
        }

        public void draw3dOverlay() {
            Box bounds = this.getBounds();
            Vec2i ws = this.get3dSize();
            Vec2i off = this.panel.gui.getOffset();
            float sx = (float)(off.x + bounds.x) / (float)ws.x;
            float sy = (float)(off.y + bounds.y) / (float)ws.y;
            this.panel.gui.drawTexture(bounds.x, bounds.y, bounds.w, bounds.h, sx, sy, sx + (float)bounds.w / (float)ws.x, sy + (float)bounds.h / (float)ws.y);
        }
    }
}

