/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.io;

import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.nbt.NBTTag;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.shared.io.FastByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import java.util.function.Function;

public class IOHelper
implements DataInput,
DataOutput,
Closeable {
    private static final int DIV = 682;
    private DataInputStream din;
    private DataOutputStream dout;
    private ByteArrayOutputStream baos;
    private byte[] dataIn;

    public IOHelper(DataInputStream din) {
        this.din = din;
    }

    public IOHelper(DataOutputStream dout) {
        this.dout = dout;
    }

    public IOHelper(InputStream din) {
        this.din = new DataInputStream(din);
    }

    public IOHelper(OutputStream dout) {
        this.dout = new DataOutputStream(dout);
        if (dout instanceof ByteArrayOutputStream) {
            this.baos = (ByteArrayOutputStream)dout;
        }
    }

    public IOHelper(byte[] data) {
        this(new FastByteArrayInputStream(data));
        this.dataIn = data;
    }

    public IOHelper() {
        this(new ByteArrayOutputStream());
    }

    public IOHelper(String b64) {
        this(Base64.getDecoder().decode(b64));
    }

    public int read() throws IOException {
        return this.din.read();
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.din.readFully(b);
    }

    @Override
    public void close() throws IOException {
        if (this.din != null) {
            this.din.close();
        }
        if (this.dout != null) {
            this.dout.close();
        }
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.din.readFully(b, off, len);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.din.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.din.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.din.readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        return this.din.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.din.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return this.din.readChar();
    }

    @Override
    public final int readInt() throws IOException {
        return this.din.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this.din.readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return this.din.readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this.din.readDouble();
    }

    @Override
    public final String readUTF() throws IOException {
        int i = this.readVarInt();
        if (i < 0) {
            throw new IOException();
        }
        if (i == 0) {
            return "";
        }
        byte[] s = new byte[i];
        this.readFully(s);
        return new String(s, StandardCharsets.UTF_8);
    }

    public String readJUTF() throws IOException {
        return this.din.readUTF();
    }

    @Override
    public void write(int b) throws IOException {
        this.dout.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.dout.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dout.write(b, off, len);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.dout.writeBoolean(v);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.dout.writeByte(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.dout.writeShort(v);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.dout.writeChar(v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.dout.writeInt(v);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.dout.writeLong(v);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.dout.writeFloat(v);
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.dout.writeDouble(v);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.dout.writeBytes(s);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        this.dout.writeChars(s);
    }

    @Override
    public final void writeUTF(String s) throws IOException {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        this.writeVarInt(b.length);
        this.write(b);
    }

    public void writeJUTF(String s) throws IOException {
        this.dout.writeUTF(s);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.din.skipBytes(n);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.din.readLine();
    }

    public void writeVarInt(int toWrite) throws IOException {
        while ((toWrite & 0xFFFFFF80) != 0) {
            this.dout.writeByte(toWrite & 0x7F | 0x80);
            toWrite >>>= 7;
        }
        this.dout.writeByte(toWrite);
    }

    public int readVarInt() throws IOException {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = this.din.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new IOException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public void writeSignedVarInt(int toWrite) throws IOException {
        int sign = toWrite < 0 ? 64 : 0;
        toWrite = Math.abs(toWrite);
        int b = toWrite & 0x3F | sign;
        toWrite >>>= 6;
        while (toWrite != 0) {
            this.dout.writeByte(b | 0x80);
            b = toWrite & 0x7F;
            toWrite >>>= 7;
        }
        this.dout.writeByte(b);
    }

    public int readSignedVarInt() throws IOException {
        int i = 0;
        int sign = 1;
        byte b0 = this.din.readByte();
        if ((b0 & 0x40) != 0) {
            sign = -1;
        }
        i = b0 & 0x3F;
        int j = 6;
        while ((b0 & 0x80) != 0) {
            b0 = this.din.readByte();
            i |= (b0 & 0x7F) << j;
            if ((j += 7) <= 34) continue;
            throw new IOException("SignedVarInt too big");
        }
        return i * sign;
    }

    public Vec3f readVec3ub() throws IOException {
        Vec3f v = new Vec3f();
        v.x = (float)this.din.read() / 10.0f;
        v.y = (float)this.din.read() / 10.0f;
        v.z = (float)this.din.read() / 10.0f;
        return v;
    }

    public void writeVec3ub(Vec3f v) throws IOException {
        this.dout.write(MathHelper.clamp((int)(v.x * 10.0f), 0, 255));
        this.dout.write(MathHelper.clamp((int)(v.y * 10.0f), 0, 255));
        this.dout.write(MathHelper.clamp((int)(v.z * 10.0f), 0, 255));
    }

    public Vec3f readVec3b() throws IOException {
        Vec3f v = new Vec3f();
        v.x = (float)this.din.readByte() / 10.0f;
        v.y = (float)this.din.readByte() / 10.0f;
        v.z = (float)this.din.readByte() / 10.0f;
        return v;
    }

    public void writeVec3b(Vec3f v) throws IOException {
        this.dout.writeByte(MathHelper.clamp((int)(v.x * 10.0f), -128, 127));
        this.dout.writeByte(MathHelper.clamp((int)(v.y * 10.0f), -128, 127));
        this.dout.writeByte(MathHelper.clamp((int)(v.z * 10.0f), -128, 127));
    }

    public Vec3f readAngle() throws IOException {
        Vec3f v = new Vec3f();
        v.x = (float)((double)((float)this.din.readShort() / 65535.0f * 2.0f) * Math.PI);
        v.y = (float)((double)((float)this.din.readShort() / 65535.0f * 2.0f) * Math.PI);
        v.z = (float)((double)((float)this.din.readShort() / 65535.0f * 2.0f) * Math.PI);
        return v;
    }

    public void writeAngle(Vec3f v) throws IOException {
        this.dout.writeShort(MathHelper.clamp((int)(v.x / 360.0f * 65535.0f), 0, 65535));
        this.dout.writeShort(MathHelper.clamp((int)(v.y / 360.0f * 65535.0f), 0, 65535));
        this.dout.writeShort(MathHelper.clamp((int)(v.z / 360.0f * 65535.0f), 0, 65535));
    }

    public Vec3f readVec6b() throws IOException {
        Vec3f v = new Vec3f();
        v.x = this.readFloat2();
        v.y = this.readFloat2();
        v.z = this.readFloat2();
        return v;
    }

    public void writeVec6b(Vec3f v) throws IOException {
        this.writeFloat2(v.x);
        this.writeFloat2(v.y);
        this.writeFloat2(v.z);
    }

    public float readFloat2() throws IOException {
        return (float)this.din.readShort() / 682.0f;
    }

    public void writeFloat2(float f) throws IOException {
        this.dout.writeShort(MathHelper.clamp((int)(f * 682.0f), Short.MIN_VALUE, Short.MAX_VALUE));
    }

    public IOHelper readNextBlock() throws IOException {
        int size = this.readVarInt();
        if (size > 0x100000 || size < 0) {
            throw new IOException();
        }
        byte[] dt = new byte[size];
        this.readFully(dt);
        return new IOHelper(dt);
    }

    public IOHelper writeNextBlock() {
        return new IOHelper(new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                IOHelper.this.writeVarInt(this.count);
                this.writeTo(IOHelper.this.dout);
            }
        });
    }

    public Vec2i read2s() throws IOException {
        return new Vec2i(this.din.readShort(), this.din.readShort());
    }

    public void write2s(Vec2i v) throws IOException {
        this.dout.writeShort(v.x);
        this.dout.writeShort(v.y);
    }

    public Vec2i read2v() throws IOException {
        return new Vec2i(this.readVarInt(), this.readVarInt());
    }

    public void write2v(Vec2i v) throws IOException {
        this.writeVarInt(v.x);
        this.writeVarInt(v.y);
    }

    public DataInputStream getDin() {
        return this.din;
    }

    public DataOutputStream getDout() {
        return this.dout;
    }

    public <T extends Enum<T>> void writeEnum(T val) throws IOException {
        this.writeByte(val.ordinal());
    }

    public <T extends Enum<T>> T readEnum(T[] values) throws IOException {
        byte id = this.readByte();
        return id >= values.length || id < 0 ? null : (T)values[id];
    }

    public void writeUUID(UUID uuid) throws IOException {
        this.writeLong(uuid.getLeastSignificantBits());
        this.writeLong(uuid.getMostSignificantBits());
    }

    public UUID readUUID() throws IOException {
        long l = this.readLong();
        long m = this.readLong();
        return new UUID(m, l);
    }

    public <T extends Enum<T>, B> B readObjectBlock(T[] values, ObjectReader<T, B> reader) throws IOException {
        Enum v = this.readEnum((Enum[])values);
        IOHelper b = this.readNextBlock();
        if (v == null) {
            return null;
        }
        return reader.read(v, b);
    }

    public <T extends Enum<T>, B extends ObjectBlock<T>> void writeObjectBlock(B val) throws IOException {
        this.writeEnum(val.getType());
        try (IOHelper h = this.writeNextBlock();){
            val.write(h);
        }
    }

    public <T extends Enum<T>, B> void writeObjectBlock(B val, Function<B, T> type, ObjectWriter<B> writer) throws IOException {
        Enum t = (Enum)type.apply(val);
        this.writeEnum(t);
        try (IOHelper h = this.writeNextBlock();){
            writer.write(val, h);
        }
    }

    public void reset() throws IOException {
        this.din.reset();
    }

    public ImageBlock readImage() throws IOException {
        return new ImageBlock(this);
    }

    public void writeImage(Image img) throws IOException {
        try (IOHelper h = this.writeNextBlock();){
            img.storeTo(h.getDout());
        }
    }

    public void writeBlock(IOHelper to) throws IOException {
        if (this.dataIn != null) {
            to.writeVarInt(this.dataIn.length);
            to.write(this.dataIn);
            return;
        }
        if (this.baos == null) {
            throw new IOException("Not a byte array backed io handler");
        }
        to.writeVarInt(this.baos.size());
        this.baos.writeTo(to.dout);
    }

    public void writeByteArray(byte[] dataIn) throws IOException {
        this.writeVarInt(dataIn.length);
        this.write(dataIn);
    }

    public byte[] readByteArray() throws IOException {
        int i = this.readVarInt();
        if (i < 0) {
            throw new IOException();
        }
        if (i == 0) {
            return new byte[0];
        }
        byte[] s = new byte[i];
        this.readFully(s);
        return s;
    }

    public String toB64() throws IOException {
        if (this.baos == null && this.dataIn == null) {
            throw new IOException("Not a byte array backed io handler");
        }
        return Base64.getEncoder().encodeToString(this.dataIn != null ? this.dataIn : this.baos.toByteArray());
    }

    public byte[] toBytes() throws IOException {
        if (this.baos == null && this.dataIn == null) {
            throw new IOException("Not a byte array backed io handler");
        }
        return this.dataIn != null ? this.dataIn : this.baos.toByteArray();
    }

    public IOHelper flip() throws IOException {
        return new IOHelper(this.toBytes());
    }

    public int size() throws IOException {
        if (this.dataIn != null) {
            return this.dataIn.length;
        }
        if (this.baos != null) {
            return this.baos.size();
        }
        throw new IOException("Not a byte array backed io handler");
    }

    public int available() throws IOException {
        return this.din.available();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] d = new byte[1024];
        int len = 0;
        while ((len = is.read(d, 0, d.length)) > 0) {
            os.write(d, 0, len);
        }
    }

    public void writeNBT(NBTTag tag) throws IOException {
        this.writeByte(tag.getId());
        if (tag.getId() != 0) {
            this.writeJUTF("");
            tag.write(this);
        }
    }

    public NBTTagCompound readNBT() throws IOException {
        byte type = this.readByte();
        this.readJUTF();
        NBTTag tag = NBTTag.createNewByType(type);
        tag.read(this);
        if (tag instanceof NBTTagCompound) {
            return (NBTTagCompound)tag;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static class ImageBlock {
        private IOHelper buf;
        private Image image;
        private int w;
        private int h;

        public ImageBlock(IOHelper io) throws IOException {
            this.buf = io.readNextBlock();
            if (this.buf.dataIn.length != 0 && ImageIO.isAvailable()) {
                Vec2i size = ImageIO.getSize(this.buf.getDin());
                this.w = size.x;
                this.h = size.y;
                this.buf.reset();
            }
        }

        public int getWidth() {
            return this.w;
        }

        public int getHeight() {
            return this.h;
        }

        public void doReadImage() throws IOException {
            if (this.buf.dataIn.length != 0 && ImageIO.isAvailable()) {
                this.image = Image.loadFrom(this.buf.getDin());
                this.w = this.image.getWidth();
                this.h = this.image.getHeight();
            }
        }

        public Image getImage() {
            return this.image;
        }
    }

    public static interface ObjectBlock<T extends Enum<T>> {
        public void write(IOHelper var1) throws IOException;

        public T getType();
    }

    public static interface ObjectWriter<B> {
        public void write(B var1, IOHelper var2) throws IOException;
    }

    @FunctionalInterface
    public static interface ObjectReader<T, R> {
        public R read(T var1, IOHelper var2) throws IOException;
    }
}

