/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.model.RenderedCube;

public class CopyTransform {
    private final RenderedCube from;
    private final RenderedCube to;
    private final boolean copyPX;
    private final boolean copyPY;
    private final boolean copyPZ;
    private final boolean copyRX;
    private final boolean copyRY;
    private final boolean copyRZ;
    private final boolean copySX;
    private final boolean copySY;
    private final boolean copySZ;
    private final boolean copyVis;

    public CopyTransform(RenderedCube from, RenderedCube to, short copy) {
        this.from = from;
        this.to = to;
        this.copyPX = (copy & 1) != 0;
        this.copyPY = (copy & 2) != 0;
        this.copyPZ = (copy & 4) != 0;
        this.copyRX = (copy & 8) != 0;
        this.copyRY = (copy & 0x10) != 0;
        this.copyRZ = (copy & 0x20) != 0;
        this.copySX = (copy & 0x40) != 0;
        this.copySY = (copy & 0x80) != 0;
        this.copySZ = (copy & 0x100) != 0;
        this.copyVis = (copy & 0x200) != 0;
    }

    public void apply() {
        Vec3f pf = this.from.getTransformPosition();
        Vec3f pt = this.to.getTransformPosition();
        Vec3f rf = this.from.getTransformRotation();
        Vec3f rt = this.to.getTransformRotation();
        Vec3f sf = this.from.getRenderScale();
        Vec3f st = this.to.getRenderScale();
        this.to.setPosition(false, this.copyPX ? pf.x : pt.x, this.copyPY ? pf.y : pt.y, this.copyPZ ? pf.z : pt.z);
        this.to.setRotation(false, this.copyRX ? rf.x : rt.x, this.copyRY ? rf.y : rt.y, this.copyRZ ? rf.z : rt.z);
        this.to.setRenderScale(false, this.copySX ? sf.x : st.x, this.copySY ? sf.y : st.y, this.copySZ ? sf.z : st.z);
        if (this.copyVis) {
            this.to.setVisible(this.from.isVisible());
        }
    }
}

