/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.SkinType;

public enum RootModelValues implements PartValues
{
    CAPE(RootModelType.CAPE, 0.0f, 0.0f, 0.0f, -5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, 0, 0, 0.0f, false),
    ELYTRA_L(RootModelType.ELYTRA_LEFT, 0.0f, 0.0f, 0.0f, -10.0f, 0.0f, 0.0f, 10.0f, 20.0f, 2.0f, 22, 0, 1.0f, false),
    ELYTRA_R(RootModelType.ELYTRA_RIGHT, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 10.0f, 20.0f, 2.0f, 22, 0, 1.0f, true),
    A_HELMET(RootModelType.ARMOR_HELMET, 0.0f, 0.0f, 0.0f, -4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0, 0, 1.0f, false),
    A_BODY(RootModelType.ARMOR_BODY, 0.0f, 0.0f, 0.0f, -4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, 16, 16, 1.0f, false),
    A_LEFT_ARM(RootModelType.ARMOR_LEFT_ARM, 5.0f, 2.0f, 0.0f, -1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, 40, 16, 1.0f, true),
    A_RIGHT_ARM(RootModelType.ARMOR_RIGHT_ARM, -5.0f, 2.0f, 0.0f, -3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, 40, 16, 1.0f, false),
    A_LEGS_BODY(RootModelType.ARMOR_LEGGINGS_BODY, 0.0f, 0.0f, 0.0f, -4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, 16, 16, 0.5f, false),
    A_LEFT_LEG(RootModelType.ARMOR_LEFT_LEG, 1.9f, 12.0f, 0.0f, -2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0, 16, 0.5f, true),
    A_RIGHT_LEG(RootModelType.ARMOR_RIGHT_LEG, -1.9f, 12.0f, 0.0f, -2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0, 16, 0.5f, false),
    A_LEFT_FOOT(RootModelType.ARMOR_LEFT_FOOT, 1.9f, 12.0f, 0.0f, -2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0, 16, 1.0f, true),
    A_RIGHT_FOOT(RootModelType.ARMOR_RIGHT_FOOT, -1.9f, 12.0f, 0.0f, -2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0, 16, 1.0f, false);

    public static final RootModelValues[] VALUES;
    public final RootModelType type;
    public final float px;
    public final float py;
    public final float pz;
    public final float ox;
    public final float oy;
    public final float oz;
    public final float sx;
    public final float sy;
    public final float sz;
    public final float mcscale;
    public final int u;
    public final int v;
    public boolean mirror;

    private RootModelValues(RootModelType type, float px, float py, float pz, float ox, float oy, float oz, float sx, float sy, float sz, int u, int v, float mcscale, boolean mirror) {
        this.type = type;
        this.px = px;
        this.py = py;
        this.pz = pz;
        this.ox = ox;
        this.oy = oy;
        this.oz = oz;
        this.sx = sx;
        this.sy = sy;
        this.sz = sz;
        this.u = u;
        this.v = v;
        this.mcscale = mcscale;
        this.mirror = mirror;
    }

    @Override
    public Vec3f getPos() {
        return new Vec3f(this.px, this.py, this.pz);
    }

    @Override
    public Vec3f getOffset() {
        return new Vec3f(this.ox, this.oy, this.oz);
    }

    @Override
    public Vec3f getSize() {
        return new Vec3f(this.sx, this.sy, this.sz);
    }

    @Override
    public Vec2i getUV() {
        return new Vec2i(this.u, this.v);
    }

    @Override
    public boolean isMirror() {
        return this.mirror;
    }

    @Override
    public float getMCScale() {
        return this.mcscale;
    }

    public static RootModelValues getFor(RootModelType part, SkinType skinType) {
        for (RootModelValues v : VALUES) {
            if (v.type != part) continue;
            return v;
        }
        return null;
    }

    static {
        VALUES = RootModelValues.values();
    }
}

