/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network;

import com.tom.cpl.nbt.NBTTag;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.nbt.NBTTagList;
import com.tom.cpl.nbt.NBTTagString;
import com.tom.cpl.text.IText;
import com.tom.cpl.text.LiteralText;
import com.tom.cpl.util.ThrowingConsumer;
import com.tom.cpl.util.TriConsumer;
import com.tom.cpm.shared.animation.ServerAnimationState;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.ConfigChangeRequest;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.ScaleData;
import com.tom.cpm.shared.network.IPacket;
import com.tom.cpm.shared.network.ModelEventType;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetworkUtil;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.network.packet.GestureC2S;
import com.tom.cpm.shared.network.packet.GetSkinS2C;
import com.tom.cpm.shared.network.packet.HelloC2S;
import com.tom.cpm.shared.network.packet.HelloS2C;
import com.tom.cpm.shared.network.packet.PluginMessageC2S;
import com.tom.cpm.shared.network.packet.PluginMessageS2C;
import com.tom.cpm.shared.network.packet.ReceiveEventS2C;
import com.tom.cpm.shared.network.packet.RecommendSafetyS2C;
import com.tom.cpm.shared.network.packet.ScaleInfoS2C;
import com.tom.cpm.shared.network.packet.ServerAnimationS2C;
import com.tom.cpm.shared.network.packet.SetScaleC2S;
import com.tom.cpm.shared.network.packet.SetSkinC2S;
import com.tom.cpm.shared.network.packet.SetSkinS2C;
import com.tom.cpm.shared.network.packet.SubEventC2S;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.ScalingOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public class NetHandler<RL, P, NET> {
    public static final String GET_SKIN = "get_skin";
    public static final String SET_SKIN = "set_skin";
    public static final String HELLO = "hello";
    public static final String SET_SCALE = "set_scl";
    public static final String RECOMMEND_SAFETY = "rec_sfy";
    public static final String SUBSCRIBE_EVENT = "sub_evt";
    public static final String RECEIVE_EVENT = "rec_evt";
    public static final String GESTURE = "gesture";
    public static final String SERVER_ANIMATION = "srv_anim";
    public static final String PLUGIN = "plugin";
    protected Function<P, UUID> getPlayerUUID;
    private TriConsumer<NET, RL, byte[]> sendPacket;
    private TriConsumer<P, RL, byte[]> sendToAllTracking;
    protected IntFunction<P> getPlayerById;
    protected BiConsumer<P, IText> sendChat;
    protected BiConsumer<P, Consumer<P>> findTracking;
    protected Function<NET, Executor> executor;
    protected Function<P, Object> playerToLoader;
    protected Supplier<P> getClient;
    protected Function<P, NET> getNet;
    protected Function<NET, P> getPlayer;
    protected BiConsumer<P, IText> kickPlayer;
    protected ToIntFunction<P> getPlayerId;
    protected Consumer<IText> displayText;
    protected Supplier<Collection<? extends P>> getOnlinePlayers;
    protected Map<ScalingOptions, BiConsumer<P, Float>> scaleSetters = new EnumMap<ScalingOptions, BiConsumer<P, Float>>(ScalingOptions.class);
    protected BiConsumer<? super P, ServerAnimationState> animStateUpdate;
    private List<ConfigChangeRequest<?, ?>> recommendedSettingChanges = new ArrayList();
    private EnumSet<ServerCaps> serverCaps = EnumSet.noneOf(ServerCaps.class);
    private boolean scalingWarning;
    protected Map<RL, Supplier<IPacket>> packetS2C = new HashMap<RL, Supplier<IPacket>>();
    protected Map<RL, Supplier<IPacket>> packetC2S = new HashMap<RL, Supplier<IPacket>>();
    protected Map<Class<? extends IPacket>, RL> packetLookup = new HashMap<Class<? extends IPacket>, RL>();
    private BiFunction<String, String, RL> keyFactory;

    public NetHandler(BiFunction<String, String, RL> keyFactory) {
        this.keyFactory = keyFactory;
        this.register(this.packetC2S, HELLO, HelloC2S.class, HelloC2S::new);
        this.register(this.packetS2C, HELLO, HelloS2C.class, HelloS2C::new);
        this.register(this.packetC2S, SET_SKIN, SetSkinC2S.class, SetSkinC2S::new);
        this.register(this.packetS2C, SET_SKIN, SetSkinS2C.class, SetSkinS2C::new);
        this.register(this.packetS2C, GET_SKIN, GetSkinS2C.class, GetSkinS2C::new);
        this.register(this.packetC2S, SET_SCALE, SetScaleC2S.class, SetScaleC2S::new);
        this.register(this.packetS2C, SET_SCALE, ScaleInfoS2C.class, ScaleInfoS2C::new);
        this.register(this.packetS2C, RECOMMEND_SAFETY, RecommendSafetyS2C.class, RecommendSafetyS2C::new);
        this.register(this.packetC2S, SUBSCRIBE_EVENT, SubEventC2S.class, SubEventC2S::new);
        this.register(this.packetS2C, RECEIVE_EVENT, ReceiveEventS2C.class, ReceiveEventS2C::new);
        this.register(this.packetC2S, GESTURE, GestureC2S.class, GestureC2S::new);
        this.register(this.packetS2C, SERVER_ANIMATION, ServerAnimationS2C.class, ServerAnimationS2C::new);
        this.register(this.packetC2S, PLUGIN, PluginMessageC2S.class, PluginMessageC2S::new);
        this.register(this.packetS2C, PLUGIN, PluginMessageS2C.class, PluginMessageS2C::new);
    }

    protected <PCKT extends IPacket> void register(Map<RL, Supplier<IPacket>> map, String name, Class<PCKT> clazz, Supplier<PCKT> factory) {
        RL key = this.keyFactory.apply("cpm_net", name);
        map.put(key, factory);
        this.packetLookup.put(clazz, key);
    }

    public void onJoin(P player) {
        NBTTagCompound data = new NBTTagCompound();
        int kickTimer = ModConfig.getWorldConfig().getInt("kickPlayersWithoutMod", 0);
        data.setInteger("kickTime", kickTimer);
        data.setTag("caps", this.writeCaps());
        NetH.ServerNetH net = this.getSNetH(player);
        PlayerData pd = this.newData();
        net.cpm$setEncodedModelData(pd);
        pd.load(this.getID(player));
        NBTTagCompound scaling = new NBTTagCompound();
        data.setTag("scaling", scaling);
        for (ScalingOptions o : this.scaleSetters.keySet()) {
            float v = pd.scale.getOrDefault((Object)o, Float.valueOf(1.0f)).floatValue();
            if (v == 1.0f) continue;
            scaling.setFloat(o.getNetKey(), v);
        }
        this.sendPacketTo0(net, new HelloS2C(data));
    }

    private NBTTag writeCaps() {
        NBTTagCompound data = new NBTTagCompound();
        this.scaleSetters.keySet().stream().map(ScalingOptions::getCaps).filter(e -> e != null).distinct().forEach(c -> this.setCap(data, (ServerCaps)((Object)c)));
        this.setCap(data, ServerCaps.MODEL_EVENT_SUBS);
        this.setCap(data, ServerCaps.GESTURES);
        this.setCap(data, ServerCaps.PLUGIN_MESSAGES);
        return data;
    }

    private void setCap(NBTTagCompound tag, ServerCaps caps) {
        tag.setBoolean(caps.name().toLowerCase(Locale.ROOT), true);
    }

    protected PlayerData newData() {
        return new PlayerData();
    }

    public void receiveServer(RL key, InputStream data, NetH.ServerNetH net) {
        this.processPacket(this.packetC2S, key, data, net);
    }

    public void receiveClient(RL key, InputStream data, NetH net) {
        this.processPacket(this.packetS2C, key, data, net);
    }

    private void processPacket(Map<RL, Supplier<IPacket>> map, RL key, InputStream data, NetH net) {
        try {
            Supplier<IPacket> factory = map.get(key);
            if (factory != null) {
                IPacket pckt = factory.get();
                IOHelper h = new IOHelper(data);
                pckt.read(h);
                pckt.handleRaw(this, net);
            }
        }
        catch (Throwable e) {
            Log.error("Exception while processing cpm packet: " + key, e);
        }
    }

    public void handleServerCaps(NBTTagCompound tag) {
        this.serverCaps.clear();
        for (ServerCaps c : ServerCaps.VALUES) {
            if (!tag.getBoolean(c.name().toLowerCase(Locale.ROOT))) continue;
            this.serverCaps.add(c);
        }
    }

    public void sendSkinData() {
        if (this.hasModClient()) {
            NetworkUtil.sendSkinDataToServer(this);
        }
    }

    public void setSkin(P pl, String skin, boolean force, boolean save) {
        NetH.ServerNetH h = this.getSNetH(pl);
        PlayerData pd = h.cpm$getEncodedModelData();
        pd.setModel(skin, force, save);
        if (skin == null) {
            this.sendPacketTo(h, new GetSkinS2C());
        }
        this.sendPacketToTracking(pl, NetworkUtil.writeSkinData(this, pd, pl));
        pd.save(this.getID(pl));
    }

    public void setSkin(P pl, byte[] skin, boolean force) {
        PlayerData pd = this.getSNetH(pl).cpm$getEncodedModelData();
        pd.setModel(skin, force, false);
        this.sendPacketToTracking(pl, NetworkUtil.writeSkinData(this, pd, pl));
        pd.save(this.getID(pl));
    }

    public void setScale(ScaleData scl) {
        if (this.hasModClient() && this.serverCaps.contains((Object)ServerCaps.SCALING)) {
            if (scl == null) {
                scl = ScaleData.NULL;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            for (Map.Entry<ScalingOptions, Float> e : scl.getScaling().entrySet()) {
                if (!this.serverCaps.contains((Object)e.getKey().getCaps())) continue;
                nbt.setFloat(e.getKey().getNetKey(), e.getValue().floatValue());
            }
            this.sendPacketToServer(new SetScaleC2S(nbt));
        }
    }

    public void onRespawn(P pl) {
        PlayerData pd = this.getSNetH(pl).cpm$getEncodedModelData();
        for (Map.Entry<ScalingOptions, BiConsumer<P, Float>> e : this.scaleSetters.entrySet()) {
            float sc = pd.scale.getOrDefault((Object)e.getKey(), Float.valueOf(1.0f)).floatValue();
            if (sc == 1.0f && sc == 0.0f) continue;
            e.getValue().accept(pl, Float.valueOf(sc));
        }
    }

    public void tick() {
        int kickTimer = ModConfig.getWorldConfig().getInt("kickPlayersWithoutMod", 0);
        for (P p : new ArrayList<P>(this.getOnlinePlayers.get())) {
            NetH.ServerNetH net = this.getSNetH(p);
            PlayerData dt = net.cpm$getEncodedModelData();
            if (dt == null) continue;
            if (!net.cpm$hasMod()) {
                ++dt.ticksSinceLogin;
                if (kickTimer > 0 && dt.ticksSinceLogin > (long)kickTimer) {
                    this.kickPlayer.accept(p, new LiteralText(ModConfig.getWorldConfig().getString("kickMessage", "Customizable Player Models is requied on this server")));
                }
            }
            NBTTagCompound evt = new NBTTagCompound();
            this.updatePlayer(p, dt.state);
            for (ModelEventType type : ModelEventType.SNYC_TYPES) {
                if (!dt.eventSubs.contains((Object)type)) continue;
                type.write(dt.state, evt);
            }
            if (evt.tagCount() <= 0) continue;
            this.sendPacketToTracking(p, new ReceiveEventS2C(this.getPlayerId.applyAsInt(p), evt));
        }
    }

    public void updatePlayer(P player, ServerAnimationState state) {
        this.animStateUpdate.accept(player, state);
    }

    public boolean hasModClient() {
        NET n = this.getClientNet();
        return n instanceof NetH && ((NetH)n).cpm$hasMod();
    }

    public void onLogOut() {
        this.recommendedSettingChanges.clear();
        this.serverCaps.clear();
        this.scalingWarning = false;
    }

    public void sendEventSubs(ModelDefinition def) {
        if (this.serverCaps.contains((Object)ServerCaps.MODEL_EVENT_SUBS)) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            tag.setTag("eventList", list);
            def.getAnimations().getAnimations().keySet().stream().filter(e -> e instanceof VanillaPose).map(ModelEventType::getType).filter(e -> e != null).distinct().map(ModelEventType::getName).map(NBTTagString::new).forEach(list::appendTag);
            this.sendPacketToServer(new SubEventC2S(tag));
        }
    }

    public boolean hasServerCap(ServerCaps cap) {
        return this.hasModClient() && this.serverCaps.contains((Object)cap);
    }

    public void onJump(P p) {
        this.onEvent(p, ModelEventType.JUMPING);
    }

    public void onEvent(P p, ModelEventType event) {
        NetH.ServerNetH net = this.getSNetH(p);
        PlayerData dt = net.cpm$getEncodedModelData();
        if (!event.autoSync() && dt != null && dt.eventSubs.contains((Object)event)) {
            NBTTagCompound evt = new NBTTagCompound();
            event.write(dt.state, evt);
            this.sendPacketToTracking(p, new ReceiveEventS2C(this.getPlayerId.applyAsInt(p), evt));
        }
    }

    public void playAnimation(P p, String animation, int value) {
        this.sendPacketTo(this.getSNetH(p), new ServerAnimationS2C(animation, value));
    }

    public boolean sendPluginMessage(String id, NBTTagCompound msg, int flags) {
        if (this.hasModClient() && this.serverCaps.contains((Object)ServerCaps.PLUGIN_MESSAGES)) {
            this.sendPacketToServer(new PluginMessageC2S(id, msg, flags));
            return true;
        }
        return false;
    }

    public String getID(P pl) {
        return this.getPlayerUUID.apply(pl).toString();
    }

    public NET getClientNet() {
        return this.getNet.apply(this.getClient.get());
    }

    public NetH.ServerNetH getSNetH(P player) {
        return (NetH.ServerNetH)this.getNet.apply(player);
    }

    public void sendPlayerData(P target, P to) {
        NetworkUtil.sendPlayerData(this, target, to);
    }

    public void execute(NetH net, Runnable task) {
        this.executor.apply(net).execute(task);
    }

    public List<ConfigChangeRequest<?, ?>> getRecommendedSettingChanges() {
        return this.recommendedSettingChanges;
    }

    public void setGetPlayerUUID(Function<P, UUID> getPlayerUUID) {
        this.getPlayerUUID = getPlayerUUID;
    }

    public <PB> void setSendPacketDirect(Function<byte[], PB> wrapper, TriConsumer<NET, RL, PB> sendPacket, TriConsumer<P, RL, PB> sendToAllTracking) {
        this.sendPacket = (a, b, c) -> sendPacket.accept(a, b, wrapper.apply((byte[])c));
        this.sendToAllTracking = (a, b, c) -> sendToAllTracking.accept(a, b, wrapper.apply((byte[])c));
    }

    public void setSendPacketDirect(TriConsumer<NET, RL, byte[]> sendPacket, TriConsumer<P, RL, byte[]> sendToAllTracking) {
        this.sendPacket = sendPacket;
        this.sendToAllTracking = sendToAllTracking;
    }

    public <PB> void setSendPacketClient(Function<byte[], PB> wrapper, TriConsumer<NET, RL, PB> sendPacket) {
        this.sendPacket = (a, b, c) -> sendPacket.accept(a, b, wrapper.apply((byte[])c));
    }

    public void setSendPacketClient(TriConsumer<NET, RL, byte[]> sendPacket) {
        this.sendPacket = sendPacket;
    }

    private void sendPacketServer(P to, RL pck, byte[] data) {
        NET n = this.getNet.apply(to);
        if (n instanceof NetH.ServerNetH && ((NetH.ServerNetH)n).cpm$hasMod()) {
            this.sendPacket.accept(n, pck, data);
        }
    }

    public <PB, C> void setSendPacketServer(Function<byte[], PB> wrapper, TriConsumer<NET, RL, PB> sendPacket, Function<P, Collection<C>> forEachTracking, Function<C, P> toPlayer) {
        this.sendPacket = (a, b, c) -> sendPacket.accept(a, b, wrapper.apply((byte[])c));
        this.sendToAllTracking = (p, rl, d) -> {
            for (Object t : (Collection)forEachTracking.apply(p)) {
                this.sendPacketServer((P)toPlayer.apply(t), (RL)rl, (byte[])d);
            }
            this.sendPacketServer((P)p, (RL)rl, (byte[])d);
        };
    }

    public void setFindTracking(BiConsumer<P, Consumer<P>> findTracking) {
        this.findTracking = findTracking;
    }

    public void setSendChat(BiConsumer<P, IText> sendChat) {
        this.sendChat = sendChat;
    }

    public void setExecutor(Supplier<Executor> executor) {
        this.executor = v -> (Executor)executor.get();
    }

    public void setExecutor(Function<NET, Executor> executor) {
        this.executor = executor;
    }

    public void setPlayerToLoader(Function<P, Object> playerToloader) {
        this.playerToLoader = playerToloader;
    }

    public void setGetClient(Supplier<P> getClient) {
        this.getClient = getClient;
    }

    public void setGetNet(Function<P, NET> getNet) {
        this.getNet = getNet;
    }

    public void setGetPlayer(Function<NET, P> getPlayer) {
        this.getPlayer = getPlayer;
    }

    public void setKickPlayer(BiConsumer<P, IText> kickPlayer) {
        this.kickPlayer = kickPlayer;
    }

    public void setGetPlayerById(IntFunction<P> getPlayerById) {
        this.getPlayerById = getPlayerById;
    }

    public void setGetPlayerId(ToIntFunction<P> getPlayerId) {
        this.getPlayerId = getPlayerId;
    }

    public void setDisplayText(Consumer<IText> displayText) {
        this.displayText = displayText;
    }

    public void setGetOnlinePlayers(Supplier<Collection<? extends P>> getOnlinePlayers) {
        this.getOnlinePlayers = getOnlinePlayers;
    }

    public void setGetPlayerAnimGetters(BiConsumer<? super P, ServerAnimationState> animStateUpdate) {
        this.animStateUpdate = animStateUpdate;
    }

    public <E extends Throwable> void registerOut(ThrowingConsumer<RL, E> reg) throws E {
        for (RL e : this.packetS2C.keySet()) {
            reg.accept(e);
        }
    }

    public <E extends Throwable> void registerIn(ThrowingConsumer<RL, E> reg) throws E {
        for (RL e : this.packetC2S.keySet()) {
            reg.accept(e);
        }
    }

    public <K> void setScaler(ScalerInterface<P, K> intf) {
        for (ScalingOptions opt : ScalingOptions.VALUES) {
            Object key;
            try {
                key = intf.toKey(opt);
            }
            catch (Throwable e) {
                Log.warn("Failed to create scaler key for " + opt.name().toLowerCase(Locale.ROOT) + ". Make sure your scaling supported mods are up to date!", e);
                continue;
            }
            if (key == null) continue;
            this.scaleSetters.put(opt, (p, v) -> intf.setScale(key, p, v.floatValue()));
        }
    }

    public BiConsumer<P, Float> setScaler(ScalingOptions key, BiConsumer<P, Float> value) {
        return this.scaleSetters.put(key, value);
    }

    public boolean isSupported(ScalingOptions o) {
        return this.scaleSetters.containsKey((Object)o);
    }

    public P getPlayer(NetH.ServerNetH net) {
        return this.getPlayer.apply(net);
    }

    public void forEachTracking(P pl, Consumer<P> cons) {
        this.findTracking.accept(pl, cons);
    }

    public void sendPacketTo(NetH.ServerNetH net, IPacket packet) {
        if (!net.cpm$hasMod()) {
            return;
        }
        this.sendPacketTo0(net, packet);
    }

    public void sendPacketToServer(IPacket packet) {
        if (!this.hasModClient()) {
            return;
        }
        this.sendPacketTo0(this.getClientNet(), packet);
    }

    private void sendPacketTo0(NET net, IPacket packet) {
        byte[] data;
        RL id = this.packetLookup.get(packet.getClass());
        if (id == null) {
            return;
        }
        try {
            data = this.packet2byte(packet);
        }
        catch (IOException e) {
            return;
        }
        this.sendPacket.accept(net, id, data);
    }

    public void sendPacketToTracking(P player, IPacket packet) {
        byte[] data;
        RL id = this.packetLookup.get(packet.getClass());
        if (id == null) {
            return;
        }
        try {
            data = this.packet2byte(packet);
        }
        catch (IOException e) {
            return;
        }
        this.sendToAllTracking.accept(player, id, data);
    }

    private byte[] packet2byte(IPacket pckt) throws IOException {
        IOHelper h = new IOHelper();
        pckt.write(h);
        return h.toBytes();
    }

    public int getPlayerId(P target) {
        return this.getPlayerId.applyAsInt(target);
    }

    public void sendChat(P player, IText chatMsg) {
        this.sendChat.accept(player, chatMsg);
    }

    public Map<ScalingOptions, BiConsumer<P, Float>> getScaleSetters() {
        return this.scaleSetters;
    }

    public void displayText(IText text) {
        this.displayText.accept(text);
    }

    public P getPlayerById(int entityId) {
        return this.getPlayerById.apply(entityId);
    }

    public Object getLoaderId(P player) {
        return this.playerToLoader.apply(player);
    }

    public void setScalingWarning() {
        this.scalingWarning = true;
    }

    public boolean hasScalingWarning() {
        return this.scalingWarning;
    }

    public static interface ScalerInterface<P, K> {
        public void setScale(K var1, P var2, float var3);

        public K toKey(ScalingOptions var1);
    }
}

