/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network.packet;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.network.IC2SPacket;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.packet.ReceiveEventS2C;
import java.io.IOException;

public class GestureC2S
implements IC2SPacket {
    private byte[] gestureData;

    public GestureC2S() {
    }

    public GestureC2S(byte[] gestureData) {
        this.gestureData = gestureData;
    }

    @Override
    public void read(IOHelper pb) throws IOException {
        this.gestureData = pb.readByteArray();
    }

    @Override
    public void write(IOHelper pb) throws IOException {
        pb.writeByteArray(this.gestureData);
    }

    @Override
    public <P> void handle(NetHandler<?, P, ?> handler, NetH.ServerNetH net, P player) {
        if (this.gestureData.length > 128) {
            return;
        }
        PlayerData pd = net.cpm$getEncodedModelData();
        pd.gestureData = this.gestureData;
        NBTTagCompound evt = new NBTTagCompound();
        evt.setByteArray("gesture", this.gestureData);
        handler.sendPacketToTracking(player, new ReceiveEventS2C(handler.getPlayerId(player), evt));
    }
}

