/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network.packet;

import com.tom.cpl.math.MathHelper;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.nbt.NBTTagList;
import com.tom.cpl.nbt.NBTTagString;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.NetworkUtil;
import com.tom.cpm.shared.network.packet.NBTC2S;
import com.tom.cpm.shared.network.packet.ScaleInfoS2C;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;

public class SetScaleC2S
extends NBTC2S {
    public SetScaleC2S(NBTTagCompound data) {
        super(data);
    }

    public SetScaleC2S() {
    }

    @Override
    public <P> void handle(NetHandler<?, P, ?> handler, NetH.ServerNetH net, P pl) {
        PlayerData pd = net.cpm$getEncodedModelData();
        ArrayList<ScalingOptions> blocked = new ArrayList<ScalingOptions>();
        for (Map.Entry<ScalingOptions, BiConsumer<P, Float>> e : handler.getScaleSetters().entrySet()) {
            float selNewV;
            float oldV = pd.scale.getOrDefault((Object)e.getKey(), Float.valueOf(1.0f)).floatValue();
            float newV = selNewV = this.tag.getFloat(e.getKey().getNetKey());
            Pair<Float, Float> l = NetworkUtil.getScalingLimits(e.getKey(), handler.getID(pl));
            newV = newV == 0.0f || l == null ? 1.0f : MathHelper.clamp(newV, l.getKey().floatValue(), l.getValue().floatValue());
            Log.debug("Scaling " + (Object)((Object)e.getKey()) + " " + oldV + " -> " + newV);
            if (newV != oldV) {
                e.getValue().accept(pl, Float.valueOf(newV));
                pd.scale.put(e.getKey(), Float.valueOf(newV));
            }
            if (newV == selNewV || selNewV == 0.0f) continue;
            blocked.add(e.getKey());
        }
        pd.save(handler.getID(pl));
        NBTTagCompound ret = new NBTTagCompound();
        if (!blocked.isEmpty()) {
            NBTTagList list = new NBTTagList();
            blocked.forEach(sc -> list.appendTag(new NBTTagString(sc.getNetKey())));
            ret.setTag("scaling", list);
        }
        handler.sendPacketTo(net, new ScaleInfoS2C(ret));
    }
}

