/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.tom.cpl.function.FloatBiFunction;
import com.tom.cpl.function.FloatFunction;
import com.tom.cpl.function.FloatSupplier;
import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpm.externals.com.udojava.evalex.Expression;
import com.tom.cpm.shared.io.IOHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpressionExt
extends Expression {
    private Set<String> customFunc;

    public ExpressionExt(String expression) {
        super(expression);
        this.variables.put("E", Float.valueOf((float)Math.E));
    }

    public ExpressionExt(CompiledExpression cex) {
        super(null);
        this.rpn = new ArrayList();
        cex.operations.forEach(op -> op.addToRPN(this.rpn));
    }

    public CompiledExpression compile(ExpContext ctx) {
        this.getRPN();
        CompiledExpression cex = new CompiledExpression();
        for (String token : this.rpn) {
            boolean encoded = false;
            for (CompiledExpression.Opcode op : CompiledExpression.Opcode.VALUES) {
                if (op.value == null || !token.equals(op.value)) continue;
                cex.operations.add(new CompiledExpression.Op(op, token));
                encoded = true;
                break;
            }
            if (encoded) continue;
            if (this.variables.containsKey(token)) {
                cex.operations.add(new CompiledExpression.Op(CompiledExpression.Opcode.LOAD, token));
                continue;
            }
            if (this.functions.containsKey(token.toUpperCase())) {
                if (this.customFunc.contains(token)) {
                    cex.operations.add(new CompiledExpression.Op(CompiledExpression.Opcode.INVOKE, token));
                    continue;
                }
                cex.operations.add(new CompiledExpression.Op(CompiledExpression.Opcode.INVOKE_BUILTIN_FUNC, token));
                continue;
            }
            if (token.equals("0")) {
                cex.operations.add(new CompiledExpression.Op(CompiledExpression.Opcode.ICONST_0, token));
                continue;
            }
            if (token.equals("1")) {
                cex.operations.add(new CompiledExpression.Op(CompiledExpression.Opcode.ICONST_1, token));
                continue;
            }
            try {
                int v = Integer.parseInt(token);
                if (v > 1 && v < 0x7FFFFFF) {
                    cex.operations.add(new CompiledExpression.Op(CompiledExpression.Opcode.VICONST, token));
                    continue;
                }
                cex.operations.add(new CompiledExpression.Op(CompiledExpression.Opcode.ICONST, token));
            }
            catch (NumberFormatException numberFormatException) {
                cex.operations.add(new CompiledExpression.Op(CompiledExpression.Opcode.FCONST, token));
            }
        }
        return cex;
    }

    @Override
    @Deprecated
    public Expression.Function addFunction(Expression.Function function) {
        return super.addFunction(function);
    }

    @Override
    @Deprecated
    public Expression.Operator addOperator(Expression.Operator operator) {
        return super.addOperator(operator);
    }

    public void addFunction(String name, final FloatSupplier func) {
        this.customFunc.add(name);
        this.addFunction(new Expression.Function(name, 0){

            @Override
            public float eval(List<Float> parameters) {
                return func.getAsFloat();
            }
        });
    }

    public void addFunction(String name, final FloatFunction func) {
        this.customFunc.add(name);
        this.addFunction(new Expression.Function(name, 1){

            @Override
            public float eval(List<Float> parameters) {
                return func.apply(parameters.get(0).floatValue());
            }
        });
    }

    public void addFunction(String name, final FloatBiFunction func) {
        this.customFunc.add(name);
        this.addFunction(new Expression.Function(name, 2){

            @Override
            public float eval(List<Float> parameters) {
                return func.apply(parameters.get(0).floatValue(), parameters.get(1).floatValue());
            }
        });
    }

    public void addFunction(String name, int args, final ToFloatFunction<List<Float>> func) {
        this.customFunc.add(name);
        this.addFunction(new Expression.Function(name, args){

            @Override
            public float eval(List<Float> parameters) {
                return func.apply(parameters);
            }
        });
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.rpn = null;
    }

    public ExpressionExt setVariables(Map<String, Float> variables) {
        this.variables.putAll(variables);
        return this;
    }

    public static interface ExpContext {
        public String loadVar(IOHelper var1) throws IOException;

        public void storeVar(String var1, IOHelper var2) throws IOException;

        public String loadFunc(IOHelper var1) throws IOException;

        public void storeFunc(String var1, IOHelper var2) throws IOException;
    }

    public static class CompiledExpression {
        private List<Op> operations = new ArrayList<Op>();
        private List<String> usedFields;

        public CompiledExpression(IOHelper in, ExpContext ctx) throws IOException {
            while (true) {
                int op;
                if ((op = in.read()) >= Opcode.VALUES.length) {
                    throw new IOException("Illegal opcode in expression");
                }
                Opcode opcode = Opcode.VALUES[op];
                if (opcode == Opcode.END) break;
                this.operations.add(new Op(opcode, in, ctx));
            }
        }

        private CompiledExpression() {
        }

        public void write(IOHelper out, ExpContext ctx) throws IOException {
            for (Op op : this.operations) {
                out.write(op.opcode.ordinal());
                op.opcode.store.store(out, ctx, op);
            }
            out.write(Opcode.END.ordinal());
        }

        @FunctionalInterface
        public static interface OpStore {
            public static final OpStore NO_ARGS = (io, ctx, op) -> {};

            public void store(IOHelper var1, ExpContext var2, Op var3) throws IOException;
        }

        @FunctionalInterface
        public static interface OpInit {
            public void init(IOHelper var1, ExpContext var2, Op var3) throws IOException;
        }

        public static class Op {
            private final Opcode opcode;
            private String value;

            public Op(Opcode opcode, String value) {
                this.opcode = opcode;
                this.value = value;
            }

            public Op(Opcode opcode, IOHelper io, ExpContext ctx) throws IOException {
                this(opcode, null);
                opcode.init.init(io, ctx, this);
            }

            public void addToRPN(List<String> rpn) {
                rpn.add(this.value);
            }

            public void setValue(String value) {
                this.value = value;
            }
        }

        public static enum Functions {
            NOT,
            IF,
            RANDOM,
            SIN,
            COS,
            TAN,
            SINH,
            COSH,
            TANH,
            RAD,
            DEG,
            MAX,
            MIN,
            ABS,
            LOG,
            LOG10,
            ROUND,
            FLOOR,
            CEILING,
            SQRT;

            private static final Functions[] VALUES;

            private static void read(IOHelper io, ExpContext ctx, Op op) throws IOException {
                int f = io.read();
                if (f >= VALUES.length) {
                    throw new IOException("Unknown function");
                }
                op.setValue(VALUES[f].name());
            }

            private static void store(IOHelper io, ExpContext ctx, Op op) throws IOException {
                Enum func = null;
                for (Functions f : VALUES) {
                    if (!f.name().equals(op.value)) continue;
                    func = f;
                    break;
                }
                if (func == null) {
                    throw new IOException("Unknown function");
                }
                io.write(func.ordinal());
            }

            static {
                VALUES = Functions.values();
            }
        }

        public static enum Opcode {
            LOAD((io, ctx, op) -> op.setValue(ctx.loadVar(io)), (io, ctx, op) -> ctx.storeVar(op.value, io)),
            OP_ADD("+"),
            OP_SUB("-"),
            OP_MUL("*"),
            OP_DIV("/"),
            OP_REM("%"),
            OP_POW("^"),
            OP_AND("&&"),
            OP_OR("||"),
            OP_CMP_L(">"),
            OP_CMP_LEQ(">="),
            OP_CMP_G("<"),
            OP_CMP_GEQ("<="),
            OP_EQ("="),
            OP_NEQ("!="),
            ICONST((io, ctx, op) -> Integer.toString(io.readInt()), (io, ctx, op) -> io.writeInt(Integer.parseInt(op.value))),
            VICONST((io, ctx, op) -> Integer.toString(io.readVarInt()), (io, ctx, op) -> io.writeVarInt(Integer.parseInt(op.value))),
            FCONST((io, ctx, op) -> Float.toString(io.readFloat()), (io, ctx, op) -> io.writeFloat(Float.parseFloat(op.value))),
            ICONST_0("FALSE"),
            ICONST_1("TRUE"),
            FCONST_PI("PI"),
            FCONST_E("E"),
            INVOKE_BUILTIN_FUNC((x$0, x$1, x$2) -> Functions.access$700(x$0, x$1, x$2), (x$0, x$1, x$2) -> Functions.access$600(x$0, x$1, x$2)),
            INVOKE((io, ctx, op) -> op.setValue(ctx.loadFunc(io)), (io, ctx, op) -> ctx.storeFunc(op.value, io)),
            END;

            public static final Opcode[] VALUES;
            private final OpInit init;
            private final OpStore store;
            private String value;

            private Opcode(OpInit init, OpStore store) {
                this.init = init;
                this.store = store;
            }

            private Opcode(String append) {
                this.init = (io, ctx, op) -> op.setValue(append);
                this.store = OpStore.NO_ARGS;
                this.value = append;
            }

            private Opcode() {
                this.init = null;
                this.store = null;
            }

            static {
                VALUES = Opcode.values();
            }
        }
    }
}

