/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.MarkdownParser;
import com.tom.cpl.util.MarkdownRenderer;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.MdResourceIO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;

public class MdResourceLoader
implements MarkdownRenderer.MarkdownResourceLoader {
    private static final LoadingCache<String, CompletableFuture<Image>> imageCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(MdResourceLoader::loadImage0));
    private static final LoadingCache<String, CompletableFuture<String>> pageCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(MdResourceLoader::loadPage0));
    private boolean offline;
    private Consumer<String> openURL;
    private Consumer<String> nextPage;

    public MdResourceLoader(Consumer<String> openURL, Consumer<String> nextPage, boolean offline) {
        this.offline = offline;
        this.openURL = openURL;
        this.nextPage = nextPage;
    }

    private static CompletableFuture<Image> loadImage0(String url) {
        return MdResourceIO.loadImage0(url, false);
    }

    private static CompletableFuture<String> loadPage0(String url) {
        return MdResourceLoader.fetch(url, false).thenApply(pg -> new String((byte[])pg, StandardCharsets.UTF_8));
    }

    @Override
    public CompletableFuture<Image> loadImage(String url) {
        if (this.offline) {
            return MdResourceIO.loadImage0(url, true);
        }
        try {
            return (CompletableFuture)imageCache.get((Object)url);
        }
        catch (ExecutionException e) {
            CompletableFuture<Image> f = new CompletableFuture<Image>();
            f.completeExceptionally(e.getCause());
            return f;
        }
    }

    private CompletableFuture<String> loadPage(String url) {
        if (this.offline) {
            return MdResourceLoader.fetch(url, true).thenApply(pg -> new String((byte[])pg, StandardCharsets.UTF_8));
        }
        try {
            return (CompletableFuture)pageCache.get((Object)url);
        }
        catch (ExecutionException e) {
            CompletableFuture<String> f = new CompletableFuture<String>();
            f.completeExceptionally(e.getCause());
            return f;
        }
    }

    @Override
    public void browse(MarkdownRenderer rd, String url) {
        if (url.equals("https://github.com/tom5454/CustomPlayerModels/wiki")) {
            this.browse(rd, "https://github.com/tom5454/CustomPlayerModels/wiki/Home.md");
        } else if (url.startsWith("https://github.com/tom5454/CustomPlayerModels/wiki/")) {
            String nm;
            if (this.nextPage != null) {
                this.nextPage.accept(url);
            }
            ((CompletableFuture)this.loadPage((nm = url.substring(url.lastIndexOf(47) + 1)).contains("#") ? url.substring(0, url.lastIndexOf(35)) : url).thenAcceptAsync(pg -> {
                rd.setContent(new MarkdownParser((String)pg));
                if (nm.contains("#")) {
                    rd.browse(nm.substring(nm.indexOf(35)));
                }
            }, rd.getGui()::executeLater)).exceptionally(e -> {
                rd.getGui().executeLater(() -> rd.setContent(MarkdownParser.makeErrorPage(rd.getGui(), e)));
                return null;
            });
        } else if (this.openURL != null) {
            this.openURL.accept(url);
        }
    }

    public static CompletableFuture<byte[]> fetch(String url, boolean offline) {
        if (url.equals("https://github.com/tom5454/CustomPlayerModels/wiki")) {
            return MdResourceLoader.fetch("https://github.com/tom5454/CustomPlayerModels/wiki/Home.md", offline);
        }
        if (url.startsWith("https://github.com/tom5454/CustomPlayerModels/wiki/") && url.endsWith(".md")) {
            if (offline) {
                return MdResourceLoader.asset0("/assets/cpm/wiki/pages/" + url.substring(url.lastIndexOf(47) + 1));
            }
            return MdResourceLoader.fetchOnline(url);
        }
        if (url.startsWith("https://github.com/tom5454/CustomPlayerModels/wiki/images/")) {
            if (offline) {
                return MdResourceLoader.asset0("/assets/cpm/wiki/images/" + url.substring(url.lastIndexOf(47) + 1));
            }
            return MdResourceLoader.fetchOnline("https://github.com/tom5454/CustomPlayerModels/wiki/images/" + url.substring(url.lastIndexOf(47) + 1));
        }
        if (url.startsWith("https://github.com/tom5454/CustomPlayerModels/wiki/")) {
            return MdResourceLoader.fetch(url + ".md", offline);
        }
        CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
        f.completeExceptionally(new IOException("Unknown url: " + url));
        return f;
    }

    private static CompletableFuture<byte[]> fetchOnline(String url) {
        return ((CompletableFuture)MdResourceIO.fetch0(url).handle((d, e) -> {
            if (d != null && e == null) {
                return CompletableFuture.completedFuture(d);
            }
            Log.warn("Failed to load page, loading local backup", e);
            return ((CompletableFuture)MdResourceLoader.fetch(url, true).handle((a, e2) -> {
                if (a != null && e2 == null) {
                    return CompletableFuture.completedFuture(a);
                }
                CompletableFuture cf = new CompletableFuture();
                e2.addSuppressed((Throwable)e);
                cf.completeExceptionally((Throwable)e2);
                return cf;
            })).thenCompose(Function.identity());
        })).thenCompose(Function.identity());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CompletableFuture<byte[]> asset0(String path) {
        try (InputStream is = MdResourceLoader.class.getResourceAsStream(path);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOHelper.copy(is, baos);
            CompletableFuture<byte[]> completableFuture = CompletableFuture.completedFuture(baos.toByteArray());
            return completableFuture;
        }
        catch (IOException e) {
            CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
            f.completeExceptionally(e);
            return f;
        }
    }
}

