/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Objects;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.config.screens.ETFConfigScreenBlinkSettings;
import traben.entity_texture_features.config.screens.ETFConfigScreenEmissiveSettings;
import traben.entity_texture_features.config.screens.ETFConfigScreenGeneralSettings;
import traben.entity_texture_features.config.screens.ETFConfigScreenRandomSettings;
import traben.entity_texture_features.config.screens.ETFConfigScreenSkinSettings;
import traben.entity_texture_features.config.screens.ETFConfigScreenWarnings;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenMain
extends ETFConfigScreen {
    static ETFConfig temporaryETFConfig = null;
    final ObjectOpenHashSet<ETFConfigScreenWarnings.ConfigWarning> warningsFound = new ObjectOpenHashSet();
    ETFConfigScreenWarnings warningsScreen;
    final ETFConfigScreenSkinSettings playerSkinSettingsScreen = new ETFConfigScreenSkinSettings(this);
    final ETFConfigScreenRandomSettings randomSettingsScreen = new ETFConfigScreenRandomSettings(this);
    final ETFConfigScreenEmissiveSettings emissiveSettingsScreen = new ETFConfigScreenEmissiveSettings(this);
    final ETFConfigScreenBlinkSettings blinkSettingsScreen = new ETFConfigScreenBlinkSettings(this);
    final ETFConfigScreenGeneralSettings generalSettingsScreen = new ETFConfigScreenGeneralSettings(this);
    boolean shownWarning = false;
    int warningCount = 0;

    public ETFConfigScreenMain(Screen parent) {
        super(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.title"), parent);
        temporaryETFConfig = ETFConfig.copyFrom(ETFClientCommon.ETFConfigData);
        this.findWarnings();
    }

    public ETFConfigScreenMain(Screen parent, ETFConfig newTemp) {
        super(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.title"), parent);
        temporaryETFConfig = newTemp;
        this.findWarnings();
    }

    private void findWarnings() {
        if (ETFClientCommon.configHadLoadError) {
            this.shownWarning = true;
            ++this.warningCount;
        }
        for (ETFConfigScreenWarnings.ConfigWarning warning : ETFConfigScreenWarnings.ConfigWarning.values()) {
            if (!ETFVersionDifferenceHandler.isThisModLoaded(warning.getMod_id())) continue;
            this.shownWarning = true;
            ++this.warningCount;
            this.warningsFound.add((Object)warning);
        }
        this.warningsScreen = new ETFConfigScreenWarnings(this, this.warningsFound);
    }

    @Override
    public void func_231175_as__() {
        ETFManager.resetInstance();
        super.func_231175_as__();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.shownWarning) {
            this.func_230480_a_((Widget)new Button((int)((double)this.field_230708_k_ * 0.1), (int)((double)this.field_230709_l_ * 0.1) - 15, (int)((double)this.field_230708_k_ * 0.2), 20, ITextComponent.func_244388_a((String)""), button -> Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)this.warningsScreen)));
        }
        this.func_230480_a_((Widget)new Button((int)((double)this.field_230708_k_ * 0.7), (int)((double)this.field_230709_l_ * 0.9), (int)((double)this.field_230708_k_ * 0.2), 20, ETFVersionDifferenceHandler.getTextFromTranslation("gui.done"), button -> {
            ETFClientCommon.ETFConfigData = temporaryETFConfig;
            ETFUtils2.saveConfig();
            ETFUtils2.checkModCompatibility();
            ETFManager.resetInstance();
            ETFClientCommon.configHadLoadError = false;
            Objects.requireNonNull(this.field_230706_i_).func_147108_a(this.parent);
        }));
        this.func_230480_a_((Widget)new Button((int)((double)this.field_230708_k_ * 0.4), (int)((double)this.field_230709_l_ * 0.9), (int)((double)this.field_230708_k_ * 0.2), 20, ETFVersionDifferenceHandler.getTextFromTranslation("dataPack.validation.reset"), button -> {
            Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)new ETFConfigScreenMain(this.parent, new ETFConfig()));
            this.func_231164_f_();
        }));
        this.func_230480_a_((Widget)new Button((int)((double)this.field_230708_k_ * 0.1), (int)((double)this.field_230709_l_ * 0.9), (int)((double)this.field_230708_k_ * 0.2), 20, DialogTexts.field_240633_d_, button -> {
            temporaryETFConfig = null;
            Objects.requireNonNull(this.field_230706_i_).func_147108_a(this.parent);
        }));
        this.func_230480_a_((Widget)new Button((int)((double)this.field_230708_k_ * 0.3) + 75, (int)((double)this.field_230709_l_ * 0.5) + 17, 165, 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.blinking_mob_settings_sub.title"), button -> Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)this.blinkSettingsScreen)));
        this.func_230480_a_((Widget)new Button((int)((double)this.field_230708_k_ * 0.3) + 75, (int)((double)this.field_230709_l_ * 0.5) - 10, 165, 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_settings.title"), button -> Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)this.playerSkinSettingsScreen)));
        this.func_230480_a_((Widget)new Button((int)((double)this.field_230708_k_ * 0.3) + 75, (int)((double)this.field_230709_l_ * 0.5) - 64, 165, 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.random_settings.title"), button -> Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)this.randomSettingsScreen)));
        this.func_230480_a_((Widget)new Button((int)((double)this.field_230708_k_ * 0.3) + 75, (int)((double)this.field_230709_l_ * 0.5) - 37, 165, 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.emissive_settings.title"), button -> Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)this.emissiveSettingsScreen)));
        this.func_230480_a_((Widget)new Button((int)((double)this.field_230708_k_ * 0.3) + 75, (int)((double)this.field_230709_l_ * 0.5) + 44, 165, 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.general_settings.title"), button -> Objects.requireNonNull(this.field_230706_i_).func_147108_a((Screen)this.generalSettingsScreen)));
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        ETFConfigScreenMain.renderGUITexture(new ResourceLocation("entity_texture_features:textures/gui/icon.png"), (double)this.field_230708_k_ * 0.3 - 64.0, (double)this.field_230709_l_ * 0.5 - 64.0, (double)this.field_230708_k_ * 0.3 + 64.0, (double)this.field_230709_l_ * 0.5 + 64.0);
        if (this.shownWarning) {
            ETFConfigScreenMain.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)ITextComponent.func_244388_a((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.warnings_main").getString() + this.warningCount)), (int)((int)((double)this.field_230708_k_ * 0.2)), (int)((int)((double)this.field_230709_l_ * 0.1) - 9), (int)11546150);
        }
    }
}

