/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.mixin.accessor.PlayerSkinProviderAccessor;
import traben.entity_texture_features.mixin.accessor.PlayerSkinTextureAccessor;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolOutcome
extends ETFConfigScreen {
    private final boolean didSucceed;
    private final NativeImage skin;

    protected ETFConfigScreenSkinToolOutcome(Screen parent, boolean success, NativeImage skin) {
        super(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result"), parent);
        this.didSucceed = success;
        this.skin = skin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean uploadSkin(boolean skinType) {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            if ("127.0.0.1".equals(InetAddress.getLocalHost().getHostAddress())) {
                boolean bl2 = false;
                return bl2;
            }
            String auth = Minecraft.func_71410_x().func_110432_I().func_148254_d();
            HttpPost http = new HttpPost("https://api.minecraftservices.com/minecraft/profile/skins");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("variant", skinType ? "classic" : "slim", ContentType.TEXT_PLAIN);
            assert (ETFClientCommon.CONFIG_DIR != null);
            builder.addBinaryBody("file", Files.newInputStream(new File(ETFClientCommon.CONFIG_DIR.getParent(), "\\ETF_player_skin_printout.png").toPath(), new OpenOption[0]), ContentType.IMAGE_PNG, "skin.png");
            http.setEntity(builder.build());
            http.addHeader("Authorization", "Bearer " + auth);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)http);
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)this.getETFButton((int)((double)this.field_230708_k_ * 0.55), (int)((double)this.field_230709_l_ * 0.9), (int)((double)this.field_230708_k_ * 0.2), 20, DialogTexts.field_240632_c_, button -> Objects.requireNonNull(this.field_230706_i_).func_147108_a(this.parent)));
        if (this.didSucceed) {
            this.func_230480_a_((Widget)this.getETFButton((int)((double)this.field_230708_k_ * 0.15), (int)((double)this.field_230709_l_ * 0.6), (int)((double)this.field_230708_k_ * 0.7), 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.open"), button -> {
                try {
                    File outputDirectory = new File(ETFClientCommon.CONFIG_DIR.getParent());
                    Util.func_110647_a().func_195641_a(outputDirectory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            this.func_230480_a_((Widget)this.getETFButton((int)((double)this.field_230708_k_ * 0.15), (int)((double)this.field_230709_l_ * 0.4), (int)((double)this.field_230708_k_ * 0.7), 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin"), button -> {
                String skinTypeData;
                NetworkPlayerInfo playerListEntry;
                boolean skinType = true;
                if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().func_147114_u() != null && (playerListEntry = Minecraft.func_71410_x().func_147114_u().func_175102_a(Minecraft.func_71410_x().field_71439_g.func_110124_au())) != null && (skinTypeData = ((MinecraftProfileTexture)Minecraft.func_71410_x().func_152342_ad().func_152788_a(playerListEntry.func_178845_a()).get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model")) != null) {
                    skinType = !"slim".equals(skinTypeData);
                }
                boolean changeSuccess = ETFConfigScreenSkinToolOutcome.uploadSkin(skinType);
                button.func_238482_a_(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin_v2." + (changeSuccess ? "success" : "fail")));
                if (changeSuccess) {
                    DownloadingTexture skinfile = (DownloadingTexture)((PlayerSkinProviderAccessor)Minecraft.func_71410_x().func_152342_ad()).getTextureManager().func_229267_b_(Minecraft.func_71410_x().field_71439_g.func_110306_p());
                    try {
                        this.skin.func_209271_a(((PlayerSkinTextureAccessor)skinfile).getCacheFile());
                    }
                    catch (IOException e) {
                        ETFUtils2.logError(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin.success_local_fail").getString(), true);
                    }
                    if (Minecraft.func_71410_x().field_71439_g != null) {
                        ETFManager.getInstance().PLAYER_TEXTURE_MAP.removeEntryOnly(Minecraft.func_71410_x().field_71439_g.func_110124_au());
                        ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)Minecraft.func_71410_x().field_71439_g.func_110124_au(), 0L);
                    }
                }
                button.field_230693_o_ = false;
            }));
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        String[] strings = ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result." + (this.didSucceed ? "success" : "fail")).getString().split("\n");
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
        for (String str : strings) {
            lines.add(ITextComponent.func_244388_a((String)str.trim()));
        }
        int i = 0;
        for (ITextComponent txt : lines) {
            ETFConfigScreenSkinToolOutcome.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)txt, (int)((int)((double)this.field_230708_k_ * 0.5)), (int)((int)((double)this.field_230709_l_ * 0.3) + i), (int)0xFFFFFF);
            i += txt.getString().isEmpty() ? 5 : 10;
        }
    }
}

