/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.forge.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFTexture;

@Mixin(value={BipedArmorLayer.class})
public abstract class MixinArmorFeatureRenderer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private ETFTexture thisETFTexture = null;

    public MixinArmorFeatureRenderer(IEntityRenderer<T, M> context) {
        super(context);
    }

    @ModifyArg(method={"renderModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/RenderLayer;getArmorCutoutNoCull(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"))
    private ResourceLocation etf$changeTexture(ResourceLocation texture) {
        this.thisETFTexture = ETFManager.getInstance().getETFTexture(texture, null, ETFManager.TextureSource.ENTITY_FEATURE, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveArmour);
        if (this.thisETFTexture != null) {
            return this.thisETFTexture.getTextureIdentifier(null, ETFClientCommon.ETFConfigData.enableEmissiveTextures);
        }
        return texture;
    }

    @Inject(method={"renderModel"}, at={@At(value="TAIL")})
    private void etf$applyEmissive(MatrixStack arg, IRenderTypeBuffer arg2, int i, boolean bl, A arg3, float f, float g, float h, ResourceLocation armorResource, CallbackInfo ci) {
        ResourceLocation emissive;
        if (this.thisETFTexture != null && ETFClientCommon.ETFConfigData.enableEmissiveTextures && (emissive = this.thisETFTexture.getEmissiveIdentifierOfCurrentState()) != null) {
            IVertexBuilder textureVert = arg2.getBuffer(RenderType.func_239263_a_((ResourceLocation)emissive));
            arg3.func_225598_a_(arg, textureVert, 0xF000F0, OverlayTexture.field_229196_a_, f, g, h, 1.0f);
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void etf$cancelIfUi(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71462_r instanceof ETFConfigScreen) {
            ci.cancel();
        }
    }
}

