/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.block_entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.UUID;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.mixin.accessor.SpriteAccessor;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFPlaceholderEntity;

@Mixin(value={ChestTileEntityRenderer.class})
public abstract class MixinChestBlockEntityRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private ETFTexture thisETFTexture = null;
    private boolean isAnimatedTexture = false;
    private ETFPlaceholderEntity etf$chestStandInDummy = null;
    private ResourceLocation etf$textureOfThis = null;
    private IRenderTypeBuffer etf$vertexConsumerProviderOfThis = null;

    public MixinChestBlockEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @ModifyArg(method={"render(Lnet/minecraft/block/entity/BlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/block/entity/ChestBlockEntityRenderer;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;Lnet/minecraft/client/model/ModelPart;Lnet/minecraft/client/model/ModelPart;Lnet/minecraft/client/model/ModelPart;FII)V"), index=1)
    private IVertexBuilder etf$alterTexture(IVertexBuilder vertices) {
        try {
            if (this.isAnimatedTexture || !ETFClientCommon.ETFConfigData.enableCustomTextures || !ETFClientCommon.ETFConfigData.enableCustomBlockEntities) {
                return vertices;
            }
            this.thisETFTexture = ETFManager.getInstance().getETFTexture(this.etf$textureOfThis, this.etf$chestStandInDummy, ETFManager.TextureSource.BLOCK_ENTITY, false);
            IVertexBuilder alteredReturn = this.etf$vertexConsumerProviderOfThis.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.thisETFTexture.getTextureIdentifier(this.etf$chestStandInDummy)));
            return alteredReturn == null ? vertices : alteredReturn;
        }
        catch (Exception e) {
            return vertices;
        }
    }

    @Inject(method={"render(Lnet/minecraft/block/entity/BlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/SpriteIdentifier;getVertexConsumer(Lnet/minecraft/client/render/VertexConsumerProvider;Ljava/util/function/Function;)Lnet/minecraft/client/render/VertexConsumer;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void etf$getChestTexture(T entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay, CallbackInfo ci, World world, boolean bl, BlockState blockState, ChestType chestType, Block block, AbstractChestBlock<?> abstractChestBlock, boolean bl2, float f, TileEntityMerger.ICallbackWrapper<?> propertySource, float g, int i, RenderMaterial spriteIdentifier) {
        try {
            boolean bl3 = this.isAnimatedTexture = ((SpriteAccessor)spriteIdentifier.func_229314_c_()).callGetFrameCount() != 1;
            if (!this.isAnimatedTexture) {
                String nameSpace = spriteIdentifier.func_229313_b_().func_110624_b();
                String texturePath = "textures/" + spriteIdentifier.func_229313_b_().func_110623_a() + ".png";
                this.etf$textureOfThis = new ResourceLocation(nameSpace, texturePath);
                this.etf$vertexConsumerProviderOfThis = vertexConsumers;
                if (ETFClientCommon.ETFConfigData.enableCustomTextures && ETFClientCommon.ETFConfigData.enableCustomBlockEntities) {
                    World worldCheck;
                    INameable nameable;
                    String identifier = "chest" + entity.func_174877_v().toString() + chestType.func_176610_l();
                    if (entity instanceof INameable && (nameable = (INameable)entity).func_145818_k_()) {
                        identifier = identifier + nameable.func_200201_e().getString();
                    }
                    if ((worldCheck = entity.func_145831_w()) == null) {
                        worldCheck = Minecraft.func_71410_x().field_71441_e;
                    }
                    if (worldCheck != null) {
                        this.etf$chestStandInDummy = ETFPlaceholderEntity.newFromJustWorld(worldCheck);
                        this.etf$chestStandInDummy.prepare((TileEntity)entity, UUID.nameUUIDFromBytes(identifier.getBytes()));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;Lnet/minecraft/client/model/ModelPart;Lnet/minecraft/client/model/ModelPart;Lnet/minecraft/client/model/ModelPart;FII)V"}, at={@At(value="TAIL")})
    private void etf$renderEmissiveChest(MatrixStack matrices, IVertexBuilder vertices, ModelRenderer lid, ModelRenderer latch, ModelRenderer base, float openFactor, int light, int overlay, CallbackInfo ci) {
        try {
            if (!this.isAnimatedTexture && ETFClientCommon.ETFConfigData.enableEmissiveBlockEntities && this.thisETFTexture != null) {
                this.thisETFTexture.renderEmissive(matrices, this.etf$vertexConsumerProviderOfThis, lid, ETFManager.EmissiveRenderModes.blockEntityMode());
                this.thisETFTexture.renderEmissive(matrices, this.etf$vertexConsumerProviderOfThis, latch, ETFManager.EmissiveRenderModes.blockEntityMode());
                this.thisETFTexture.renderEmissive(matrices, this.etf$vertexConsumerProviderOfThis, base, ETFManager.EmissiveRenderModes.blockEntityMode());
                this.etf$textureOfThis = null;
                this.etf$vertexConsumerProviderOfThis = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

