/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.misc;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFPlayerTexture;

@Mixin(value={AbstractClientPlayerEntity.class})
public abstract class MixinAbstractClientPlayerEntity
extends PlayerEntity {
    public MixinAbstractClientPlayerEntity(World world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Shadow
    public abstract ResourceLocation func_110306_p();

    @Inject(method={"getCapeTexture"}, at={@At(value="RETURN")}, cancellable=true)
    private void changeCapeReturnsToNotNull(CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation cape = (ResourceLocation)cir.getReturnValue();
        if (cape != null && cape.toString().contains("/cit/")) {
            return;
        }
        ETFPlayerTexture textureData = ETFManager.getInstance().getPlayerTexture(this, this.func_110306_p());
        if (textureData != null && textureData.hasCustomCape()) {
            cir.setReturnValue((Object)textureData.etfCapeIdentifier);
        }
        if (this.func_110124_au().equals(ETFPlayerTexture.Dev)) {
            cir.setReturnValue((Object)new ResourceLocation("entity_texture_features", "textures/capes/dev.png"));
        }
        if (this.func_110124_au().equals(ETFPlayerTexture.Wife)) {
            cir.setReturnValue((Object)new ResourceLocation("entity_texture_features", "textures/capes/wife.png"));
        }
    }

    @Inject(method={"canRenderCapeTexture"}, at={@At(value="RETURN")}, cancellable=true)
    private void changeCapeReturnsBoolean(CallbackInfoReturnable<Boolean> cir) {
        ETFPlayerTexture textureData = ETFManager.getInstance().getPlayerTexture(this, this.func_110306_p());
        if (textureData != null && textureData.hasCustomCape() || this.func_110124_au().equals(ETFPlayerTexture.Dev) || this.func_110124_au().equals(ETFPlayerTexture.Wife)) {
            cir.setReturnValue((Object)true);
        }
    }
}

