/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.mod_compat.ETF3DSkinLayersUtil;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFPlayerTexture;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

@Mixin(value={LivingRenderer.class})
public abstract class MixinLivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements IEntityRenderer<T, M> {
    private ETFTexture thisETFTexture = null;
    private ETFPlayerTexture thisETFPlayerTexture = null;

    protected MixinLivingEntityRenderer(EntityRendererManager dispatcher) {
        super(dispatcher);
    }

    @Shadow
    public abstract M func_217764_d();

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;IIFFFF)V", shift=At.Shift.AFTER)})
    private void etf$applyRenderFeatures(T livingEntity, float a, float g, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i, CallbackInfo ci) {
        if (livingEntity instanceof PlayerEntity) {
            if (ETFClientCommon.ETFConfigData.skinFeaturesEnabled && this.thisETFPlayerTexture != null) {
                this.thisETFPlayerTexture.renderFeatures(matrixStack, vertexConsumerProvider, i, (PlayerModel<PlayerEntity>)((PlayerModel)this.func_217764_d()));
            }
        } else if (this.thisETFTexture != null) {
            this.thisETFTexture.renderEmissive(matrixStack, vertexConsumerProvider, (Model)this.func_217764_d());
        }
    }

    @Redirect(method={"getRenderLayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/LivingEntityRenderer;getTexture(Lnet/minecraft/entity/Entity;)Lnet/minecraft/util/Identifier;"))
    private ResourceLocation etf$alterTexture(LivingRenderer<T, M> instance, Entity inEntity) {
        LivingEntity entity = (LivingEntity)inEntity;
        if (entity instanceof PlayerEntity) {
            ResourceLocation vanillaTexture;
            PlayerEntity player = (PlayerEntity)entity;
            if (ETFClientCommon.ETFConfigData.skinFeaturesEnabled) {
                this.thisETFPlayerTexture = ETFManager.getInstance().getPlayerTexture(player, ((AbstractClientPlayerEntity)player).func_110306_p());
                if (this.thisETFPlayerTexture != null) {
                    ResourceLocation etfTexture = this.thisETFPlayerTexture.getBaseTextureIdentifierOrNullForVanilla(player);
                    return etfTexture == null ? this.func_110775_a((Entity)entity) : etfTexture;
                }
            }
            if (!("minecraft:texture/entity/steve.png".equals((vanillaTexture = this.func_110775_a((Entity)entity)).toString()) || "minecraft:texture/entity/alex.png".equals(vanillaTexture.toString()) || vanillaTexture.toString().contains("minecraft:texture/entity/player/"))) {
                return vanillaTexture;
            }
        }
        this.thisETFTexture = ETFManager.getInstance().getETFTexture(this.func_110775_a((Entity)entity), entity, ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        return this.thisETFTexture.getTextureIdentifier((Entity)entity);
    }

    @Inject(method={"Lnet/minecraft/client/render/entity/LivingEntityRenderer;getRenderLayer(Lnet/minecraft/entity/LivingEntity;ZZZ)Lnet/minecraft/client/render/RenderLayer;"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void etf$renderLayerAlter(T entity, boolean showBody, boolean translucent, boolean showOutline, CallbackInfoReturnable<RenderType> cir, ResourceLocation identifier) {
        if (!translucent && showBody && ETFManager.getInstance().ENTITY_TYPE_RENDER_LAYER.containsKey((Object)entity.func_200600_R())) {
            int choice = ETFManager.getInstance().ENTITY_TYPE_RENDER_LAYER.getInt((Object)entity.func_200600_R());
            switch (choice) {
                case 1: {
                    cir.setReturnValue((Object)RenderType.func_228644_e_((ResourceLocation)identifier));
                    break;
                }
                case 2: {
                    cir.setReturnValue((Object)RenderType.func_228642_d_((ResourceLocation)identifier));
                    break;
                }
                case 3: {
                    cir.setReturnValue((Object)RenderType.func_228630_a_((int)0));
                    break;
                }
                case 4: {
                    cir.setReturnValue((Object)RenderType.func_228654_j_((ResourceLocation)identifier));
                    break;
                }
                default: {
                    cir.setReturnValue((Object)((RenderType)cir.getReturnValue()));
                    break;
                }
            }
        } else {
            cir.setReturnValue((Object)((RenderType)cir.getReturnValue()));
        }
    }

    @ModifyArg(method={"addFeature"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), index=0)
    private Object etf$3dSkinLayerCompat(Object featureRenderer) {
        if (ETFVersionDifferenceHandler.isThisModLoaded("skinlayers") || ETFVersionDifferenceHandler.isThisModLoaded("skinlayers3d")) {
            try {
                if (ETF3DSkinLayersUtil.canReplace((LayerRenderer)featureRenderer)) {
                    return ETF3DSkinLayersUtil.getReplacement((LayerRenderer)featureRenderer, this);
                }
            }
            catch (Exception e) {
                ETFUtils2.logWarn("Exception with ETF's 3D skin layers mod compatibility: " + e);
            }
            catch (NoClassDefFoundError error) {
                ETFUtils2.logError("Error with ETF's 3D skin layers mod compatibility: " + error);
            }
        }
        return featureRenderer;
    }
}

