/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_handlers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFTexture {
    private static final String PATCH_NAMESPACE_PREFIX = "etf_patched_";
    private static final Random randomBlink = new Random();
    public final ResourceLocation thisIdentifier;
    private final Object2ReferenceOpenHashMap<ResourceLocation, ResourceLocation> FEATURE_TEXTURE_MAP = new Object2ReferenceOpenHashMap();
    private final int variantNumber;
    public TextureReturnState currentTextureState = TextureReturnState.NORMAL;
    private ResourceLocation thisIdentifier_Patched = null;
    private ResourceLocation emissiveIdentifier = null;
    private ResourceLocation emissiveBlinkIdentifier = null;
    private ResourceLocation emissiveBlink2Identifier = null;
    private ResourceLocation blinkIdentifier = null;
    private ResourceLocation blink2Identifier = null;
    private ResourceLocation blinkIdentifier_Patched = null;
    private ResourceLocation blink2Identifier_Patched = null;
    private Integer blinkLength;
    private Integer blinkFrequency;
    private boolean canPatch;

    public ETFTexture(@NotNull ResourceLocation variantIdentifier, boolean allowedToPatch) {
        this.blinkLength = ETFClientCommon.ETFConfigData.blinkLength;
        this.blinkFrequency = ETFClientCommon.ETFConfigData.blinkFrequency;
        this.canPatch = true;
        this.thisIdentifier = variantIdentifier;
        Pattern pattern = Pattern.compile("\\d+(?=\\.png)");
        Matcher matcher = pattern.matcher(variantIdentifier.func_110623_a());
        this.variantNumber = matcher.find() ? Integer.parseInt(matcher.group()) : 0;
        this.canPatch = allowedToPatch;
        this.setupBlinking();
        this.setupEmissives();
    }

    public ETFTexture(@NotNull ResourceLocation modifiedSkinIdentifier, @Nullable ResourceLocation blinkIdentifier, @Nullable ResourceLocation blink2Identifier, @Nullable ResourceLocation emissiveIdentifier, @Nullable ResourceLocation blinkEmissiveIdentifier, @Nullable ResourceLocation blink2EmissiveIdentifier, @Nullable ResourceLocation modifiedSkinPatchedIdentifier, @Nullable ResourceLocation modifiedSkinBlinkPatchedIdentifier, @Nullable ResourceLocation modifiedSkinBlink2PatchedIdentifier) {
        this.blinkLength = ETFClientCommon.ETFConfigData.blinkLength;
        this.blinkFrequency = ETFClientCommon.ETFConfigData.blinkFrequency;
        this.canPatch = true;
        this.variantNumber = 0;
        this.thisIdentifier = modifiedSkinIdentifier;
        this.blinkIdentifier = blinkIdentifier;
        this.blink2Identifier = blink2Identifier;
        this.emissiveIdentifier = emissiveIdentifier;
        this.emissiveBlinkIdentifier = blinkEmissiveIdentifier;
        this.emissiveBlink2Identifier = blink2EmissiveIdentifier;
        this.thisIdentifier_Patched = modifiedSkinPatchedIdentifier;
        this.blinkIdentifier_Patched = modifiedSkinBlinkPatchedIdentifier;
        this.blink2Identifier_Patched = modifiedSkinBlink2PatchedIdentifier;
    }

    public ETFTexture(@NotNull ResourceLocation modifiedSkinIdentifier, @Nullable ResourceLocation emissiveIdentifier) {
        this.blinkLength = ETFClientCommon.ETFConfigData.blinkLength;
        this.blinkFrequency = ETFClientCommon.ETFConfigData.blinkFrequency;
        this.canPatch = true;
        this.variantNumber = 0;
        this.thisIdentifier = modifiedSkinIdentifier;
        this.emissiveIdentifier = emissiveIdentifier;
    }

    public static void patchTextureToRemoveZFightingWithOtherTexture(NativeImage baseImage, NativeImage otherImage) throws IndexOutOfBoundsException {
        try {
            if (otherImage.func_195702_a() == baseImage.func_195702_a() && otherImage.func_195714_b() == baseImage.func_195714_b()) {
                for (int x = 0; x < baseImage.func_195702_a(); ++x) {
                    for (int y = 0; y < baseImage.func_195714_b(); ++y) {
                        if (otherImage.func_211675_e(x, y) == 0) continue;
                        baseImage.func_195700_a(x, y, 0);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IndexOutOfBoundsException("additional texture is not the correct size, ETF has crashed in the patching stage");
        }
    }

    private void setupBlinking() {
        try {
            if (ETFClientCommon.ETFConfigData.enableBlinking) {
                IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
                if (ETFUtils2.isExistingResource(this.thisIdentifier)) {
                    String blink1PackName;
                    IResource vanillaR1 = resourceManager.func_199002_a(this.thisIdentifier);
                    ResourceLocation possibleBlinkIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink.png");
                    if (ETFUtils2.isExistingResource(possibleBlinkIdentifier) && (blink1PackName = resourceManager.func_199002_a(possibleBlinkIdentifier).func_199026_d()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{blink1PackName, vanillaR1.func_199026_d()}))) {
                        String propertyResourcePackName;
                        ResourceLocation propertyIdentifier;
                        Properties blinkingProps;
                        String blink2PackName;
                        this.blinkIdentifier = possibleBlinkIdentifier;
                        ResourceLocation possibleBlink2Identifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink2.png");
                        if (ETFUtils2.isExistingResource(possibleBlink2Identifier) && blink1PackName.equals(blink2PackName = resourceManager.func_199002_a(possibleBlink2Identifier).func_199026_d())) {
                            this.blink2Identifier = possibleBlink2Identifier;
                        }
                        if ((blinkingProps = ETFUtils2.readAndReturnPropertiesElseNull(propertyIdentifier = ETFUtils2.replaceIdentifier(possibleBlinkIdentifier, ".png", ".properties"))) != null && ETFUtils2.isExistingResource(propertyIdentifier) && (propertyResourcePackName = resourceManager.func_199002_a(propertyIdentifier).func_199026_d()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{propertyResourcePackName, blink1PackName}))) {
                            this.blinkLength = blinkingProps.containsKey("blinkLength") ? Integer.parseInt(blinkingProps.getProperty("blinkLength").replaceAll("\\D", "")) : ETFClientCommon.ETFConfigData.blinkLength;
                            this.blinkFrequency = blinkingProps.containsKey("blinkFrequency") ? Integer.parseInt(blinkingProps.getProperty("blinkFrequency").replaceAll("\\D", "")) : ETFClientCommon.ETFConfigData.blinkFrequency;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupEmissives() {
        if (ETFClientCommon.ETFConfigData.enableEmissiveTextures) {
            IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
            try {
                for (String possibleEmissiveSuffix : ETFManager.getInstance().EMISSIVE_SUFFIX_LIST) {
                    if (!ETFUtils2.isExistingResource(this.thisIdentifier)) continue;
                    IResource vanillaR1 = resourceManager.func_199002_a(this.thisIdentifier);
                    ResourceLocation possibleEmissiveIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", possibleEmissiveSuffix + ".png");
                    if (!ETFUtils2.isExistingResource(possibleEmissiveIdentifier)) continue;
                    String emissivePackName = resourceManager.func_199002_a(possibleEmissiveIdentifier).func_199026_d();
                    if (!emissivePackName.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{emissivePackName, vanillaR1.func_199026_d()}))) continue;
                    this.emissiveIdentifier = possibleEmissiveIdentifier;
                    ResourceLocation possibleEmissiveBlinkIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink" + possibleEmissiveSuffix + ".png");
                    if (ETFUtils2.isExistingResource(possibleEmissiveBlinkIdentifier)) {
                        String emissiveBlinkPackName = resourceManager.func_199002_a(possibleEmissiveBlinkIdentifier).func_199026_d();
                        if (emissiveBlinkPackName.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{emissiveBlinkPackName, vanillaR1.func_199026_d()}))) {
                            this.emissiveBlinkIdentifier = possibleEmissiveBlinkIdentifier;
                            ResourceLocation possibleEmissiveBlink2Identifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink2" + possibleEmissiveSuffix + ".png");
                            if (ETFUtils2.isExistingResource(possibleEmissiveBlink2Identifier)) {
                                String emissiveBlink2PackName = resourceManager.func_199002_a(possibleEmissiveBlink2Identifier).func_199026_d();
                                if (emissiveBlink2PackName.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{emissiveBlink2PackName, vanillaR1.func_199026_d()}))) {
                                    this.emissiveBlink2Identifier = possibleEmissiveBlink2Identifier;
                                }
                            }
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isEmissive()) {
                this.createPatchedTextures();
            }
        }
    }

    private void createPatchedTextures() {
        if (this.canPatch && ETFVersionDifferenceHandler.isFabric()) {
            return;
        }
        NativeImage newBaseTexture = ETFUtils2.getNativeImageElseNull(this.thisIdentifier);
        NativeImage newBlinkTexture = ETFUtils2.getNativeImageElseNull(this.blinkIdentifier);
        NativeImage newBlink2Texture = ETFUtils2.getNativeImageElseNull(this.blink2Identifier);
        boolean didPatch = false;
        if (ETFClientCommon.ETFConfigData.dontPatchPBRTextures && (ETFVersionDifferenceHandler.isThisModLoaded("iris") || ETFVersionDifferenceHandler.isThisModLoaded("oculus")) && (ETFUtils2.isExistingResource(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_s.png")) || ETFUtils2.isExistingResource(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_n.png")))) {
            return;
        }
        if (ETFClientCommon.ETFConfigData.dontPatchAnimatedTextures && ETFVersionDifferenceHandler.isThisModLoaded("moremcmeta") && (ETFUtils2.isExistingResource(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", ".png.mcmeta")) || ETFUtils2.isExistingResource(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", ".png.moremcmeta")))) {
            return;
        }
        if (this.emissiveIdentifier != null && ETFClientCommon.ETFConfigData.enableEmissiveTextures) {
            NativeImage emissiveImage = ETFUtils2.getNativeImageElseNull(this.emissiveIdentifier);
            try {
                ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBaseTexture, emissiveImage);
                didPatch = true;
                if (this.doesBlink() && this.emissiveBlinkIdentifier != null) {
                    NativeImage emissiveBlinkImage = ETFUtils2.getNativeImageElseNull(this.emissiveBlinkIdentifier);
                    ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBlinkTexture, emissiveBlinkImage);
                    if (this.doesBlink2() && this.emissiveBlink2Identifier != null) {
                        NativeImage emissiveBlink2Image = ETFUtils2.getNativeImageElseNull(this.emissiveBlink2Identifier);
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBlink2Texture, emissiveBlink2Image);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (didPatch) {
                this.thisIdentifier_Patched = new ResourceLocation(PATCH_NAMESPACE_PREFIX + this.thisIdentifier.func_110624_b(), this.thisIdentifier.func_110623_a());
                ETFUtils2.registerNativeImageToIdentifier(newBaseTexture, this.thisIdentifier_Patched);
                if (this.doesBlink()) {
                    this.blinkIdentifier_Patched = new ResourceLocation(PATCH_NAMESPACE_PREFIX + this.blinkIdentifier.func_110624_b(), this.blinkIdentifier.func_110623_a());
                    ETFUtils2.registerNativeImageToIdentifier(newBlinkTexture, this.blinkIdentifier_Patched);
                    if (this.doesBlink2()) {
                        this.blink2Identifier_Patched = new ResourceLocation(PATCH_NAMESPACE_PREFIX + this.blink2Identifier.func_110624_b(), this.blink2Identifier.func_110623_a());
                        ETFUtils2.registerNativeImageToIdentifier(newBlink2Texture, this.blink2Identifier_Patched);
                    }
                }
            }
        }
    }

    @NotNull
    ResourceLocation getFeatureTexture(ResourceLocation vanillaFeatureTexture) {
        ResourceLocation possibleFeatureVariantIdentifier;
        if (this.FEATURE_TEXTURE_MAP.containsKey((Object)vanillaFeatureTexture)) {
            return (ResourceLocation)this.FEATURE_TEXTURE_MAP.get((Object)vanillaFeatureTexture);
        }
        ETFDirectory directory = ETFDirectory.getDirectoryOf(this.thisIdentifier);
        if (this.variantNumber != 0 && ETFUtils2.isExistingResource(possibleFeatureVariantIdentifier = ETFDirectory.getIdentifierAsDirectory(ETFUtils2.replaceIdentifier(vanillaFeatureTexture, ".png", this.variantNumber + ".png"), directory))) {
            this.FEATURE_TEXTURE_MAP.put((Object)vanillaFeatureTexture, (Object)possibleFeatureVariantIdentifier);
            return possibleFeatureVariantIdentifier;
        }
        ETFDirectory tryDirectory = ETFDirectory.getDirectoryOf(vanillaFeatureTexture);
        if (tryDirectory == directory || tryDirectory == ETFDirectory.VANILLA) {
            ResourceLocation tryDirectoryVariant = ETFDirectory.getIdentifierAsDirectory(vanillaFeatureTexture, tryDirectory);
            this.FEATURE_TEXTURE_MAP.put((Object)vanillaFeatureTexture, (Object)tryDirectoryVariant);
            return tryDirectoryVariant;
        }
        this.FEATURE_TEXTURE_MAP.put((Object)vanillaFeatureTexture, (Object)vanillaFeatureTexture);
        return vanillaFeatureTexture;
    }

    @NotNull
    public ResourceLocation getTextureIdentifier(Entity entity) {
        return this.getTextureIdentifier(entity, false);
    }

    @NotNull
    public ResourceLocation getTextureIdentifier(@Nullable Entity entity, boolean forcePatchedTexture) {
        if (this.isPatched() && (forcePatchedTexture || ETFClientCommon.ETFConfigData.enableEmissiveTextures && ETFVersionDifferenceHandler.areShadersInUse() || Minecraft.func_71410_x().field_71462_r instanceof ETFConfigScreen)) {
            this.currentTextureState = TextureReturnState.NORMAL_PATCHED;
            return this.getBlinkingIdentifier(entity);
        }
        this.currentTextureState = TextureReturnState.NORMAL;
        return this.getBlinkingIdentifier(entity);
    }

    @NotNull
    private ResourceLocation getBlinkingIdentifier(@Nullable Entity entity) {
        if (!this.doesBlink() || entity == null || !ETFClientCommon.ETFConfigData.enableBlinking) {
            return this.identifierOfCurrentState();
        }
        if (entity.func_213283_Z() == Pose.SLEEPING) {
            this.modifyTextureState(TextureReturnState.APPLY_BLINK);
            return this.identifierOfCurrentState();
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70644_a(Effects.field_76440_q)) {
            this.modifyTextureState(this.doesBlink2() ? TextureReturnState.APPLY_BLINK2 : TextureReturnState.APPLY_BLINK);
            return this.identifierOfCurrentState();
        }
        if (entity.field_70170_p != null) {
            UUID id = entity.func_110124_au();
            if (!ETFManager.getInstance().ENTITY_BLINK_TIME.containsKey((Object)id)) {
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)id, entity.field_70170_p.func_82737_E() + (long)this.blinkLength.intValue() + 1L);
                return this.identifierOfCurrentState();
            }
            long nextBlink = ETFManager.getInstance().ENTITY_BLINK_TIME.getLong((Object)id);
            long currentTime = entity.field_70170_p.func_82737_E();
            if (currentTime >= nextBlink - (long)this.blinkLength.intValue() && currentTime <= nextBlink + (long)this.blinkLength.intValue()) {
                if (this.doesBlink2()) {
                    if (currentTime >= nextBlink - (long)(this.blinkLength / 3) && currentTime <= nextBlink + (long)(this.blinkLength / 3)) {
                        this.modifyTextureState(TextureReturnState.APPLY_BLINK);
                        return this.identifierOfCurrentState();
                    }
                    this.modifyTextureState(TextureReturnState.APPLY_BLINK2);
                    return this.identifierOfCurrentState();
                }
                if (currentTime <= nextBlink) {
                    this.modifyTextureState(TextureReturnState.APPLY_BLINK);
                    return this.identifierOfCurrentState();
                }
            } else if (currentTime > nextBlink + (long)this.blinkLength.intValue()) {
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)id, currentTime + (long)randomBlink.nextInt(this.blinkFrequency) + 20L);
            }
        }
        return this.identifierOfCurrentState();
    }

    public boolean isEmissive() {
        return this.emissiveIdentifier != null;
    }

    public boolean isPatched() {
        return this.thisIdentifier_Patched != null;
    }

    public boolean doesBlink() {
        return this.blinkIdentifier != null;
    }

    public boolean doesBlink2() {
        return this.blink2Identifier != null;
    }

    public String toString() {
        return "ETFTexture{texture=" + this.thisIdentifier.toString() + ", emissive=" + this.isEmissive() + ", patched=" + this.isPatched() + "}";
    }

    public void renderEmissive(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, ModelRenderer modelPart) {
        this.renderEmissive(matrixStack, vertexConsumerProvider, modelPart, ETFManager.getEmissiveMode());
    }

    public void renderEmissive(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, ModelRenderer modelPart, ETFManager.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        IVertexBuilder vertexC = this.getEmissiveVertexConsumer(vertexConsumerProvider, null, modeToUsePossiblyManuallyChosen);
        if (vertexC != null) {
            modelPart.func_228308_a_(matrixStack, vertexC, 0xF000F0, OverlayTexture.field_229196_a_);
        }
    }

    public void renderEmissive(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, Model model) {
        this.renderEmissive(matrixStack, vertexConsumerProvider, model, ETFManager.getEmissiveMode());
    }

    public void renderEmissive(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, Model model, ETFManager.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        IVertexBuilder vertexC = this.getEmissiveVertexConsumer(vertexConsumerProvider, model, modeToUsePossiblyManuallyChosen);
        if (vertexC != null) {
            model.func_225598_a_(matrixStack, vertexC, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Nullable
    public IVertexBuilder getEmissiveVertexConsumer(IRenderTypeBuffer vertexConsumerProvider, @Nullable Model model, ETFManager.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        ResourceLocation emissiveToUse;
        if (this.isEmissive() && (emissiveToUse = this.getEmissiveIdentifierOfCurrentState()) != null) {
            if (modeToUsePossiblyManuallyChosen == ETFManager.EmissiveRenderModes.BRIGHT) {
                return vertexConsumerProvider.getBuffer(RenderType.func_228637_a_((ResourceLocation)emissiveToUse, (!ETFVersionDifferenceHandler.areShadersInUse() ? 1 : 0) != 0));
            }
            if (model == null) {
                return vertexConsumerProvider.getBuffer(RenderType.func_228640_c_((ResourceLocation)emissiveToUse));
            }
            return vertexConsumerProvider.getBuffer(model.func_228282_a_(emissiveToUse));
        }
        return null;
    }

    private void modifyTextureState(TextureReturnState givenState) {
        block0 : switch (givenState) {
            case APPLY_BLINK: {
                this.currentTextureState = this.currentTextureState == TextureReturnState.NORMAL_PATCHED ? TextureReturnState.BLINK_PATCHED : TextureReturnState.BLINK;
                break;
            }
            case APPLY_BLINK2: {
                switch (this.currentTextureState) {
                    case NORMAL_PATCHED: 
                    case BLINK_PATCHED: {
                        this.currentTextureState = TextureReturnState.BLINK2_PATCHED;
                        break block0;
                    }
                }
                this.currentTextureState = TextureReturnState.BLINK2;
            }
        }
    }

    @NotNull
    private ResourceLocation identifierOfCurrentState() {
        switch (this.currentTextureState) {
            case NORMAL: {
                return this.thisIdentifier;
            }
            case NORMAL_PATCHED: {
                return this.thisIdentifier_Patched;
            }
            case BLINK: {
                return this.blinkIdentifier;
            }
            case BLINK_PATCHED: {
                return this.blinkIdentifier_Patched;
            }
            case BLINK2: {
                return this.blink2Identifier;
            }
            case BLINK2_PATCHED: {
                return this.blink2Identifier_Patched;
            }
        }
        return this.thisIdentifier;
    }

    @Nullable
    public ResourceLocation getEmissiveIdentifierOfCurrentState() {
        switch (this.currentTextureState) {
            case NORMAL_PATCHED: 
            case NORMAL: {
                return this.emissiveIdentifier;
            }
            case BLINK_PATCHED: 
            case BLINK: {
                return this.emissiveBlinkIdentifier;
            }
            case BLINK2: 
            case BLINK2_PATCHED: {
                return this.emissiveBlink2Identifier;
            }
        }
        return null;
    }

    public static enum TextureReturnState {
        NORMAL,
        NORMAL_PATCHED,
        BLINK,
        BLINK_PATCHED,
        BLINK2,
        BLINK2_PATCHED,
        APPLY_PATCH,
        APPLY_BLINK,
        APPLY_BLINK2;


        public String toString() {
            switch (this) {
                case NORMAL: {
                    return "normal";
                }
                case BLINK: {
                    return "blink";
                }
                case BLINK2: {
                    return "blink2";
                }
                case NORMAL_PATCHED: {
                    return "normal_patched";
                }
                case BLINK_PATCHED: {
                    return "blink_patched";
                }
                case BLINK2_PATCHED: {
                    return "blink2_patched";
                }
                case APPLY_BLINK: {
                    return "apply_blink";
                }
                case APPLY_BLINK2: {
                    return "apply_blink2";
                }
                case APPLY_PATCH: {
                    return "apply_patch";
                }
            }
            return "null";
        }
    }
}

