/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.mixin.accessor.MooshroomEntityAccessor;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public abstract class ETFTexturePropertiesUtils {
    public static void processNewOptifinePropertiesFile(Entity entity, ResourceLocation vanillaIdentifier, ResourceLocation properties) {
        block30: {
            ETFManager manager = ETFManager.getInstance();
            try {
                Properties props = ETFUtils2.readAndReturnPropertiesElseNull(properties);
                if (props != null) {
                    if (props.containsKey("vanillaBrightnessOverride")) {
                        int tryNumber;
                        String value = props.getProperty("vanillaBrightnessOverride").trim();
                        try {
                            tryNumber = Integer.parseInt(value.replaceAll("\\D", ""));
                        }
                        catch (NumberFormatException e) {
                            tryNumber = 0;
                        }
                        if (tryNumber >= 16) {
                            tryNumber = 15;
                        }
                        if (tryNumber < 0) {
                            tryNumber = 0;
                        }
                        manager.ENTITY_TYPE_VANILLA_BRIGHTNESS_OVERRIDE_VALUE.put((Object)entity.func_200600_R(), tryNumber);
                    }
                    if (entity instanceof ZombifiedPiglinEntity && props.containsKey("showHiddenModelParts") && "true".equals(props.getProperty("showHiddenModelParts"))) {
                        manager.zombiePiglinRightEarEnabled = true;
                    }
                    if (props.containsKey("suppressParticles") && "true".equals(props.getProperty("suppressParticles"))) {
                        manager.ENTITY_TYPE_IGNORE_PARTICLES.add((Object)entity.func_200600_R());
                    }
                    if (props.containsKey("entityRenderLayerOverride")) {
                        String layer;
                        switch (layer = props.getProperty("entityRenderLayerOverride")) {
                            case "translucent": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put((Object)entity.func_200600_R(), 1);
                                break;
                            }
                            case "translucent_cull": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put((Object)entity.func_200600_R(), 2);
                                break;
                            }
                            case "end_portal": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put((Object)entity.func_200600_R(), 3);
                                break;
                            }
                            case "outline": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put((Object)entity.func_200600_R(), 4);
                            }
                        }
                    }
                    Set<String> propIds = props.stringPropertyNames();
                    HashSet<Integer> numbers = new HashSet<Integer>();
                    for (String str : propIds) {
                        if ((str = str.replaceAll("\\D", "")).isEmpty()) continue;
                        try {
                            numbers.add(Integer.parseInt(str));
                        }
                        catch (NumberFormatException e) {
                            ETFUtils2.logWarn("properties file number error in start count");
                        }
                    }
                    ArrayList numbersList = new ArrayList(numbers);
                    Collections.sort(numbersList);
                    ArrayList<ETFTexturePropertyCase> allCasesForTexture = new ArrayList<ETFTexturePropertyCase>();
                    for (Integer num : numbersList) {
                        Integer[] suffixes = ETFTexturePropertiesUtils.getSuffixes(props, num);
                        if (suffixes != null && suffixes.length != 0) {
                            allCasesForTexture.add(new ETFTexturePropertyCase(suffixes, ETFTexturePropertiesUtils.getWeights(props, num), ETFTexturePropertiesUtils.getBiomes(props, num), ETFTexturePropertiesUtils.getHeights(props, num), ETFTexturePropertiesUtils.getNames(props, num), ETFTexturePropertiesUtils.getProfessions(props, num), ETFTexturePropertiesUtils.getColors(props, num), ETFTexturePropertiesUtils.getBaby(props, num), ETFTexturePropertiesUtils.getWeather(props, num), ETFTexturePropertiesUtils.getHealth(props, num), ETFTexturePropertiesUtils.getMoon(props, num), ETFTexturePropertiesUtils.getDayTime(props, num), ETFTexturePropertiesUtils.getBlocks(props, num), ETFTexturePropertiesUtils.getTeams(props, num), ETFTexturePropertiesUtils.getSizes(props, num), ETFTexturePropertiesUtils.getSpeed(props, num), ETFTexturePropertiesUtils.getJump(props, num), ETFTexturePropertiesUtils.getMaxHealth(props, num), ETFTexturePropertiesUtils.getLlamaInv(props, num), ETFTexturePropertiesUtils.getAngry(props, num), ETFTexturePropertiesUtils.getHiddenGene(props, num), ETFTexturePropertiesUtils.getPlayerCreated(props, num), ETFTexturePropertiesUtils.getScreamingGoat(props, num), ETFTexturePropertiesUtils.getDistanceFromPlayer(props, num), ETFTexturePropertiesUtils.getCreeperCharge(props, num), ETFTexturePropertiesUtils.getStatusEffect(props, num), ETFTexturePropertiesUtils.getItems(props, num), ETFTexturePropertiesUtils.getMoving(props, num)));
                            continue;
                        }
                        ETFUtils2.logWarn("property number \"" + num + ". in file \"" + vanillaIdentifier + ". failed to read.");
                    }
                    if (!allCasesForTexture.isEmpty()) {
                        manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, allCasesForTexture);
                    } else {
                        ETFUtils2.logMessage("Ignoring properties file that failed to load any cases @ " + vanillaIdentifier, false);
                        manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
                    }
                    break block30;
                }
                ETFUtils2.logMessage("Ignoring properties file that was null @ " + vanillaIdentifier, false);
                manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
            }
            catch (Exception e) {
                ETFUtils2.logWarn("Ignoring properties file that caused Exception @ " + vanillaIdentifier + "\n" + e, false);
                e.printStackTrace();
                manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
            }
        }
    }

    @Nullable
    private static Integer[] getSuffixes(Properties props, int num) {
        Integer[] ints = ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "skins");
        return ints == null ? ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "textures") : ints;
    }

    @Nullable
    private static Integer[] getWeights(Properties props, int num) {
        if (props.containsKey("weights." + num)) {
            String dataFromProps = props.getProperty("weights." + num).trim();
            String[] weightData = dataFromProps.split("\\s+");
            ArrayList<Integer> builder = new ArrayList<Integer>();
            for (String s : weightData) {
                if ((s = s.trim()).replaceAll("\\D", "").isEmpty()) continue;
                try {
                    int tryNumber = Integer.parseInt(s.replaceAll("\\D", ""));
                    builder.add(tryNumber);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in weights category");
                }
            }
            return builder.toArray(new Integer[0]);
        }
        return null;
    }

    @Nullable
    private static String[] getBiomes(Properties props, int num) {
        String dataFromProps;
        String[] biomeList;
        if (props.containsKey("biomes." + num) && (biomeList = (dataFromProps = props.getProperty("biomes." + num).trim()).toLowerCase().split("\\s+")).length > 0) {
            block35: for (int i = 0; i < biomeList.length; ++i) {
                String biome;
                switch (biome = biomeList[i].trim()) {
                    case "ExtremeHills": {
                        biomeList[i] = "stony_peaks";
                        continue block35;
                    }
                    case "Forest": 
                    case "ForestHills": {
                        biomeList[i] = "forest";
                        continue block35;
                    }
                    case "Taiga": 
                    case "TaigaHills": {
                        biomeList[i] = "taiga";
                        continue block35;
                    }
                    case "Swampland": {
                        biomeList[i] = "swamp";
                        continue block35;
                    }
                    case "River": {
                        biomeList[i] = "river";
                        continue block35;
                    }
                    case "Hell": {
                        biomeList[i] = "nether_wastes";
                        continue block35;
                    }
                    case "Sky": {
                        biomeList[i] = "the_end";
                        continue block35;
                    }
                    case "IcePlains": {
                        biomeList[i] = "snowy_plains";
                        continue block35;
                    }
                    case "IceMountains": {
                        biomeList[i] = "snowy_slopes";
                        continue block35;
                    }
                    case "MushroomIsland": 
                    case "MushroomIslandShore": {
                        biomeList[i] = "mushroom_fields";
                        continue block35;
                    }
                    case "DesertHills": 
                    case "Desert": {
                        biomeList[i] = "desert";
                        continue block35;
                    }
                    case "ExtremeHillsEdge": {
                        biomeList[i] = "meadow";
                        continue block35;
                    }
                    case "Jungle": 
                    case "JungleHills": {
                        biomeList[i] = "jungle";
                        continue block35;
                    }
                    default: {
                        if (biome.contains("_") || !biome.matches("[A-Z]")) continue block35;
                        String snake_case_version = biome.replaceAll("(\\B)([A-Z])", "_$2");
                        biomeList[i] = snake_case_version.toLowerCase();
                    }
                }
            }
            return biomeList;
        }
        return null;
    }

    @Nullable
    private static Integer[] getHeights(Properties props, int num) {
        if (!props.containsKey("heights." + num) && (props.containsKey("minHeight." + num) || props.containsKey("maxHeight." + num))) {
            String min = "-64";
            String max = "319";
            if (props.containsKey("minHeight." + num)) {
                min = props.getProperty("minHeight." + num).trim();
            }
            if (props.containsKey("maxHeight." + num)) {
                max = props.getProperty("maxHeight." + num).trim();
            }
            props.put("heights." + num, min + "-" + max);
        }
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "heights");
    }

    @Nullable
    private static String[] getNames(Properties props, int num) {
        String dataFromProps;
        ArrayList<String> names = new ArrayList<String>();
        if (props.containsKey("names." + num)) {
            dataFromProps = props.getProperty("names." + num).trim();
            if (dataFromProps.contains("regex:") || dataFromProps.contains("pattern:")) {
                names.add(dataFromProps);
            } else {
                names.add(dataFromProps);
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(dataFromProps);
                while (m.find()) {
                    names.add(m.group(1).replace("\"", "").trim());
                }
            }
        }
        if (props.containsKey("name." + num)) {
            dataFromProps = props.getProperty("name." + num).trim();
            names.add(dataFromProps);
        }
        if (names.isEmpty()) {
            names = null;
        }
        return names == null ? null : names.toArray(new String[0]);
    }

    @Nullable
    private static String[] getProfessions(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "professions");
    }

    @Nullable
    private static String[] getColors(Properties props, int num) {
        String[] str = ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "collarColors");
        return str == null ? ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "colors") : str;
    }

    @Nullable
    private static Boolean getBaby(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "baby");
    }

    private static WeatherType getWeather(Properties props, int num) {
        if (props.containsKey("weather." + num)) {
            return WeatherType.getType(props.getProperty("weather." + num).trim());
        }
        return null;
    }

    @Nullable
    private static String[] getHealth(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "health");
    }

    @Nullable
    private static Integer[] getMoon(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "moonPhase");
    }

    @Nullable
    private static String[] getDayTime(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "dayTime");
    }

    @Nullable
    private static String[] getBlocks(Properties props, int num) {
        String[] str = ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "blocks");
        return str == null ? ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "block") : str;
    }

    @Nullable
    private static String[] getTeams(Properties props, int num) {
        if (props.containsKey("teams." + num)) {
            String teamData = props.getProperty("teams." + num).trim();
            ArrayList<String> list = new ArrayList<String>();
            Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(teamData);
            while (m.find()) {
                list.add(m.group(1).replace("\"", ""));
            }
            return list.toArray(new String[0]);
        }
        if (props.containsKey("team." + num)) {
            String teamData = props.getProperty("team." + num).trim();
            ArrayList<String> list = new ArrayList<String>();
            Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(teamData);
            while (m.find()) {
                list.add(m.group(1).replace("\"", ""));
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    @Nullable
    private static Integer[] getSizes(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "sizes");
    }

    @Nullable
    private static Double[] getSpeed(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericMinMaxDouble(props, num, "speed");
    }

    @Nullable
    private static Double[] getJump(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericMinMaxDouble(props, num, "jumpStrength");
    }

    @Nullable
    private static String[] getMaxHealth(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "maxHealth");
    }

    @Nullable
    private static Integer[] getLlamaInv(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "llamaInventory");
    }

    @Nullable
    private static Boolean getAngry(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "angry");
    }

    @Nullable
    private static PandaEntity.Gene[] getHiddenGene(Properties props, int num) {
        if (props.containsKey("hiddenGene." + num)) {
            String[] input = props.getProperty("hiddenGene." + num).trim().split("\\s+");
            ArrayList<PandaEntity.Gene> genes = new ArrayList<PandaEntity.Gene>();
            block18: for (String gene : input) {
                switch (gene.trim()) {
                    case "normal": {
                        genes.add(PandaEntity.Gene.NORMAL);
                        continue block18;
                    }
                    case "lazy": {
                        genes.add(PandaEntity.Gene.LAZY);
                        continue block18;
                    }
                    case "worried": {
                        genes.add(PandaEntity.Gene.WORRIED);
                        continue block18;
                    }
                    case "playful": {
                        genes.add(PandaEntity.Gene.PLAYFUL);
                        continue block18;
                    }
                    case "brown": {
                        genes.add(PandaEntity.Gene.BROWN);
                        continue block18;
                    }
                    case "weak": {
                        genes.add(PandaEntity.Gene.WEAK);
                        continue block18;
                    }
                    case "aggressive": {
                        genes.add(PandaEntity.Gene.AGGRESSIVE);
                        continue block18;
                    }
                    default: {
                        ETFUtils2.logWarn("properties files number error in hiddenGene category, caused by input: " + gene);
                    }
                }
            }
            return genes.toArray(new PandaEntity.Gene[0]);
        }
        return null;
    }

    @Nullable
    private static Boolean getPlayerCreated(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "playerCreated");
    }

    @Nullable
    private static Boolean getScreamingGoat(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "screamingGoat");
    }

    @Nullable
    private static String[] getDistanceFromPlayer(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "distanceFromPlayer");
    }

    @Nullable
    private static Boolean getCreeperCharge(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "creeperCharged");
    }

    @Nullable
    private static Effect[] getStatusEffect(Properties props, int num) {
        if (props.containsKey("statusEffect." + num)) {
            String dataFromProps = props.getProperty("statusEffect." + num).trim();
            String[] columnData = dataFromProps.split("\\s+");
            ArrayList<Effect> statuses = new ArrayList<Effect>();
            for (String data : columnData) {
                data = data.replaceAll("\\(", "").replaceAll("\\)", "");
                if ((data = data.trim()).replaceAll("\\D", "").isEmpty()) continue;
                try {
                    int tryNumber = Integer.parseInt(data.replaceAll("\\D", ""));
                    Effect attempt = Effect.func_188412_a((int)tryNumber);
                    if (attempt == null) continue;
                    statuses.add(attempt);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in statusEffects category");
                }
            }
            return statuses.toArray(new Effect[0]);
        }
        return null;
    }

    @Nullable
    private static String[] getItems(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "items");
    }

    @Nullable
    private static Boolean getMoving(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "moving");
    }

    @Nullable
    private static String[] getGenericStringSplitProperty(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            return props.getProperty(propertyName + "." + num).trim().split("\\s+");
        }
        return null;
    }

    @Nullable
    private static Integer[] getGenericIntegerSplitWithRanges(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            String dataFromProps = props.getProperty(propertyName + "." + num).trim();
            String[] skinData = dataFromProps.split("\\s+");
            ArrayList<Integer> suffixNumbers = new ArrayList<Integer>();
            for (String data : skinData) {
                if ((data = data.trim()).replaceAll("\\D", "").isEmpty()) continue;
                if (data.contains("-")) {
                    suffixNumbers.addAll(Arrays.asList(ETFUtils2.getIntRange(data)));
                    continue;
                }
                try {
                    int tryNumber = Integer.parseInt(data.replaceAll("\\D", ""));
                    suffixNumbers.add(tryNumber);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
                }
            }
            return suffixNumbers.toArray(new Integer[0]);
        }
        return null;
    }

    @Nullable
    private static Double[] getGenericMinMaxDouble(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            String dataFromProps = props.getProperty(propertyName + "." + num).trim();
            String[] rangeData = dataFromProps.split("-");
            if (rangeData.length == 2) {
                try {
                    double tryMinNumber = Double.parseDouble(rangeData[0].replaceAll("[^\\.\\d]", ""));
                    double tryMaxNumber = Double.parseDouble(rangeData[1].replaceAll("[^\\.\\d]", ""));
                    return new Double[]{tryMinNumber, tryMaxNumber};
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
                }
            } else {
                ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
            }
        }
        return null;
    }

    @Nullable
    private static Boolean getGenericBooleanThatCanNull(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            String input = props.getProperty(propertyName + "." + num).trim();
            if ("true".equals(input) || "false".equals(input)) {
                return "true".equals(input);
            }
            ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
        }
        return null;
    }

    public static class ETFTexturePropertyCase {
        private final Integer[] SUFFIX_NUMBERS_WEIGHTED;
        @Nullable
        private final String[] BIOME_VALUES;
        @Nullable
        private final Integer[] HEIGHT_Y_VALUES;
        @Nullable
        private final String[] NAME_STRINGS;
        @Nullable
        private final String[] PROFESSION_VALUES;
        @Nullable
        private final String[] COLOR_VALUES;
        @Nullable
        private final Boolean IS_BABY;
        @Nullable
        private final WeatherType WEATHER_TYPE;
        @Nullable
        private final String[] HEALTH_RANGE_STRINGS;
        @Nullable
        private final Integer[] MOON_PHASE_VALUES;
        @Nullable
        private final String[] TIME_RANGE_STRINGS;
        @Nullable
        private final String[] BLOCK_VALUES;
        @Nullable
        private final String[] TEAM_VALUES;
        @Nullable
        private final Integer[] SIZE_VALUES;
        @Nullable
        private final Double[] SPEED_MIN_MAX;
        @Nullable
        private final Double[] JUMP_MIN_MAX;
        @Nullable
        private final String[] MAX_HEALTH_STRINGS;
        @Nullable
        private final Integer[] INVENTORY_COLUMNS;
        @Nullable
        private final Boolean IS_ANGRY;
        @Nullable
        private final PandaEntity.Gene[] HIDDEN_GENE;
        @Nullable
        private final Boolean IS_PLAYER_CREATED;
        @Nullable
        private final Boolean IS_SCREAMING_GOAT;
        @Nullable
        private final String[] DISTANCE_TO_PLAYER;
        @Nullable
        private final Boolean CREEPER_CHARGED;
        @Nullable
        private final Effect[] STATUS_EFFECT;
        @Nullable
        private final String[] ITEMS;
        @Nullable
        private final Boolean MOVING;

        public ETFTexturePropertyCase(Integer[] suffixesX, @Nullable Integer[] weightsX, @Nullable String[] biomesX, @Nullable Integer[] heights, @Nullable String[] namesX, @Nullable String[] professionsX, @Nullable String[] collarColoursX, @Nullable Boolean baby012, @Nullable WeatherType weather0123, @Nullable String[] healthX, @Nullable Integer[] moonX, @Nullable String[] daytimeX, @Nullable String[] blocksX, @Nullable String[] teamsX, @Nullable Integer[] sizeX, @Nullable Double[] speedMinMax, @Nullable Double[] jumpMinMax, @Nullable String[] maxHealthStrings, @Nullable Integer[] inventoryColumns, @Nullable Boolean isAngry, @Nullable PandaEntity.Gene[] hiddenGene, @Nullable Boolean isPlayerCreated, @Nullable Boolean isScreamingGoat, @Nullable String[] distanceToPlayer, @Nullable Boolean creeperCharged, @Nullable Effect[] statusEffect, @Nullable String[] items, @Nullable Boolean moving) {
            this.MOVING = moving;
            this.ITEMS = items;
            this.STATUS_EFFECT = statusEffect;
            this.CREEPER_CHARGED = creeperCharged;
            this.DISTANCE_TO_PLAYER = distanceToPlayer;
            this.SPEED_MIN_MAX = speedMinMax;
            this.JUMP_MIN_MAX = jumpMinMax;
            this.MAX_HEALTH_STRINGS = maxHealthStrings;
            this.INVENTORY_COLUMNS = inventoryColumns;
            this.IS_ANGRY = isAngry;
            this.HIDDEN_GENE = hiddenGene;
            this.IS_PLAYER_CREATED = isPlayerCreated;
            this.IS_SCREAMING_GOAT = isScreamingGoat;
            this.BIOME_VALUES = biomesX;
            this.HEIGHT_Y_VALUES = heights;
            this.NAME_STRINGS = namesX;
            this.PROFESSION_VALUES = professionsX;
            this.COLOR_VALUES = collarColoursX;
            this.IS_BABY = baby012;
            this.WEATHER_TYPE = weather0123;
            this.HEALTH_RANGE_STRINGS = healthX;
            this.MOON_PHASE_VALUES = moonX;
            this.TIME_RANGE_STRINGS = daytimeX;
            this.BLOCK_VALUES = blocksX;
            this.TEAM_VALUES = teamsX;
            this.SIZE_VALUES = sizeX;
            if (weightsX == null) {
                weightsX = new Integer[]{};
            }
            if (weightsX.length > 0) {
                if (weightsX.length == suffixesX.length) {
                    ArrayList<Integer> buildWeighted = new ArrayList<Integer>();
                    int index = 0;
                    Integer[] integerArray = suffixesX;
                    int n = integerArray.length;
                    for (int i = 0; i < n; ++i) {
                        int suffix = integerArray[i];
                        Integer weightValue = weightsX[index];
                        if (weightValue != null) {
                            for (int i2 = 0; i2 < weightValue; ++i2) {
                                buildWeighted.add(suffix);
                            }
                        }
                        ++index;
                    }
                    this.SUFFIX_NUMBERS_WEIGHTED = buildWeighted.toArray(new Integer[0]);
                } else {
                    ETFUtils2.logWarn("random texture weights don't match for:\n suffixes: " + Arrays.toString((Object[])suffixesX) + "\n weights: " + Arrays.toString((Object[])weightsX), false);
                    this.SUFFIX_NUMBERS_WEIGHTED = suffixesX;
                }
            } else {
                this.SUFFIX_NUMBERS_WEIGHTED = suffixesX;
            }
        }

        public String toString() {
            return "randomCase{weightedSuffixes=" + Arrays.toString((Object[])this.SUFFIX_NUMBERS_WEIGHTED) + ", biomes=" + Arrays.toString(this.BIOME_VALUES) + ", heights=" + Arrays.toString((Object[])this.HEIGHT_Y_VALUES) + ", names=" + Arrays.toString(this.NAME_STRINGS) + '}';
        }

        public boolean doesEntityMeetConditionsOfThisCase(Entity entity, boolean isUpdate, Object2BooleanOpenHashMap<UUID> UUID_CaseHasUpdateablesCustom) {
            Object str;
            int n;
            int n2;
            boolean check;
            ImmutableList<String> spawnConditions;
            if (this.BIOME_VALUES == null && this.NAME_STRINGS == null && this.HEIGHT_Y_VALUES == null && this.PROFESSION_VALUES == null && this.COLOR_VALUES == null && this.IS_BABY == null && this.WEATHER_TYPE == null && this.HEALTH_RANGE_STRINGS == null && this.MOON_PHASE_VALUES == null && this.TIME_RANGE_STRINGS == null && this.BLOCK_VALUES == null && this.TEAM_VALUES == null && this.SIZE_VALUES == null && this.SPEED_MIN_MAX == null && this.JUMP_MIN_MAX == null && this.MAX_HEALTH_STRINGS == null && this.INVENTORY_COLUMNS == null && this.IS_ANGRY == null && this.HIDDEN_GENE == null && this.IS_PLAYER_CREATED == null && this.IS_SCREAMING_GOAT == null && this.DISTANCE_TO_PLAYER == null && this.CREEPER_CHARGED == null && this.STATUS_EFFECT == null && this.ITEMS == null && this.MOVING == null) {
                return true;
            }
            if (!ETFClientCommon.ETFConfigData.restrictUpdateProperties) {
                isUpdate = false;
            }
            UUID id = entity.func_110124_au();
            if (ETFClientCommon.ETFConfigData.restrictUpdateProperties) {
                if (ETFManager.getInstance().ENTITY_SPAWN_CONDITIONS_CACHE.containsKey(id)) {
                    spawnConditions = ETFManager.getInstance().ENTITY_SPAWN_CONDITIONS_CACHE.get(id);
                } else {
                    spawnConditions = this.readAllSpawnConditionsForCache(entity);
                    ETFManager.getInstance().ENTITY_SPAWN_CONDITIONS_CACHE.put(id, spawnConditions);
                }
            } else {
                spawnConditions = null;
            }
            boolean wasEntityTestedByAnUpdatableProperty = false;
            boolean doesEntityMeetThisCaseTest = true;
            if (this.BIOME_VALUES != null) {
                if (!ETFClientCommon.ETFConfigData.restrictBiome) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                String entityBiome = isUpdate && ETFClientCommon.ETFConfigData.restrictBiome && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 1 ? ((String)spawnConditions.get(0)).trim() : ETFVersionDifferenceHandler.getBiomeString(entity.field_70170_p, entity.func_233580_cy_());
                check = false;
                String[] stringArray = this.BIOME_VALUES;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String str2 = stringArray[n];
                    if (str2 == null || !entityBiome.replace("minecraft:", "").equals(str2.trim().toLowerCase().replace("minecraft:", ""))) continue;
                    check = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check;
            }
            if (doesEntityMeetThisCaseTest && this.NAME_STRINGS != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                if (entity.func_145818_k_()) {
                    String entityName = Objects.requireNonNull(entity.func_200201_e()).getString();
                    check = false;
                    boolean invert = false;
                    String[] stringArray = this.NAME_STRINGS;
                    n = stringArray.length;
                    for (int str2 = 0; str2 < n; ++str2) {
                        str = stringArray[str2];
                        if (str == null) continue;
                        if (((String)(str = ((String)str).trim())).startsWith("!")) {
                            str = ((String)str).replaceFirst("!", "");
                            invert = true;
                            check = true;
                        }
                        if (((String)str).contains("regex:")) {
                            if (((String)str).contains("iregex:")) {
                                str = ((String)str).split(":")[1];
                                if (!entityName.matches("(?i)" + (String)str)) continue;
                                check = !invert;
                                break;
                            }
                            if (!entityName.matches((String)(str = ((String)str).split(":")[1]))) continue;
                            check = !invert;
                            break;
                        }
                        if (((String)str).contains("pattern:")) {
                            if (((String)(str = ((String)str).replace("?", ".?").replace("*", ".*"))).contains("ipattern:")) {
                                str = ((String)str).replace("ipattern:", "");
                                if (!entityName.matches("(?i)" + (String)str)) continue;
                                check = !invert;
                                break;
                            }
                            if (!entityName.matches((String)(str = ((String)str).replace("pattern:", "")))) continue;
                            check = !invert;
                            break;
                        }
                        if (!entityName.equals(str)) continue;
                        check = !invert;
                        break;
                    }
                    doesEntityMeetThisCaseTest = check;
                } else {
                    doesEntityMeetThisCaseTest = false;
                }
            }
            if (doesEntityMeetThisCaseTest && this.HEIGHT_Y_VALUES != null) {
                if (!ETFClientCommon.ETFConfigData.restrictHeight) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                int entityHeight = isUpdate && ETFClientCommon.ETFConfigData.restrictHeight && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 2 ? Integer.parseInt(((String)spawnConditions.get(1)).trim()) : entity.func_233580_cy_().func_177956_o();
                check = false;
                Integer[] invert = this.HEIGHT_Y_VALUES;
                n2 = invert.length;
                for (n = 0; n < n2; ++n) {
                    int i = invert[n];
                    if (i != entityHeight) continue;
                    check = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check;
            }
            if (doesEntityMeetThisCaseTest && this.PROFESSION_VALUES != null && entity instanceof VillagerEntity) {
                wasEntityTestedByAnUpdatableProperty = true;
                String entityProfession = ((VillagerEntity)entity).func_213700_eh().func_221130_b().toString().toLowerCase().replace("minecraft:", "");
                int entityProfessionLevel = ((VillagerEntity)entity).func_213700_eh().func_221132_c();
                boolean check2 = false;
                String[] stringArray = this.PROFESSION_VALUES;
                n = stringArray.length;
                block3: for (int i = 0; i < n; ++i) {
                    str = stringArray[i];
                    if (str == null) continue;
                    if (((String)(str = ((String)str).toLowerCase().replaceAll("\\s*", "").replace("minecraft:", ""))).contains(":")) {
                        String[] data = ((String)str).split(":\\d");
                        if (!entityProfession.contains(data[0]) && !data[0].contains(entityProfession)) continue;
                        if (data.length == 2) {
                            String[] levels = data[1].split(",");
                            ArrayList<Integer> levelData = new ArrayList<Integer>();
                            for (String lvls : levels) {
                                if (lvls.contains("-")) {
                                    levelData.addAll(Arrays.asList(ETFUtils2.getIntRange(lvls)));
                                    continue;
                                }
                                levelData.add(Integer.parseInt(lvls.replaceAll("\\D", "")));
                            }
                            for (Integer i2 : levelData) {
                                if (i2 != entityProfessionLevel) continue;
                                check2 = true;
                                continue block3;
                            }
                            continue;
                        }
                        check2 = true;
                        break;
                    }
                    if (!entityProfession.contains((CharSequence)str) && !((String)str).contains(entityProfession)) continue;
                    check2 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check2;
            }
            if (doesEntityMeetThisCaseTest && this.COLOR_VALUES != null) {
                DyeColor str3;
                wasEntityTestedByAnUpdatableProperty = true;
                String entityColor = entity instanceof WolfEntity ? ((WolfEntity)entity).func_175546_cu().func_176762_d().toLowerCase() : (entity instanceof SheepEntity ? ((SheepEntity)entity).func_175509_cj().func_176762_d().toLowerCase() : (entity instanceof LlamaEntity ? ((str3 = ((LlamaEntity)entity).func_190704_dO()) != null ? str3.func_176762_d().toLowerCase() : "NOT_A_COLOR") : (entity instanceof CatEntity ? ((CatEntity)entity).func_213414_ei().func_176762_d().toLowerCase() : (entity instanceof ShulkerEntity ? ((str = ((ShulkerEntity)entity).func_190769_dn()) != null ? str.func_176762_d().toLowerCase() : "NOT_A_COLOR") : (entity instanceof TropicalFishEntity ? ((str = TropicalFishEntity.func_212326_d((int)((TropicalFishEntity)entity).func_204221_dB())) != null ? str.func_176762_d().toLowerCase() : "NOT_A_COLOR") : "NOT_A_COLOR")))));
                check = false;
                String[] check2 = this.COLOR_VALUES;
                int n3 = check2.length;
                for (n = 0; n < n3; ++n) {
                    String i = check2[n];
                    if (i == null || !(i = i.toLowerCase()).equals(entityColor)) continue;
                    check = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check;
            }
            if (doesEntityMeetThisCaseTest && entity instanceof LivingEntity && this.IS_BABY != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean bl = doesEntityMeetThisCaseTest = this.IS_BABY.booleanValue() == ((LivingEntity)entity).func_70631_g_();
            }
            if (doesEntityMeetThisCaseTest && this.WEATHER_TYPE != null) {
                boolean thundering;
                boolean raining;
                if (!ETFClientCommon.ETFConfigData.restrictWeather) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                if (isUpdate && ETFClientCommon.ETFConfigData.restrictWeather && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() >= 4) {
                    String[] data = ((String)spawnConditions.get(3)).split("-");
                    raining = "1".equals(data[0].trim());
                    thundering = "1".equals(data[1].trim());
                } else {
                    raining = entity.field_70170_p.func_72896_J();
                    thundering = entity.field_70170_p.func_72911_I();
                }
                boolean check3 = false;
                if (this.WEATHER_TYPE == WeatherType.clear && !raining && !thundering) {
                    check3 = true;
                } else if (this.WEATHER_TYPE == WeatherType.rain && raining) {
                    check3 = true;
                } else if (this.WEATHER_TYPE == WeatherType.thunder && thundering) {
                    check3 = true;
                }
                doesEntityMeetThisCaseTest = check3;
            }
            if (doesEntityMeetThisCaseTest && entity instanceof LivingEntity && this.HEALTH_RANGE_STRINGS != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean check4 = false;
                float checkValue = ((LivingEntity)entity).func_110143_aJ() / ((LivingEntity)entity).func_110138_aP() * 100.0f;
                String[] check3 = this.HEALTH_RANGE_STRINGS;
                int n4 = check3.length;
                for (n = 0; n < n4; ++n) {
                    String hlth = check3[n];
                    if (hlth == null) continue;
                    if (hlth.contains("-")) {
                        str = hlth.split("-");
                        if (!(checkValue >= (float)Integer.parseInt(((String)str[0]).replaceAll("\\D", ""))) || !(checkValue <= (float)Integer.parseInt(((String)str[1]).replaceAll("\\D", "")))) continue;
                        check4 = true;
                        break;
                    }
                    if (checkValue != (float)Integer.parseInt(hlth.replaceAll("\\D", ""))) continue;
                    check4 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check4;
            }
            if (doesEntityMeetThisCaseTest && this.MOON_PHASE_VALUES != null) {
                if (!ETFClientCommon.ETFConfigData.restrictMoonPhase) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                int moonPhase = isUpdate && ETFClientCommon.ETFConfigData.restrictMoonPhase && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 5 ? Integer.parseInt(((String)spawnConditions.get(5)).trim()) : entity.field_70170_p.func_242414_af();
                boolean check5 = false;
                Integer[] check3 = this.MOON_PHASE_VALUES;
                int n5 = check3.length;
                for (n = 0; n < n5; ++n) {
                    int i = check3[n];
                    if (i != moonPhase) continue;
                    check5 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check5;
            }
            if (doesEntityMeetThisCaseTest && this.TIME_RANGE_STRINGS != null) {
                if (!ETFClientCommon.ETFConfigData.restrictDayTime) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                boolean check6 = false;
                long time = isUpdate && ETFClientCommon.ETFConfigData.restrictDayTime && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 4 ? Long.parseLong(((String)spawnConditions.get(4)).trim()) : entity.field_70170_p.func_72820_D();
                String[] stringArray = this.TIME_RANGE_STRINGS;
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String rangeOfTime = stringArray[i];
                    if (rangeOfTime == null) continue;
                    if (rangeOfTime.contains("-")) {
                        String[] str4 = rangeOfTime.split("-");
                        if (time < Long.parseLong(str4[0].replaceAll("\\D", "")) || time > Long.parseLong(str4[1].replaceAll("\\D", ""))) continue;
                        check6 = true;
                        break;
                    }
                    if (time != Long.parseLong(rangeOfTime.replaceAll("\\D", ""))) continue;
                    check6 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check6;
            }
            if (doesEntityMeetThisCaseTest && this.BLOCK_VALUES != null) {
                String[] entityOnBlocks;
                if (!ETFClientCommon.ETFConfigData.restrictBlock) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                if (isUpdate && ETFClientCommon.ETFConfigData.restrictBlock && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 6) {
                    entityOnBlocks = new String[]{((String)spawnConditions.get(2)).trim(), ((String)spawnConditions.get(6)).trim()};
                } else {
                    String entityOnBlock1 = entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177977_b()).toString().replaceFirst("minecraft:", "").replaceFirst("Block\\{", "").replaceFirst("}.*", "").toLowerCase();
                    String entityOnBlock2 = entity.field_70170_p.func_180495_p(entity.func_233580_cy_()).toString().replaceFirst("minecraft:", "").replaceFirst("Block\\{", "").replaceFirst("}.*", "").toLowerCase();
                    entityOnBlocks = new String[]{entityOnBlock1, entityOnBlock2};
                }
                boolean check2 = false;
                boolean check1 = false;
                for (String block : this.BLOCK_VALUES) {
                    if (block == null) continue;
                    if ((block = block.trim()).startsWith("!")) {
                        if (!(block = block.replaceFirst("!", "")).replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[0])) {
                            check1 = true;
                            continue;
                        }
                        doesEntityMeetThisCaseTest = false;
                        continue;
                    }
                    if (!block.replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[0])) continue;
                    check1 = true;
                    break;
                }
                String[] stringArray = this.BLOCK_VALUES;
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String block;
                    block = stringArray[i];
                    if (block == null) continue;
                    if ((block = block.trim()).startsWith("!")) {
                        if (!(block = block.replaceFirst("!", "")).replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[1])) {
                            check2 = true;
                            continue;
                        }
                        doesEntityMeetThisCaseTest = false;
                        continue;
                    }
                    if (!block.replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[1])) continue;
                    check2 = true;
                    break;
                }
                if (doesEntityMeetThisCaseTest) {
                    boolean bl = doesEntityMeetThisCaseTest = check1 || check2;
                }
            }
            if (doesEntityMeetThisCaseTest && this.TEAM_VALUES != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                if (entity.func_96124_cp() != null) {
                    String teamName = entity.func_96124_cp().func_96661_b();
                    boolean check7 = false;
                    boolean invert = false;
                    String[] stringArray = this.TEAM_VALUES;
                    n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        str = stringArray[i];
                        if (str == null) continue;
                        if (((String)(str = ((String)str).trim())).startsWith("!")) {
                            str = ((String)str).replaceFirst("!", "");
                            invert = true;
                            check7 = true;
                        }
                        if (!teamName.equals(str)) continue;
                        check7 = !invert;
                        break;
                    }
                    doesEntityMeetThisCaseTest = check7;
                } else {
                    doesEntityMeetThisCaseTest = false;
                }
            }
            if (doesEntityMeetThisCaseTest && this.SIZE_VALUES != null && (entity instanceof SlimeEntity || entity instanceof PhantomEntity)) {
                int size = entity instanceof SlimeEntity ? ((SlimeEntity)entity).func_70809_q() : ((PhantomEntity)entity).func_203032_dq();
                boolean check8 = false;
                Integer[] invert = this.SIZE_VALUES;
                int n6 = invert.length;
                for (n = 0; n < n6; ++n) {
                    int i = invert[n];
                    if (i != size) continue;
                    check8 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check8;
            }
            if (doesEntityMeetThisCaseTest && entity instanceof LivingEntity && this.SPEED_MIN_MAX != null) {
                double speed = ((LivingEntity)entity).func_70689_ay();
                Double min = this.SPEED_MIN_MAX[0];
                Double max = this.SPEED_MIN_MAX[1];
                if (min != null && max != null) {
                    boolean bl = doesEntityMeetThisCaseTest = speed >= min && speed <= max;
                }
            }
            if (doesEntityMeetThisCaseTest && this.JUMP_MIN_MAX != null && entity instanceof AbstractHorseEntity) {
                double jumpHeight = ((AbstractHorseEntity)entity).func_110215_cj();
                Double min = this.JUMP_MIN_MAX[0];
                Double max = this.JUMP_MIN_MAX[1];
                if (min != null && max != null) {
                    boolean bl = doesEntityMeetThisCaseTest = jumpHeight >= min && jumpHeight <= max;
                }
            }
            if (doesEntityMeetThisCaseTest && entity instanceof LivingEntity && this.MAX_HEALTH_STRINGS != null) {
                boolean check9 = false;
                float checkValue = ((LivingEntity)entity).func_110138_aP();
                for (String hlth : this.MAX_HEALTH_STRINGS) {
                    if (hlth == null) continue;
                    if (hlth.contains("-")) {
                        str = hlth.split("-");
                        if (!(checkValue >= (float)Integer.parseInt(((String)str[0]).replaceAll("\\D", ""))) || !(checkValue <= (float)Integer.parseInt(((String)str[1]).replaceAll("\\D", "")))) continue;
                        check9 = true;
                        break;
                    }
                    if (checkValue != (float)Integer.parseInt(hlth.replaceAll("\\D", ""))) continue;
                    check9 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check9;
            }
            if (doesEntityMeetThisCaseTest && this.INVENTORY_COLUMNS != null && entity instanceof LlamaEntity) {
                boolean found = false;
                Integer[] checkValue = this.INVENTORY_COLUMNS;
                int min = checkValue.length;
                for (int max = 0; max < min; ++max) {
                    int columns = checkValue[max];
                    if (((LlamaEntity)entity).func_190696_dl() != columns) continue;
                    found = true;
                    break;
                }
                doesEntityMeetThisCaseTest = found;
            }
            if (doesEntityMeetThisCaseTest && this.IS_ANGRY != null) {
                if (entity instanceof EndermanEntity) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = ((EndermanEntity)entity).func_70823_r() == this.IS_ANGRY.booleanValue();
                } else if (entity instanceof BlazeEntity) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = entity.func_70027_ad() == this.IS_ANGRY.booleanValue();
                } else if (entity instanceof GuardianEntity) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = ((GuardianEntity)entity).func_175466_co() != null == this.IS_ANGRY;
                } else if (entity instanceof VindicatorEntity) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = ((VindicatorEntity)entity).func_213398_dR() == this.IS_ANGRY.booleanValue();
                } else if (entity instanceof SpellcastingIllagerEntity) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = ((SpellcastingIllagerEntity)entity).func_193082_dl() == this.IS_ANGRY.booleanValue();
                } else {
                    doesEntityMeetThisCaseTest = false;
                }
            }
            if (doesEntityMeetThisCaseTest && this.HIDDEN_GENE != null && entity instanceof PandaEntity) {
                boolean found = false;
                for (PandaEntity.Gene gene : this.HIDDEN_GENE) {
                    if (((PandaEntity)entity).func_213536_eg() != gene) continue;
                    found = true;
                    break;
                }
                doesEntityMeetThisCaseTest = found;
            }
            if (doesEntityMeetThisCaseTest && this.IS_PLAYER_CREATED != null && entity instanceof IronGolemEntity) {
                boolean bl = doesEntityMeetThisCaseTest = ((IronGolemEntity)entity).func_70850_q() == this.IS_PLAYER_CREATED.booleanValue();
            }
            if (doesEntityMeetThisCaseTest && this.DISTANCE_TO_PLAYER != null && Minecraft.func_71410_x().field_71439_g != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean check10 = false;
                float checkValue = entity.func_70032_d((Entity)Minecraft.func_71410_x().field_71439_g);
                for (String distances : this.DISTANCE_TO_PLAYER) {
                    if (distances == null) continue;
                    if (distances.contains("-")) {
                        str = distances.split("-");
                        if (!(checkValue >= (float)Integer.parseInt(((String)str[0]).replaceAll("\\D", ""))) || !(checkValue <= (float)Integer.parseInt(((String)str[1]).replaceAll("\\D", "")))) continue;
                        check10 = true;
                        break;
                    }
                    if ((int)checkValue != Integer.parseInt(distances.replaceAll("\\D", ""))) continue;
                    check10 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check10;
            }
            if (doesEntityMeetThisCaseTest && this.CREEPER_CHARGED != null && entity instanceof CreeperEntity) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean bl = doesEntityMeetThisCaseTest = ((CreeperEntity)entity).func_225509_J__() == this.CREEPER_CHARGED.booleanValue();
            }
            if (doesEntityMeetThisCaseTest && entity instanceof LivingEntity && this.STATUS_EFFECT != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean found = false;
                for (Effect effect : this.STATUS_EFFECT) {
                    if (!((LivingEntity)entity).func_70644_a(effect)) continue;
                    found = true;
                    break;
                }
                if (!found && entity instanceof MooshroomEntity) {
                    MooshroomEntity shroom = (MooshroomEntity)entity;
                    for (Effect effect : this.STATUS_EFFECT) {
                        if (effect == null || !effect.equals(((MooshroomEntityAccessor)shroom).getStewEffect())) continue;
                        found = true;
                        break;
                    }
                }
                doesEntityMeetThisCaseTest = found;
            }
            if (doesEntityMeetThisCaseTest && this.ITEMS != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                System.out.println(Arrays.toString(this.ITEMS) + " - " + entity.func_184209_aF().toString());
                if (this.ITEMS.length == 1 && ("none".equals(this.ITEMS[0]) || "any".equals(this.ITEMS[0]) || "holding".equals(this.ITEMS[0]) || "wearing".equals(this.ITEMS[0]))) {
                    if ("none".equals(this.ITEMS[0])) {
                        Iterable equipped = entity.func_184209_aF();
                        for (ItemStack item : equipped) {
                            if (item == null || item.func_190926_b()) continue;
                            doesEntityMeetThisCaseTest = false;
                            break;
                        }
                    } else {
                        Iterable items = "any".equals(this.ITEMS[0]) ? entity.func_184209_aF() : ("holding".equals(this.ITEMS[0]) ? entity.func_184214_aD() : entity.func_184193_aE());
                        boolean found = false;
                        for (ItemStack item : items) {
                            if (item == null || item.func_190926_b()) continue;
                            found = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = found;
                    }
                } else {
                    Iterable equipped = entity.func_184209_aF();
                    boolean found = false;
                    block22: for (String itemToFind : this.ITEMS) {
                        if (itemToFind == null) continue;
                        if (itemToFind.contains("minecraft:")) {
                            itemToFind = itemToFind.replace("minecraft:", "");
                        }
                        for (ItemStack item : equipped) {
                            if (item == null || item.func_190926_b() || !item.func_77973_b().toString().replace("minecraft:", "").equals(itemToFind)) continue;
                            found = true;
                            break block22;
                        }
                    }
                    doesEntityMeetThisCaseTest = found;
                }
            }
            if (doesEntityMeetThisCaseTest && this.MOVING != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean bl = doesEntityMeetThisCaseTest = this.horizontalLength(entity.func_213322_ci()) == 0.0 != this.MOVING;
            }
            if (wasEntityTestedByAnUpdatableProperty) {
                UUID_CaseHasUpdateablesCustom.put((Object)entity.func_110124_au(), true);
            }
            return doesEntityMeetThisCaseTest;
        }

        public double horizontalLength(Vector3d vec) {
            return MathHelper.func_76133_a((double)(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c));
        }

        public int getAnEntityVariantSuffixFromThisCase(UUID id) {
            int randomReliable = id.hashCode() > 0 ? id.hashCode() : -id.hashCode();
            randomReliable %= this.SUFFIX_NUMBERS_WEIGHTED.length;
            randomReliable = this.SUFFIX_NUMBERS_WEIGHTED[randomReliable];
            return randomReliable;
        }

        @NotNull
        private ImmutableList<String> readAllSpawnConditionsForCache(@NotNull Entity entity) {
            String block2;
            @NotNull String biome = !ETFClientCommon.ETFConfigData.restrictBiome ? "" : ETFVersionDifferenceHandler.getBiomeString(entity.field_70170_p, entity.func_233580_cy_());
            @NotNull String height = !ETFClientCommon.ETFConfigData.restrictHeight ? "" : "" + entity.func_233580_cy_().func_177956_o();
            @NotNull String block = !ETFClientCommon.ETFConfigData.restrictBlock ? "" : entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177977_b()).toString().replaceFirst("minecraft:", "").replaceFirst("Block\\{", "").replaceFirst("}.*", "").toLowerCase();
            String string = block2 = !ETFClientCommon.ETFConfigData.restrictBlock ? "" : entity.field_70170_p.func_180495_p(entity.func_233580_cy_()).toString().replaceFirst("minecraft:", "").replaceFirst("Block\\{", "").replaceFirst("}.*", "").toLowerCase();
            @NotNull String weather = !ETFClientCommon.ETFConfigData.restrictWeather ? "" : (entity.field_70170_p.func_72896_J() ? "1" : "0") + "-" + (entity.field_70170_p.func_72911_I() ? "1" : "0");
            @NotNull String time = !ETFClientCommon.ETFConfigData.restrictDayTime ? "" : "" + entity.field_70170_p.func_72820_D();
            @NotNull String moon = !ETFClientCommon.ETFConfigData.restrictMoonPhase ? "" : "" + entity.field_70170_p.func_242414_af();
            return ImmutableList.of((Object)biome, (Object)height, (Object)block, (Object)weather, (Object)time, (Object)moon, (Object)block2);
        }
    }

    private static enum WeatherType {
        clear,
        rain,
        thunder;


        @Nullable
        public static WeatherType getType(String type) {
            if (type == null) {
                return null;
            }
            switch (type) {
                case "clear": {
                    return clear;
                }
                case "rain": {
                    return rain;
                }
                case "thunder": {
                    return thunder;
                }
            }
            return null;
        }
    }
}

