/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.standardconfigs;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class CopyConfig {
    private static final String path = "standardconfigs";
    private static final Logger LOGGER = LogManager.getLogger((String)"StandardConfigs");

    private static Path getPresetConfigPath() {
        return FMLPaths.GAMEDIR.get().resolve(path);
    }

    private static Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    private static Path getDefaultConfigPath() {
        return FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Pair<File, String>> getConfigFiles(ConfigType type) {
        File folder = new File(CopyConfig.getPresetConfigPath().toFile(), type.getChildPath());
        if (!folder.exists()) {
            return Collections.emptyList();
        }
        try (Stream<Path> files = Files.find(folder.toPath(), Integer.MAX_VALUE, (path1, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]);){
            List<Pair<File, String>> list = files.map(Path::toFile).map(file -> Pair.of((Object)file, (Object)CopyConfig.trimStart(file.getAbsolutePath(), folder.getAbsolutePath()))).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            LOGGER.error(type.getMarker(), "Could not copy files", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static boolean copyConfig(Pair<File, String> file, ConfigType type) throws IOException {
        File to = new File(type.getTargetFolder(), (String)file.getValue());
        if (to.exists()) {
            return false;
        }
        com.google.common.io.Files.createParentDirs((File)to);
        com.google.common.io.Files.copy((File)((File)file.getKey()), (File)to);
        return true;
    }

    private static void copyConfig(ConfigType type) {
        LOGGER.info(type.getMarker(), "Copying config files");
        List<Pair<File, String>> configFiles = CopyConfig.getConfigFiles(type);
        int copied = 0;
        int skipped = 0;
        ArrayList<Pair> errors = new ArrayList<Pair>();
        for (Pair pair2 : configFiles) {
            try {
                if (CopyConfig.copyConfig((Pair<File, String>)pair2, type)) {
                    ++copied;
                    LOGGER.debug(type.getMarker(), "Copied config file {}", (Object)((File)pair2.getKey()).getName());
                    continue;
                }
                ++skipped;
                LOGGER.debug(type.getMarker(), "Skipped config file {}", (Object)((File)pair2.getKey()).getName());
            }
            catch (IOException e) {
                errors.add(Pair.of((Object)pair2.getLeft(), (Object)e));
            }
        }
        LOGGER.info(type.getMarker(), "Finished copying: {} copied, {} skipped, {} errors", (Object)copied, (Object)skipped, (Object)errors.size());
        errors.forEach(pair -> LOGGER.error(type.getMarker(), "Error copying config file {}", pair.getLeft(), pair.getRight()));
    }

    public static void copyClient() {
        CopyConfig.copyConfig(ConfigType.CLIENT);
    }

    public static void copyCommon() {
        CopyConfig.copyConfig(ConfigType.COMMON);
        CopyConfig.copyConfig(ConfigType.SERVER);
    }

    private static String trimStart(String source, String trim) {
        return source.replace(trim, "");
    }

    public static enum ConfigType {
        CLIENT("client", () -> CopyConfig.access$100()),
        COMMON("common", () -> CopyConfig.access$100()),
        SERVER("server", () -> CopyConfig.access$000());

        private final String childPath;
        private final Supplier<Path> targetFolderSupplier;
        private final Marker marker;

        private ConfigType(String childPath, Supplier<Path> targetFolderSupplier) {
            this.childPath = childPath;
            this.targetFolderSupplier = targetFolderSupplier;
            this.marker = MarkerManager.getMarker((String)this.toString());
        }

        public String getChildPath() {
            return this.childPath;
        }

        public File getTargetFolder() {
            return this.targetFolderSupplier.get().toFile();
        }

        public Marker getMarker() {
            return this.marker;
        }
    }
}

