/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.network;

import com.minecraftabnormals.abnormals_core.core.util.MathUtil;
import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import com.minecraftabnormals.endergetic.api.entity.util.EntityMotionHelper;
import com.minecraftabnormals.endergetic.common.items.BoofloVestItem;
import com.minecraftabnormals.endergetic.core.registry.EEItems;
import com.minecraftabnormals.endergetic.core.registry.EESounds;
import com.minecraftabnormals.endergetic.core.registry.other.EETags;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public final class C2SInflateBoofloVestMessage {
    private static final String POISE_BUBBLE_ID = "endergetic:short_poise_bubble";
    public static final float HORIZONTAL_BOOST_FORCE = 4.0f;
    public static final float VERTICAL_BOOST_FORCE = 0.75f;
    private static final int DEFAULT_DELAY = 7;
    private static final int DELAY_INCREASE_THRESHOLD = 5;
    private static final int DELAY_MULTIPLIER = 5;

    public static void serialize(C2SInflateBoofloVestMessage message, PacketBuffer buffer) {
    }

    public static C2SInflateBoofloVestMessage deserialize(PacketBuffer buffer) {
        return new C2SInflateBoofloVestMessage();
    }

    public static boolean handle(C2SInflateBoofloVestMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ItemStack stack;
                ServerPlayerEntity player = context.getSender();
                if (player != null && !player.func_233570_aj_() && !player.func_175149_v() && (stack = (ItemStack)player.field_71071_by.field_70460_b.get(2)).func_77973_b() == EEItems.BOOFLO_VEST.get() && BoofloVestItem.canBoof(stack, (PlayerEntity)player)) {
                    CompoundNBT tag = stack.func_196082_o();
                    tag.func_74757_a("boofed", true);
                    tag.func_74768_a("ticksBoofed", 0);
                    int increment = tag.func_74762_e("timesBoofed") + 1;
                    tag.func_74768_a("timesBoofed", increment);
                    player.func_184811_cZ().func_185145_a((Item)EEItems.BOOFLO_VEST.get(), increment < 5 ? 7 : 5 * increment);
                    Entity ridingEntity = player.func_184187_bx();
                    for (Entity entity : player.field_70170_p.func_175647_a(Entity.class, player.func_174813_aQ().func_186662_g(2.0), arg_0 -> C2SInflateBoofloVestMessage.lambda$null$0((PlayerEntity)player, ridingEntity, arg_0))) {
                        EntityMotionHelper.knockbackEntity(entity, 4.0f, 0.75f, false, false);
                    }
                    if (ridingEntity != null) {
                        EntityMotionHelper.knockbackEntity(ridingEntity, 4.0f, 0.75f, true, false);
                    }
                    double posX = player.func_226277_ct_();
                    double posY = player.func_226278_cu_();
                    double posZ = player.func_226281_cx_();
                    Random rand = player.func_70681_au();
                    for (int i = 0; i < 8; ++i) {
                        double x = posX + MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.15f), (Random)rand);
                        double y = posY + (double)(rand.nextFloat() * 0.05f) + 1.25;
                        double z = posZ + MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.15f), (Random)rand);
                        NetworkUtil.spawnParticle((String)POISE_BUBBLE_ID, (double)x, (double)y, (double)z, (double)(MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.3f), (Random)rand) + (double)0.025f), (double)(rand.nextFloat() * 0.15f + 0.1f), (double)(MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.3f), (Random)rand) + (double)0.025f));
                    }
                    player.field_70170_p.func_184148_a(null, posX, posY, posZ, (SoundEvent)EESounds.BOOFLO_VEST_INFLATE.get(), SoundCategory.PLAYERS, 1.0f, MathHelper.func_76131_a((float)(1.3f - (float)increment * 0.15f), (float)0.25f, (float)1.0f));
                }
            });
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$null$0(PlayerEntity player, Entity ridingEntity, Entity entity) {
        return entity != player && entity != ridingEntity && !EETags.EntityTypes.BOOF_BLOCK_RESISTANT.func_230235_a_((Object)entity.func_200600_R());
    }
}

