/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.tileentities;

import com.minecraftabnormals.abnormals_core.core.endimator.ControlledEndimation;
import com.minecraftabnormals.abnormals_core.core.util.MathUtil;
import com.minecraftabnormals.endergetic.api.util.StringUtils;
import com.minecraftabnormals.endergetic.common.blocks.poise.BolloomBudBlock;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomFruitEntity;
import com.minecraftabnormals.endergetic.common.entities.puffbug.PuffBugEntity;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.minecraftabnormals.endergetic.core.registry.EETileEntities;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BolloomBudTileEntity
extends TileEntity
implements ITickableTileEntity {
    public final ControlledEndimation pedalAnimation = new ControlledEndimation(20, 20);
    private EnumMap<BudSide, SideData> sideData = (EnumMap)Util.func_200696_a(new EnumMap(BudSide.class), side -> {
        side.put(BudSide.NORTH, new SideData());
        side.put(BudSide.EAST, new SideData());
        side.put(BudSide.SOUTH, new SideData());
        side.put(BudSide.WEST, new SideData());
    });
    private int maxFruitHeight = 7;
    private UUID teleportingBug;

    public BolloomBudTileEntity() {
        super((TileEntityType)EETileEntities.BOLLOOM_BUD.get());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(1.0);
    }

    public double func_145833_n() {
        return super.func_145833_n() * 2.0;
    }

    public void func_73660_a() {
        Random rand = new Random();
        this.sideData.forEach((side, sideData) -> {
            if (((SideData)sideData).growTimer > 0 && ((SideData)sideData).growing) {
                ((SideData)sideData).growTimer--;
            }
            if (((SideData)sideData).growing && ((SideData)sideData).growTimer <= 0) {
                if (!this.field_145850_b.func_201670_d() && ((Boolean)this.func_195044_w().func_177229_b((Property)BolloomBudBlock.OPENED)).booleanValue()) {
                    int height = rand.nextInt(this.maxFruitHeight) + 1;
                    BolloomFruitEntity fruit = new BolloomFruitEntity(this.field_145850_b, this.field_174879_c, side.offsetPosition(this.field_174879_c).func_177981_b(height - 1), height, ((BudSide)side).direction);
                    this.field_145850_b.func_217376_c((Entity)fruit);
                    ((SideData)sideData).fruitUUID = fruit.func_110124_au();
                }
                ((SideData)sideData).growing = false;
                ((SideData)sideData).growTimer = 0;
            }
        });
        if (((Boolean)this.func_195044_w().func_177229_b((Property)BolloomBudBlock.OPENED)).booleanValue() && !this.field_145850_b.func_201670_d() && this.shouldShutBud() && rand.nextInt(200) == 0) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BolloomBudBlock.OPENED, (Comparable)Boolean.valueOf(false)), 2);
            this.resetGrowing();
        }
        this.pedalAnimation.update();
        this.pedalAnimation.tick();
        if (this.field_145850_b.isAreaLoaded(this.field_174879_c, 1)) {
            boolean opened = (Boolean)this.func_195044_w().func_177229_b((Property)BolloomBudBlock.OPENED);
            if (this.pedalAnimation.isDecrementing() != opened) {
                this.pedalAnimation.setDecrementing(opened);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.teleportingBug != null) {
            Entity entity = ((ServerWorld)this.field_145850_b).func_217461_a(this.teleportingBug);
            if (entity != null && !entity.func_70089_S()) {
                this.teleportingBug = null;
            } else if (entity == null) {
                this.teleportingBug = null;
            }
        }
    }

    public void startGrowing(Random rand, int maxHeight, boolean instant) {
        boolean didOneGrow = false;
        this.maxFruitHeight = maxHeight;
        if (instant) {
            this.pedalAnimation.setTick(0);
        }
        for (Map.Entry<BudSide, SideData> data : this.sideData.entrySet()) {
            if (!rand.nextBoolean()) continue;
            data.getValue().growing = true;
            data.getValue().growTimer = instant ? 0 : rand.nextInt(220) + 60;
            didOneGrow = true;
        }
        if (!didOneGrow) {
            SideData sideData = this.sideData.get((Object)BudSide.random(rand));
            sideData.growing = true;
            sideData.growTimer = instant ? 0 : rand.nextInt(220) + 60;
        }
    }

    public void resetGrowing() {
        this.sideData.forEach((side, sideData) -> {
            ((SideData)sideData).fruitUUID = null;
            ((SideData)sideData).growing = false;
            ((SideData)sideData).growTimer = 0;
        });
        this.maxFruitHeight = 7;
    }

    public void setTeleportingBug(@Nullable PuffBugEntity puffbug) {
        this.teleportingBug = puffbug != null ? puffbug.func_110124_au() : null;
    }

    public boolean hasTeleportingBug() {
        return this.teleportingBug != null;
    }

    public boolean canBeOpened() {
        Block block = (Block)EEBlocks.BOLLOOM_BUD.get();
        for (Direction directions : Direction.values()) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(directions, 2)).func_177230_c() != block) continue;
            return false;
        }
        BlockPos north = this.field_174879_c.func_177972_a(Direction.NORTH);
        BlockPos south = this.field_174879_c.func_177972_a(Direction.SOUTH);
        if (this.field_145850_b.func_180495_p(north.func_177974_f()).func_177230_c() == block || this.field_145850_b.func_180495_p(south.func_177974_f()).func_177230_c() == block || this.field_145850_b.func_180495_p(north.func_177976_e()).func_177230_c() == block || this.field_145850_b.func_180495_p(south.func_177976_e()).func_177230_c() == block) {
            return false;
        }
        for (BudSide sides : BudSide.values()) {
            BlockPos sidePos = sides.offsetPosition(this.field_174879_c);
            if (this.field_145850_b.func_204610_c(sidePos).func_206888_e() && this.field_145850_b.func_180495_p(sidePos).func_196952_d((IBlockReader)this.field_145850_b, sidePos).func_197766_b()) continue;
            return false;
        }
        return (Boolean)this.func_195044_w().func_177229_b((Property)BolloomBudBlock.OPENED) == false && this.calculateFruitMaxHeight() >= 3;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.maxFruitHeight = compound.func_74764_b("MaxFruitHeight") ? MathHelper.func_76125_a((int)compound.func_74762_e("MaxFruitHeight"), (int)1, (int)7) : 7;
        this.sideData.forEach((side, sideData) -> {
            String sideName = StringUtils.capitaliseFirstLetter(((BudSide)side).direction.toString());
            String sideUUID = compound.func_150297_b(sideName + "FruitUUID", 8) ? compound.func_74779_i(sideName + "FruitUUID") : "";
            ((SideData)sideData).fruitUUID = !sideUUID.isEmpty() ? UUID.fromString(sideUUID) : null;
            ((SideData)sideData).growing = compound.func_74767_n("Is" + sideName + "Growing");
            ((SideData)sideData).growTimer = compound.func_74762_e(sideName + "GrowTime");
        });
        this.pedalAnimation.read(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (compound.func_74764_b("MaxFruitHeight")) {
            compound.func_74768_a("MaxFruitHeight", this.maxFruitHeight);
        }
        this.sideData.forEach((side, sideData) -> {
            String sideName = StringUtils.capitaliseFirstLetter(((BudSide)side).direction.toString());
            if (((SideData)sideData).fruitUUID == null) {
                compound.func_74778_a(sideName + "FruitUUID", "");
            } else {
                compound.func_74778_a(sideName + "FruitUUID", ((SideData)sideData).fruitUUID.toString());
            }
            compound.func_74757_a("Is" + sideName + "Growing", ((SideData)sideData).growing);
            compound.func_74768_a(sideName + "GrowTime", ((SideData)sideData).growTimer);
        });
        this.pedalAnimation.write(compound);
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 100, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_183000_F() {
        return true;
    }

    private boolean shouldShutBud() {
        boolean hasAFruit = false;
        for (Map.Entry<BudSide, SideData> data : this.sideData.entrySet()) {
            if (!data.getValue().hasFruit(this.field_145850_b)) continue;
            hasAFruit = true;
        }
        return !hasAFruit;
    }

    public int calculateFruitMaxHeight() {
        int[] maxHeights = new int[4];
        for (BudSide sides : BudSide.values()) {
            int y = 1;
            while (y < 7 && this.field_145850_b.func_175623_d(sides.offsetPosition(this.field_174879_c.func_177981_b(y)))) {
                maxHeights[sides.id] = y++;
            }
        }
        return MathUtil.getLowestValueInIntArray((int[])maxHeights);
    }

    static class SideData {
        @Nullable
        private UUID fruitUUID;
        private int growTimer;
        private boolean growing;

        SideData() {
        }

        public BolloomFruitEntity getFruit(World world) {
            Entity entity;
            if (!world.func_201670_d() && this.fruitUUID != null && (entity = ((ServerWorld)world).func_217461_a(this.fruitUUID)) instanceof BolloomFruitEntity) {
                return (BolloomFruitEntity)entity;
            }
            return null;
        }

        public boolean hasFruit(World world) {
            if (this.growing) {
                return true;
            }
            return this.getFruit(world) != null && this.getFruit(world).func_70089_S() && !this.getFruit(world).isUntied();
        }
    }

    public static enum BudSide {
        NORTH(Direction.NORTH, 0),
        EAST(Direction.EAST, 1),
        SOUTH(Direction.SOUTH, 2),
        WEST(Direction.WEST, 3);

        private final Direction direction;
        public final int id;

        private BudSide(Direction direction, int id) {
            this.direction = direction;
            this.id = id;
        }

        public BlockPos offsetPosition(BlockPos pos) {
            return pos.func_177972_a(this.direction);
        }

        public static BudSide random(Random rand) {
            return BudSide.values()[rand.nextInt(BudSide.values().length)];
        }
    }
}

