/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.configs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.world.gen.feature.IFeatureConfig;

public final class CorrockBranchConfig
implements IFeatureConfig {
    public static final Codec<CorrockBranchConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.field_235877_b_.listOf().fieldOf("valid_ground_states").forGetter(config -> ImmutableList.copyOf(config.validGround)), (App)Codec.FLOAT.fieldOf("crown_chance").forGetter(config -> Float.valueOf(config.crownChance)), (App)Codec.FLOAT.fieldOf("decorated_branch_chance").forGetter(config -> Float.valueOf(config.decoratedBranchChance))).apply((Applicative)instance, CorrockBranchConfig::new));
    private final Set<BlockState> validGround;
    private final float crownChance;
    private final float decoratedBranchChance;

    public CorrockBranchConfig(List<BlockState> validGround, float crownChance, float decoratedBranchChance) {
        this.validGround = Sets.newHashSet(validGround);
        this.crownChance = crownChance;
        this.decoratedBranchChance = decoratedBranchChance;
    }

    public boolean isValidGround(BlockState state) {
        return this.validGround.contains(state);
    }

    public float getCrownChance() {
        return this.crownChance;
    }

    public float getDecoratedBranchChance() {
        return this.decoratedBranchChance;
    }
}

