/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features.corrock.tower;

import com.minecraftabnormals.abnormals_core.core.util.GenerationPiece;
import com.minecraftabnormals.endergetic.api.util.GenerationUtils;
import com.minecraftabnormals.endergetic.common.world.configs.CorrockTowerConfig;
import com.minecraftabnormals.endergetic.common.world.features.corrock.AbstractCorrockFeature;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;

public final class LargeCorrockTowerFeature
extends AbstractCorrockFeature<CorrockTowerConfig> {
    public LargeCorrockTowerFeature(Codec<CorrockTowerConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, CorrockTowerConfig config) {
        Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (world.func_175623_d(pos) && belowBlock == EEBlocks.CORROCK_END_BLOCK.get()) {
            BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
            ArrayList<BlockPos> corrockPositions = new ArrayList<BlockPos>();
            if (LargeCorrockTowerFeature.tryToMakeGroundSuitable(world, corrockPositions, pos)) {
                Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> top;
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                int startX = pos.func_177958_n();
                int startY = pos.func_177956_o();
                int startZ = pos.func_177952_p();
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 4; ++x) {
                        for (int z = 0; z < 4; ++z) {
                            mutable.func_181079_c(startX + x, startY + y, startZ + z);
                            if (!world.func_175623_d((BlockPos)mutable)) {
                                return false;
                            }
                            corrockPositions.add(mutable.func_185334_h());
                        }
                    }
                }
                LargeCorrockTowerFeature.tryToMakeSide(world, rand, corrockPositions, pos.func_177978_c().func_177965_g(rand.nextInt(2) + 1), Direction.NORTH);
                LargeCorrockTowerFeature.tryToMakeSide(world, rand, corrockPositions, pos.func_177976_e().func_177970_e(rand.nextInt(2) + 1), Direction.WEST);
                LargeCorrockTowerFeature.tryToMakeSide(world, rand, corrockPositions, pos.func_177970_e(4).func_177965_g(rand.nextInt(2) + 1), Direction.SOUTH);
                LargeCorrockTowerFeature.tryToMakeSide(world, rand, corrockPositions, pos.func_177965_g(4).func_177970_e(rand.nextInt(2) + 1), Direction.EAST);
                int height = rand.nextInt(config.getMaxHeight() - config.getMinHeight() + 1) + config.getMinHeight();
                float crownChance = config.getCrownChance();
                GenerationPiece corrockCrowns = LargeCorrockTowerFeature.tryToMakeMiddle(world, rand, corrockPositions, pos, height, crownChance);
                if (corrockCrowns != null && (top = LargeCorrockTowerFeature.tryToMakeLargeTop(world, rand, corrockPositions, pos.func_177981_b(3 + height), crownChance, config.getChorusChance())) != null) {
                    corrockPositions.forEach(corrockPos -> world.func_180501_a(corrockPos, corrockBlockState, 2));
                    corrockCrowns.place((IWorld)world);
                    ((GenerationPiece)top.getFirst()).place((IWorld)world);
                    ((List)top.getSecond()).forEach(chorusPlantPart -> chorusPlantPart.placeGrowth((IWorld)world, rand));
                    BlockPos topMiddle = pos.func_177981_b(4 + height);
                    BlockState corrockPlantState = (BlockState)CORROCK_STATE.func_179281_c();
                    for (int i = 0; i < 16; ++i) {
                        if (!(rand.nextFloat() < 0.6f) || !world.func_175623_d((BlockPos)mutable.func_239621_a_((Vector3i)topMiddle, rand.nextInt(7) - rand.nextInt(7), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(7) - rand.nextInt(7))) || world.func_180495_p(mutable.func_177977_b()).func_177230_c() != CORROCK_BLOCK_BLOCK) continue;
                        world.func_180501_a((BlockPos)mutable, corrockPlantState, 2);
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean tryToMakeGroundSuitable(ISeedReader world, List<BlockPos> positions, BlockPos origin) {
        int startZ;
        int startY;
        BlockPos down = origin.func_177979_c(2);
        int startX = down.func_177958_n();
        boolean isSolidBelow = GenerationUtils.isAreaCompletelySolid((IWorld)world, startX - 2, startY = down.func_177956_o(), (startZ = down.func_177952_p()) - 2, startX + 2, startY, startZ + 2);
        if (isSolidBelow) {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 4; ++x) {
                    for (int z = 0; z < 4; ++z) {
                        mutable.func_181079_c(startX + x, startY + y, startZ + z);
                        BlockPos immutable = mutable.func_185334_h();
                        if (!world.func_180495_p(immutable).func_185904_a().func_76222_j()) continue;
                        positions.add(immutable);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static void tryToMakeSide(ISeedReader world, Random rand, List<BlockPos> positions, BlockPos origin, Direction facing) {
        ArrayList<BlockPos> toAdd = new ArrayList<BlockPos>();
        if (world.func_175623_d(origin)) {
            LargeCorrockTowerFeature.tryToMakeSidePillar(world, rand, 0, rand.nextInt(2) + 2, origin, toAdd, facing);
        }
        positions.addAll(toAdd);
    }

    private static void tryToMakeSidePillar(ISeedReader world, Random rand, int index, int height, BlockPos origin, List<BlockPos> positions, Direction facing) {
        BlockPos.Mutable mutable = origin.func_239590_i_();
        int startX = origin.func_177958_n();
        int startY = origin.func_177956_o();
        int startZ = origin.func_177952_p();
        for (int y = 0; y < height; ++y) {
            BlockPos offset;
            mutable.func_181079_c(startX, startY + y, startZ);
            if (!world.func_175623_d((BlockPos)mutable)) {
                positions.clear();
                return;
            }
            positions.add(mutable.func_185334_h());
            if (!LargeCorrockTowerFeature.tryToBuildPillarDownwards(world, positions, origin)) {
                positions.clear();
                return;
            }
            if (index >= 1 || !world.func_175623_d(offset = origin.func_177972_a(rand.nextBoolean() ? facing.func_176746_e() : facing.func_176735_f()))) continue;
            LargeCorrockTowerFeature.tryToMakeSidePillar(world, rand, index + 1, height - 1, offset, positions, facing);
        }
    }

    private static boolean tryToBuildPillarDownwards(ISeedReader world, List<BlockPos> positions, BlockPos origin) {
        boolean foundGround = false;
        BlockPos.Mutable mutable = origin.func_239590_i_();
        for (int y = 0; y < 4; ++y) {
            mutable.func_196234_d(0, -1, 0);
            if (!world.func_180495_p((BlockPos)mutable).func_185904_a().func_76222_j()) {
                foundGround = true;
                continue;
            }
            positions.add(mutable.func_185334_h());
        }
        return foundGround;
    }

    @Nullable
    private static GenerationPiece tryToMakeMiddle(ISeedReader world, Random rand, List<BlockPos> positions, BlockPos origin, int height, float crownChance) {
        int startX = origin.func_177958_n() + 1;
        int startY = origin.func_177956_o() + 3;
        int startZ = origin.func_177952_p() + 1;
        BlockPos.Mutable innerMutable = origin.func_239590_i_();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < 2; ++x) {
                for (int z = 0; z < 2; ++z) {
                    innerMutable.func_181079_c(startX + x, startY + y, startZ + z);
                    if (!world.func_175623_d((BlockPos)innerMutable)) {
                        return null;
                    }
                    positions.add(innerMutable.func_185334_h());
                }
            }
        }
        GenerationPiece corrockCrowns = new GenerationPiece((iWorld, blockPart) -> true);
        BlockPos.Mutable roundTripMutable = origin.func_239590_i_();
        Direction currentDirection = Direction.NORTH;
        crownChance /= (float)height;
        for (int i = 0; i < 12; ++i) {
            if (i % 3 != 0) {
                roundTripMutable.func_189536_c(currentDirection);
                Direction ccwDirection = currentDirection.func_176735_f();
                BlockState crownState = LargeCorrockTowerFeature.getCorrockCrownWall(ccwDirection);
                for (int y = 0; y < height; ++y) {
                    roundTripMutable.func_185336_p(startY + y);
                    if (world.func_175623_d((BlockPos)roundTripMutable)) {
                        BlockPos crownOffset;
                        positions.add(roundTripMutable.func_185334_h());
                        if (!(rand.nextFloat() < crownChance) || !world.func_175623_d(crownOffset = roundTripMutable.func_177972_a(ccwDirection))) continue;
                        corrockCrowns.addBlockPiece(crownState, crownOffset);
                        continue;
                    }
                    return null;
                }
                continue;
            }
            if (i != 0) {
                roundTripMutable.func_189536_c(currentDirection);
            }
            currentDirection = currentDirection.func_176746_e();
            if (!(rand.nextFloat() < 0.8f)) continue;
            int cornerTop = startY + height;
            roundTripMutable.func_185336_p(cornerTop - 1);
            if (!world.func_175623_d((BlockPos)roundTripMutable)) continue;
            positions.add(roundTripMutable.func_185334_h());
            if (height <= 2 || !(rand.nextFloat() < 0.25f)) continue;
            roundTripMutable.func_185336_p(cornerTop - 2);
            if (!world.func_175623_d((BlockPos)roundTripMutable)) continue;
            positions.add(roundTripMutable.func_185334_h());
        }
        return corrockCrowns;
    }

    @Nullable
    private static Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> tryToMakeLargeTop(ISeedReader world, Random rand, List<BlockPos> positions, BlockPos origin, float crownChance, float chorusChance) {
        BlockPos.Mutable mutable;
        int startZ;
        int startY;
        int startX = origin.func_177958_n();
        if (LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX, startY = origin.func_177956_o(), startZ = origin.func_177952_p(), startX + 3, startY, startZ + 3, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX + 1, startY, startZ - 1, startX + 2, startY, startZ - 1, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX - 1, startY, startZ + 1, startX - 1, startY, startZ + 2, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX + 4, startY, startZ + 1, startX + 4, startY, startZ + 2, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX + 1, startY, startZ + 4, startX + 2, startY, startZ + 4, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX - 1, ++startY, startZ, startX + 4, startY, startZ + 3, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX, startY, startZ - 1, startX + 3, startY, startZ - 1, positions) && LargeCorrockTowerFeature.tryToFillWithCorrockBlock(world, startX, startY, startZ + 4, startX + 3, startY, startZ + 4, positions) && LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)(mutable = new BlockPos.Mutable()).func_181079_c(startX + rand.nextInt(2) + 1, startY, startZ - 2), positions) && LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX - 2, startY, startZ + rand.nextInt(2) + 1), positions) && LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX + rand.nextInt(2) + 1, startY, startZ + 5), positions) && LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX + 5, startY, startZ + rand.nextInt(2) + 1), positions)) {
            GenerationPiece crowns = new GenerationPiece((iWorld, blockPart) -> true);
            ArrayList<BlockPos> corners = new ArrayList<BlockPos>();
            if (LargeCorrockTowerFeature.tryToPlaceCorrockBlockWithCrown(world, rand, (BlockPos)mutable.func_181079_c(startX - 1, ++startY, startZ - 1), positions, rand.nextBoolean() ? Direction.WEST : Direction.NORTH, crowns, corners, crownChance) && LargeCorrockTowerFeature.tryToPlaceCorrockBlockWithCrown(world, rand, (BlockPos)mutable.func_181079_c(startX + 4, startY, startZ - 1), positions, rand.nextBoolean() ? Direction.EAST : Direction.NORTH, crowns, corners, crownChance) && LargeCorrockTowerFeature.tryToPlaceCorrockBlockWithCrown(world, rand, (BlockPos)mutable.func_181079_c(startX + 4, startY, startZ + 4), positions, rand.nextBoolean() ? Direction.EAST : Direction.SOUTH, crowns, corners, crownChance) && LargeCorrockTowerFeature.tryToPlaceCorrockBlockWithCrown(world, rand, (BlockPos)mutable.func_181079_c(startX - 1, startY, startZ + 4), positions, rand.nextBoolean() ? Direction.WEST : Direction.SOUTH, crowns, corners, crownChance) && LargeCorrockTowerFeature.tryToPlaceCrownedCorrockSquare(world, rand, startY, startX, startZ - 2, startX + 3, startZ - 2, positions, Direction.NORTH, crowns, crownChance) && LargeCorrockTowerFeature.tryToPlaceCrownedCorrockSquare(world, rand, startY, startX - 2, startZ, startX - 2, startZ + 3, positions, Direction.WEST, crowns, crownChance) && LargeCorrockTowerFeature.tryToPlaceCrownedCorrockSquare(world, rand, startY, startX + 5, startZ, startX + 5, startZ + 3, positions, Direction.EAST, crowns, crownChance) && LargeCorrockTowerFeature.tryToPlaceCrownedCorrockSquare(world, rand, startY, startX, startZ + 5, startX + 3, startZ + 5, positions, Direction.SOUTH, crowns, crownChance)) {
                if (rand.nextBoolean()) {
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX - 1, startY, startZ), positions)) {
                        corners.add(mutable.func_185334_h());
                    }
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX, startY, startZ - 1), positions)) {
                        corners.add(mutable.func_185334_h());
                    }
                }
                if (rand.nextBoolean()) {
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX + 4, startY, startZ), positions)) {
                        corners.add(mutable.func_185334_h());
                    }
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX + 3, startY, startZ - 1), positions)) {
                        corners.add(mutable.func_185334_h());
                    }
                }
                if (rand.nextBoolean()) {
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX + 4, startY, startZ + 3), positions)) {
                        corners.add(mutable.func_185334_h());
                    }
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX + 3, startY, startZ + 4), positions)) {
                        corners.add(mutable.func_185334_h());
                    }
                }
                if (rand.nextBoolean()) {
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX, startY, startZ + 4), positions)) {
                        corners.add(mutable.func_185334_h());
                    }
                    if (LargeCorrockTowerFeature.tryToPlaceCorrockBlock(world, (BlockPos)mutable.func_181079_c(startX - 1, startY, startZ + 3), positions)) {
                        corners.add(mutable.func_185334_h());
                    }
                }
                ArrayList<AbstractCorrockFeature.ChorusPlantPart> chorusPlantParts = new ArrayList<AbstractCorrockFeature.ChorusPlantPart>();
                int y = startY - 1;
                int cornerX = startX - 1;
                int cornerZ = startZ - 1;
                for (int x = 0; x < 5; ++x) {
                    for (int z = 0; z < 5; ++z) {
                        BlockPos up;
                        mutable.func_181079_c(cornerX + x, y, cornerZ + z);
                        if (!(rand.nextFloat() < chorusChance) || !world.func_175623_d(up = mutable.func_177984_a()) || corners.contains(up) || !LargeCorrockTowerFeature.isNotCloseToAnotherGrowth(chorusPlantParts, (BlockPos)mutable)) continue;
                        chorusPlantParts.add(new AbstractCorrockFeature.ChorusPlantPart(mutable.func_185334_h()));
                    }
                }
                return Pair.of((Object)crowns, chorusPlantParts);
            }
        }
        return null;
    }
}

